/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.home;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Security;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.teleportation.home.UtilHome;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandSethome
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandSethome(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.home.create";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        Player p = (Player)cs;
        String name = "home";
        if (args.length != 0) {
            name = args[0];
        }
        Files playerData = new Files(this.plugin.foundryConfig, this.plugin);
        playerData.load(playerData.playerDataFile(p));
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        if (new Security(this.plugin.foundryConfig).hasSpecialCharacters(name.toLowerCase())) {
            playerData.close();
            msg.send("home", "specialchars");
            return true;
        }
        UtilHome hu = new UtilHome(this.plugin);
        int homeLimit = new UtilPermission(this.plugin, cs).getHomesLimit(p);
        if (hu.getHomeCount(p) > homeLimit && homeLimit != -1) {
            msg.send("home", "hitlimit");
            return true;
        }
        if (hu.create(name.toLowerCase(), (OfflinePlayer)p, p.getLocation())) {
            msg.send("home", "created", new String[]{name});
        } else {
            msg.send("home", "cantcreate", new String[]{name});
        }
        return true;
    }
}

