/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.orientation;

import java.util.List;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.external.command.FoundryPlayerCommand;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandNear
extends FoundryPlayerCommand {
    private final Essence plugin;

    public CommandNear(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.orientation.near";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        int radius;
        int defaultRadius;
        UtilMessage msg = new UtilMessage(this.plugin, cs);
        Player p = (Player)cs;
        int n = defaultRadius = this.plugin.config.get("teleportation.near.default-radius") != null ? (Integer)this.plugin.config.get("teleportation.near.default-radius") : 200;
        if (args.length == 0) {
            radius = defaultRadius;
        } else {
            try {
                int maxRadius;
                radius = Integer.parseInt(args[0]);
                if (radius <= 0) {
                    msg.send("near", "invalidradius", new String[]{args[0]});
                    return true;
                }
                int n2 = maxRadius = this.plugin.config.get("teleportation.near.max-radius") != null ? (Integer)this.plugin.config.get("teleportation.near.max-radius") : 50000;
                if (radius > maxRadius) {
                    msg.send("near", "greaterthanmax", new String[]{args[0], String.valueOf(maxRadius)});
                    return true;
                }
            }
            catch (NumberFormatException e) {
                msg.send("near", "invalidnumber", new String[]{args[0]});
                return true;
            }
        }
        UtilTeleport tp = new UtilTeleport(this.plugin);
        List<Player> nearbyPlayers = p.getLocation().getNearbyPlayers((double)radius).stream().filter(player -> !player.getUniqueId().equals(p.getUniqueId())).filter(player -> !player.hasMetadata("vanish") && !player.hasMetadata("vanished")).filter(player -> tp.teleportToggleCheck(p, (Player)player)).toList();
        if (nearbyPlayers.isEmpty()) {
            msg.send("near", "noplayers", new String[]{String.valueOf(radius)});
        } else {
            StringBuilder playerList = new StringBuilder();
            for (Player nearby : nearbyPlayers) {
                int distance = (int)nearby.getLocation().distance(p.getLocation());
                if (!playerList.isEmpty()) {
                    playerList.append(", ");
                }
                playerList.append(nearby.getName()).append(" (").append(distance).append("m)");
            }
            msg.send("near", "playersfound", new String[]{String.valueOf(nearbyPlayers.size()), playerList.toString()});
        }
        return true;
    }
}

