/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.teleportation.tp;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UtilTeleportRequest {
    private final Essence plugin;

    public UtilTeleportRequest(Essence plugin) {
        this.plugin = plugin;
    }

    public void createRequest(String requester, String requested, boolean teleportToRequester) {
        this.deleteFromRequester(requester);
        if (teleportToRequester) {
            this.plugin.teleportRequests.put(requested, new String[]{requester, "true"});
        } else {
            this.plugin.teleportRequests.put(requested, new String[]{requester, "false"});
        }
    }

    public boolean deleteFromRequester(String requester) {
        boolean found = false;
        if (this.plugin.teleportRequests == null) {
            return false;
        }
        Iterator iterator = this.plugin.teleportRequests.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String[] values = (String[])entry.getValue();
            if (values.length <= 0 || !values[0].equalsIgnoreCase(requester)) continue;
            iterator.remove();
            found = true;
        }
        return found;
    }

    public void deleteFromRequested(String requested) {
        if (this.plugin.teleportRequests == null) {
            return;
        }
        this.plugin.teleportRequests.remove(requested);
    }

    public boolean acceptRequest(String requested) {
        String[] tpaRequest = (String[])this.plugin.teleportRequests.get(requested);
        if (tpaRequest == null) {
            return false;
        }
        String requesterName = tpaRequest[0];
        Player requesterPlayer = this.plugin.getServer().getPlayer(requesterName);
        UtilTeleport tpu = new UtilTeleport(this.plugin);
        if (Objects.equals(tpaRequest[1], "true")) {
            tpu.doTeleport(this.plugin.getServer().getPlayer(requested), this.plugin.getServer().getPlayer(requesterName).getLocation(), 0, true);
        } else {
            tpu.doTeleport(this.plugin.getServer().getPlayer(requesterName), this.plugin.getServer().getPlayer(requested).getLocation(), 0, true);
        }
        if (requesterPlayer != null) {
            new UtilMessage(this.plugin, (CommandSender)requesterPlayer).send("teleport", "requestaccepted", new String[]{requested});
        }
        this.deleteFromRequested(requested);
        return true;
    }
}

