/*
 * Decompiled with CFR 0.152.
 */
package com.tamaized.voidfog;

import com.tamaized.voidfog.VoidFog;
import com.tamaized.voidfog.api.Voidable;
import net.minecraft.class_11398;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_7285;
import net.minecraft.class_757;
import net.minecraft.class_9779;

public class FogRenderer
extends class_11398 {
    private float lastFogDistance = 1000.0f;

    public void method_42591(class_7285 data, class_1297 cameraEntity, class_2338 cameraPos, class_638 world, float viewDistance, class_9779 tickCounter) {
        super.method_42591(data, cameraEntity, cameraPos, world, viewDistance, tickCounter);
        float distance = this.getFogDistance(world, cameraEntity, tickCounter.method_60636());
        float blendDelta = FogRenderer.getFogBlendingDelta(cameraEntity);
        float density = class_3532.method_15363((float)((float)((Integer)VoidFog.config.fogDensity.get()).intValue() / 100.0f), (float)0.0f, (float)1.0f);
        data.field_60582 = class_3532.method_16439((float)blendDelta, (float)FogRenderer.getFogStart(distance, density), (float)data.field_60582);
        data.field_60584 = class_3532.method_16439((float)blendDelta, (float)FogRenderer.getFogEnd(distance, density), (float)data.field_60584);
    }

    public boolean method_42593(class_5636 submersionType, class_1297 cameraEntity) {
        class_1309 l;
        return (Boolean)VoidFog.config.enabled.get() != false && super.method_42593(submersionType, cameraEntity) && (!(cameraEntity instanceof class_1309) || !(l = (class_1309)cameraEntity).method_6059(class_1294.field_5919)) && Voidable.of(cameraEntity.method_73183()).hasDepthFog(cameraEntity, cameraEntity.method_73183());
    }

    private float getFogDistance(class_638 world, class_1297 cameraEntity, float tickDelta) {
        class_1309 l;
        float distance;
        Voidable voidable = Voidable.of((class_1937)world);
        float viewDistance = class_310.method_1551().field_1773.method_3193();
        double fogDistance = (double)FogRenderer.getLight(cameraEntity) / 16.0 + FogRenderer.getAltitude(voidable, (class_1937)world, cameraEntity) / (double)((float)((Integer)VoidFog.config.maxFogHeight.get()).intValue() * FogRenderer.getDifficultyMultiplier((class_1937)world));
        float f = distance = fogDistance >= 1.0 ? viewDistance : (float)class_3532.method_15350((double)(100.0 * Math.pow(Math.max(fogDistance, 0.0), 2.0)), (double)5.0, (double)viewDistance);
        if (cameraEntity instanceof class_1309 && (l = (class_1309)cameraEntity).method_6059(class_1294.field_5925)) {
            distance *= 4.0f * class_757.method_3174((class_1309)l, (float)tickDelta);
        }
        this.lastFogDistance = distance = class_3532.method_16439((float)(tickDelta / (float)(distance > this.lastFogDistance ? 20 : 10)), (float)this.lastFogDistance, (float)distance);
        return distance;
    }

    private static float getFogStart(float distance, float density) {
        float factor = 0.55f * (1.0f - (distance - 5.0f) / 127.0f);
        return distance * Math.max(0.0f, factor) - (1.0f - density) * 9.9f;
    }

    private static float getFogEnd(float distance, float density) {
        return distance + (1.0f - density) * 9.9f;
    }

    public static float getFogBlendingDelta(class_1297 entity) {
        if (((Boolean)VoidFog.config.prettyFog.get()).booleanValue()) {
            return 0.0f;
        }
        float entityAltitude = (float)FogRenderer.getAltitude(Voidable.of(entity.method_73183()), entity.method_73183(), entity);
        float fogTransitionDistance = Math.max(0.0f, ((Float)VoidFog.config.fogTransitionDistance.get()).floatValue());
        float maxFogAltitude = (float)((Integer)VoidFog.config.maxFogHeight.get()).intValue() - fogTransitionDistance;
        return class_3532.method_15363((float)((entityAltitude - maxFogAltitude) / fogTransitionDistance), (float)0.0f, (float)1.0f);
    }

    public static float getDifficultyMultiplier(class_1937 world) {
        return (Boolean)VoidFog.config.scaleWithDifficulty.get() != false ? world.method_8407().method_5461() + 1 : 1;
    }

    public static int getLight(class_1297 entity) {
        entity = FogRenderer.getCorrectEntity(entity);
        class_2338 pos = class_2338.method_49638((class_2374)entity.method_33571());
        if (((Boolean)VoidFog.config.respectTorches.get()).booleanValue()) {
            return entity.method_73183().method_22339(pos);
        }
        return entity.method_73183().method_8314(class_1944.field_9284, pos);
    }

    public static double getAltitude(Voidable voidable, class_1937 world, class_1297 entity) {
        return voidable.isVoidFogDisabled(entity = FogRenderer.getCorrectEntity(entity), world) ? (double)((Integer)VoidFog.config.maxFogHeight.get() + 1) : entity.method_23318() - (double)world.method_31607();
    }

    public static class_1297 getCorrectEntity(class_1297 entity) {
        while (entity.method_5765() && !entity.method_55667().method_26215()) {
            entity = entity.method_5854();
        }
        return entity;
    }
}

