/*
 * Decompiled with CFR 0.152.
 */
package com.tamaized.voidfog;

import com.tamaized.voidfog.FogRenderer;
import com.tamaized.voidfog.api.Voidable;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;

public class InsanityEngine {
    private int timeToNextSound = 0;
    private int insanityBuildUp;
    private final Sound[] events = new Sound[]{Sound.of(class_3417.field_14937), Sound.of((class_6880<class_3414>)class_3417.field_14564), Sound.of(class_3417.field_15057), Sound.of(class_3417.field_15023), Sound.of(class_3417.field_14823), Sound.of(class_3417.field_14561), Sound.of(class_3417.field_17609), Sound.of(class_3417.field_14924), Sound.of((class_6880<class_3414>)class_3417.field_15015), Sound.of(class_3417.field_23673), Sound.of(class_3417.field_14961), Sound.of(class_3417.field_14621)};

    public void update(class_1937 world, class_1297 entity, Voidable dimension) {
        if (!dimension.hasInsanity(class_2338.method_49638((class_2374)entity.method_33571()), world)) {
            return;
        }
        float brightness = FogRenderer.getLight(entity);
        if (brightness > 0.3f) {
            this.insanityBuildUp = 0;
            return;
        }
        double y = entity.method_23320();
        int rarity = this.getRarity(y, world);
        this.insanityBuildUp = (int)((double)this.insanityBuildUp + (y < 0.0 ? -y : 1.0));
        if (this.insanityBuildUp > 100) {
            this.timeToNextSound -= this.insanityBuildUp / 60;
        }
        if (this.timeToNextSound-- > 0) {
            return;
        }
        this.timeToNextSound = 20 + rarity + world.field_9229.method_43048(Math.max(250, 120 + rarity));
        this.doAScary(world, entity.method_24515());
    }

    private int getRarity(double y, class_1937 world) {
        y -= (double)world.method_31607();
        return 1000 * (int)(y += 1.0);
    }

    private void doAScary(class_1937 world, class_2338 pos) {
        Sound event = this.events[world.field_9229.method_43048(this.events.length)];
        float pitch = 1.0f + world.field_9229.method_43057();
        event.play(world, pos, 1.0f, pitch);
    }

    static interface Sound {
        public static Sound of(class_3414 event) {
            return (world, pos, volume, pitch) -> world.method_8396((class_1297)class_310.method_1551().field_1724, pos, event, class_3419.field_15256, volume, pitch);
        }

        public static Sound of(class_6880<class_3414> event) {
            return (world, pos, volume, pitch) -> world.method_8465((class_1297)class_310.method_1551().field_1724, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), event, class_3419.field_15256, volume, pitch, world.method_8409().method_43055());
        }

        public void play(class_1937 var1, class_2338 var2, float var3, float var4);
    }
}

