/*
 * Decompiled with CFR 0.152.
 */
package com.tamaized.voidfog;

import com.minelittlepony.common.util.settings.Config;
import com.minelittlepony.common.util.settings.Setting;
import java.nio.file.Path;

public class Settings
extends Config {
    public final Setting<Boolean> enabled = this.value("enabled", true);
    public final Setting<Boolean> scaleWithDifficulty = this.value("scaleWithDifficulty", true).addComment("Default: true").addComment("Makes fog start at shallower depths as difficulty increases");
    public final Setting<Boolean> disableInCreative = this.value("disableInCreative", true).addComment("Default: true").addComment("Disables all void fog effects when in creative mode");
    public final Setting<Boolean> respectTorches = this.value("respectTorches", true).addComment("Default: true").addComment("Fog will retreat from areas lit by torches and other light sources");
    public final Setting<Boolean> prettyFog = this.value("prettyFog", false).addComment("Default: false").addComment("Enables an alternate method of rendering fog that gives softed edges that some may find more visually pleasing");
    public final Setting<Integer> voidParticleDensity = this.value("voidParticleDensity", 1000).addComment("Default: 1000").addComment("The particle density when near the void");
    public final Setting<Integer> fogDensity = this.value("fogDensity", 100).addComment("Default: 100").addComment("Min: 0, Max: 1").addComment("The percentage particle density not near the void. voidParticleDensity is MULTIPLIED by this value/100");
    public final Setting<Integer> maxFogHeight = this.value("maxFogHeight", 32).addComment("Default: 32").addComment("Maximum height in blocks from the bottom of the world that fog will reach.").addComment("If scaleWithDifficulty is enabled, this value is MULTIPLIED by the current area's difficulty");
    public final Setting<Float> fogTransitionDistance = this.value("fogTransitionDistance", Float.valueOf(15.0f)).addComment("Default: 15").addComment("Distance in blocks that you have to approach to the border defined by maxFogHeight for the game to start transitioning from regular to void fog");
    public final Setting<Boolean> imABigBoi = this.value("imABigBoi", false).addComment("Default: false").addComment("Adds minimal jumpscares hanging around in dark areas for long amounts of time.");

    protected Settings(Path path) {
        super(HEIRARCHICAL_JSON_ADAPTER, path);
    }

    public float setParticleDensity(float density) {
        float f = density > 9997.0f ? 10000.0f : (density = density < 3.0f ? 0.0f : density);
        if (Math.abs(density - 1000.0f) < 30.0f) {
            density = 1000.0f;
        }
        return ((Integer)this.voidParticleDensity.set((Object)Math.max(0, (int)density))).intValue();
    }

    public float setFogHeight(float height) {
        return ((Integer)this.maxFogHeight.set((Object)((int)height))).intValue();
    }

    public float setFogDensity(float density) {
        density = density > 97.0f ? 100.0f : (density < 3.0f ? 0.0f : density);
        return ((Integer)this.fogDensity.set((Object)((int)density))).intValue();
    }

    public float setFadeStart(float value) {
        return ((Float)this.fogTransitionDistance.set((Object)Float.valueOf(Math.max(0.0f, value)))).floatValue();
    }
}

