/*
 * Decompiled with CFR 0.152.
 */
package com.baranhan123.autosmelting.util.handlers;

import com.baranhan123.autosmelting.Main;
import com.baranhan123.autosmelting.network.Networking;
import com.baranhan123.autosmelting.network.SendParticles;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class BlockBreakEvent {
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        SingleRecipeInput input;
        if (event.getPlayer().isCreative()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        Level level = (Level)event.getLevel();
        ItemStack mainHandItem = player.getMainHandItem();
        Registry registry = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Optional autoSmeltHolder = registry.getHolder(Main.AUTO_SMELT_KEY);
        if (autoSmeltHolder.isEmpty() || EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)autoSmeltHolder.get()), (ItemStack)mainHandItem) == 0) {
            return;
        }
        BlockState state = event.getState();
        ItemStack blockStack = new ItemStack((ItemLike)state.getBlock());
        RecipeManager recipeManager = level.getRecipeManager();
        Optional recipe = recipeManager.getRecipeFor(RecipeType.SMELTING, (RecipeInput)(input = new SingleRecipeInput(blockStack)), level);
        if (recipe.isPresent()) {
            ItemStack resultItem = ((SmeltingRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
            int fortuneLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE), (ItemStack)mainHandItem);
            if (fortuneLevel > 0) {
                int bonusRoll = level.random.nextInt(fortuneLevel + 2) - 1;
                if (bonusRoll < 0) {
                    bonusRoll = 0;
                }
                int multiplier = bonusRoll + 1;
                resultItem.setCount(resultItem.getCount() * multiplier);
            }
            this.dropItemAndXp(level, event.getPos(), resultItem, 1);
            mainHandItem.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            event.setCanceled(true);
            level.removeBlock(event.getPos(), false);
            this.sendParticles(player, event.getPos());
        }
    }

    private void dropItemAndXp(Level level, BlockPos pos, ItemStack stack, int xpAmount) {
        if (level.isClientSide) {
            return;
        }
        Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        if (xpAmount > 0) {
            level.addFreshEntity((Entity)new ExperienceOrb(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), xpAmount));
        }
    }

    private void sendParticles(ServerPlayer player, BlockPos pos) {
        Networking.sendToPlayer(player, new SendParticles(pos.getX(), (double)pos.getY() - 0.8, pos.getZ(), 1.0f, 1.0f, 0));
    }
}

