/*
 * Decompiled with CFR 0.152.
 */
package com.ticticboooom.twerkitmeal;

import com.ticticboooom.twerkitmeal.config.CommonConfig;
import com.ticticboooom.twerkitmeal.config.TwerkConfig;
import com.ticticboooom.twerkitmeal.helper.FilterListHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="twerkitmeal")
public class TwerkItMeal {
    public static final String MOD_ID = "twerkitmeal";
    static final ForgeConfigSpec commonSpec;
    public static final CommonConfig COMMON_CONFIG;

    public TwerkItMeal() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "twerk-config.toml");
        MinecraftForge.EVENT_BUS.register((Object)new RegistryEvents());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON_CONFIG = (CommonConfig)specPair.getLeft();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        private final Map<UUID, Integer> crouchCount = new HashMap<UUID, Integer>();
        private final Map<UUID, Boolean> prevSneaking = new HashMap<UUID, Boolean>();
        private final Map<UUID, Integer> playerDistance = new HashMap<UUID, Integer>();

        @SubscribeEvent
        public void onTwerk(TickEvent.PlayerTickEvent event) {
            if (event.player.m_9236_().f_46443_) {
                return;
            }
            UUID uuid = event.player.m_20148_();
            if (!this.crouchCount.containsKey(uuid)) {
                this.crouchCount.put(uuid, 0);
                this.prevSneaking.put(uuid, event.player.m_6047_());
                this.playerDistance.put(uuid, 0);
            }
            ServerLevel world = (ServerLevel)event.player.m_9236_();
            if (event.player.m_20142_() && world.m_213780_().m_188500_() <= TwerkConfig.sprintGrowChance) {
                this.triggerGrowth(event, uuid);
            }
            boolean wasPlayerSneaking = this.prevSneaking.get(uuid);
            int playerCrouchCount = this.crouchCount.get(uuid);
            if (!event.player.m_6047_()) {
                this.prevSneaking.put(uuid, false);
                return;
            }
            if (wasPlayerSneaking && event.player.m_6047_()) {
                return;
            }
            if (!wasPlayerSneaking && event.player.m_6047_()) {
                this.prevSneaking.put(uuid, true);
                this.crouchCount.put(uuid, ++playerCrouchCount);
            }
            ServerPlayer player = (ServerPlayer)event.player;
            if (playerCrouchCount >= TwerkConfig.minCrouchesToApplyBonemeal && world.m_213780_().m_188500_() <= TwerkConfig.crouchGrowChance) {
                this.triggerGrowth(event, uuid);
            }
        }

        private void triggerGrowth(TickEvent.PlayerTickEvent event, UUID uuid) {
            this.crouchCount.put(uuid, 0);
            List<BlockPos> growables = this.getNearestBlocks(event.player.m_9236_(), event.player.m_20097_());
            HashSet grownDT = new HashSet();
            for (BlockPos growablePos : growables) {
                BlockState blockState = event.player.m_9236_().m_8055_(growablePos);
                String regId = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()).toString();
                if (!FilterListHelper.shouldAllow(regId) || TwerkConfig.saplingsOnly && !ForgeRegistries.BLOCKS.tags().getTag(BlockTags.f_13104_).contains((Object)blockState.m_60734_())) continue;
                if (blockState.m_61138_((Property)CropBlock.f_52244_)) {
                    BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)event.player.m_9236_(), (BlockPos)growablePos, (Player)event.player);
                } else if (blockState.m_60734_() instanceof BonemealableBlock) {
                    BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)event.player.m_9236_(), (BlockPos)growablePos, (Player)event.player);
                }
                ((ServerLevel)event.player.m_9236_()).m_8624_((ServerPlayer)event.player, (ParticleOptions)ParticleTypes.f_123748_, false, (double)growablePos.m_123341_() + event.player.m_9236_().f_46441_.m_188500_(), (double)growablePos.m_123342_() + event.player.m_9236_().f_46441_.m_188500_(), (double)growablePos.m_123343_() + event.player.m_9236_().f_46441_.m_188500_(), 10, 0.0, 0.0, 0.0, 3.0);
            }
        }

        private List<BlockPos> getNearestBlocks(Level world, BlockPos pos) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            for (int x = -TwerkConfig.effectRadius; x <= TwerkConfig.effectRadius; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -TwerkConfig.effectRadius; z <= TwerkConfig.effectRadius; ++z) {
                        Block block = world.m_8055_(new BlockPos(x + pos.m_123341_(), y + pos.m_123342_(), z + pos.m_123343_())).m_60734_();
                        String regId = ForgeRegistries.BLOCKS.getKey((Object)block).toString();
                        if (!(block instanceof BonemealableBlock) || !FilterListHelper.shouldAllow(regId)) continue;
                        list.add(new BlockPos(x + pos.m_123341_(), y + pos.m_123342_(), z + pos.m_123343_()));
                    }
                }
            }
            return list;
        }

        private CompoundTag createCompoundTag(BlockPos pos) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("x", pos.m_123341_());
            nbt.m_128405_("y", pos.m_123342_());
            nbt.m_128405_("z", pos.m_123343_());
            return nbt;
        }
    }
}

