/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="iska_utils", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.DoubleValue SLOW_VECTOR_SPEED;
    private static final ModConfigSpec.DoubleValue MODERATE_VECTOR_SPEED;
    private static final ModConfigSpec.DoubleValue FAST_VECTOR_SPEED;
    private static final ModConfigSpec.DoubleValue EXTREME_VECTOR_SPEED;
    private static final ModConfigSpec.DoubleValue ULTRA_VECTOR_SPEED;
    private static final ModConfigSpec.DoubleValue VERTICAL_BOOST_FACTOR;
    private static final ModConfigSpec.DoubleValue ENTITY_VERTICAL_BOOST_FACTOR;
    private static final ModConfigSpec.BooleanValue VERTICAL_CONVEYOR_ENABLED;
    private static final ModConfigSpec.BooleanValue VERTICAL_CHARM_ENABLED;
    private static final ModConfigSpec.BooleanValue HORIZONTAL_CHARM_ENABLED;
    private static final ModConfigSpec.IntValue VECTOR_CHARM_ENERGY_CAPACITY;
    private static final ModConfigSpec.ConfigValue<List<? extends Integer>> VECTOR_CHARM_ENERGY_CONSUME;
    private static final ModConfigSpec.IntValue HELLFIRE_IGNITER_CONSUME;
    private static final ModConfigSpec.IntValue HELLFIRE_IGNITER_BUFFER;
    private static final ModConfigSpec.IntValue PORTABLE_DISLOCATOR_ENERGY_CAPACITY;
    private static final ModConfigSpec.IntValue PORTABLE_DISLOCATOR_ENERGY_CONSUME;
    static final ModConfigSpec SPEC;
    public static double slowVectorSpeed;
    public static double moderateVectorSpeed;
    public static double fastVectorSpeed;
    public static double extremeVectorSpeed;
    public static double ultraVectorSpeed;
    public static double verticalBoostFactor;
    public static double entityVerticalBoostFactor;
    public static boolean verticalConveyorEnabled;
    public static int hellfireIgniterConsume;
    public static int hellfireIgniterBuffer;
    public static boolean verticalCharmEnabled;
    public static boolean horizontalCharmEnabled;
    public static int vectorCharmEnergyCapacity;
    public static List<Integer> vectorCharmEnergyConsume;
    public static int portableDislocatorEnergyCapacity;
    public static int portableDislocatorEnergyConsume;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        slowVectorSpeed = (Double)SLOW_VECTOR_SPEED.get();
        moderateVectorSpeed = (Double)MODERATE_VECTOR_SPEED.get();
        fastVectorSpeed = (Double)FAST_VECTOR_SPEED.get();
        extremeVectorSpeed = (Double)EXTREME_VECTOR_SPEED.get();
        ultraVectorSpeed = (Double)ULTRA_VECTOR_SPEED.get();
        verticalBoostFactor = (Double)VERTICAL_BOOST_FACTOR.get();
        entityVerticalBoostFactor = (Double)ENTITY_VERTICAL_BOOST_FACTOR.get();
        verticalConveyorEnabled = (Boolean)VERTICAL_CONVEYOR_ENABLED.get();
        verticalCharmEnabled = (Boolean)VERTICAL_CHARM_ENABLED.get();
        horizontalCharmEnabled = (Boolean)HORIZONTAL_CHARM_ENABLED.get();
        vectorCharmEnergyCapacity = (Integer)VECTOR_CHARM_ENERGY_CAPACITY.get();
        vectorCharmEnergyConsume = new ArrayList<Integer>((Collection)VECTOR_CHARM_ENERGY_CONSUME.get());
        hellfireIgniterConsume = (Integer)HELLFIRE_IGNITER_CONSUME.get();
        hellfireIgniterBuffer = (Integer)HELLFIRE_IGNITER_BUFFER.get();
        portableDislocatorEnergyCapacity = (Integer)PORTABLE_DISLOCATOR_ENERGY_CAPACITY.get();
        portableDislocatorEnergyConsume = (Integer)PORTABLE_DISLOCATOR_ENERGY_CONSUME.get();
    }

    static {
        BUILDER.comment("Vector Things Configuration").push("vector_plates");
        SLOW_VECTOR_SPEED = BUILDER.comment("Speed of the Slow Vector Plate").defineInRange("000_slowVectorSpeed", 0.1, 0.0, 100.0);
        MODERATE_VECTOR_SPEED = BUILDER.comment("Speed of the Moderate Vector Plate").defineInRange("001_moderateVectorSpeed", 0.5, 0.0, 100.0);
        FAST_VECTOR_SPEED = BUILDER.comment("Speed of the Fast Vector Plate").defineInRange("002_fastVectorSpeed", 1.0, 0.0, 100.0);
        EXTREME_VECTOR_SPEED = BUILDER.comment("Speed of the Extreme Vector Plate").defineInRange("003_extremeVectorSpeed", 5.0, 0.0, 100.0);
        ULTRA_VECTOR_SPEED = BUILDER.comment("Speed of the Ultra Vector Plate").defineInRange("004_ultraVectorSpeed", 15.0, 0.0, 100.0);
        VERTICAL_BOOST_FACTOR = BUILDER.comment("Vertical boost factor for players on vertical vector plates").defineInRange("005_verticalBoostPlayer", 0.5, -100.0, 100.0);
        ENTITY_VERTICAL_BOOST_FACTOR = BUILDER.comment("Vertical boost factor for mobs/entities on vertical vector plates (higher values help heavier mobs overcome gravity)").defineInRange("006_verticalBoostEntity", 1.2, -100.0, 100.0);
        VERTICAL_CONVEYOR_ENABLED = BUILDER.comment("Enable vertical conveyor belts").define("007_verticalConveyorEnabled", true);
        VERTICAL_CHARM_ENABLED = BUILDER.comment("Enable vertical vector charm").define("100_verticalCharmEnabled", true);
        HORIZONTAL_CHARM_ENABLED = BUILDER.comment("Enable horizontal vector charm").define("101_horizontalCharmEnabled", true);
        VECTOR_CHARM_ENERGY_CAPACITY = BUILDER.comment("Energy capacity of the Vector Charm in RF/FE").defineInRange("102_vectorCharmEnergyCapacity", 1000000, 0, Integer.MAX_VALUE);
        VECTOR_CHARM_ENERGY_CONSUME = BUILDER.comment(new String[]{"Energy consumed per tick by the Vector Charm when active in RF/FE", "Array with 7 values for: [none, slow, moderate, fast, extreme, ultra, hover]"}).defineList("103_vectorCharmEnergyConsume", Arrays.asList(0, 5, 15, 30, 50, 100, 3), obj -> obj instanceof Integer && (Integer)obj >= 0);
        BUILDER.pop();
        BUILDER.comment("General Utilities Configuration").push("general_utilities");
        HELLFIRE_IGNITER_CONSUME = BUILDER.comment("Amount of energy consumed by the Hellfire Igniter").defineInRange("000_hellfireIgniterConsume", 10, 0, Integer.MAX_VALUE);
        HELLFIRE_IGNITER_BUFFER = BUILDER.comment("Quantity of energy the Hellfire Igniter can be stored").defineInRange("001_hellfireIgniterBuffer", 1000, 0, Integer.MAX_VALUE);
        PORTABLE_DISLOCATOR_ENERGY_CAPACITY = BUILDER.comment("Energy capacity of the Portable Dislocator in RF/FE").defineInRange("100_portableDislocatorEnergyCapacity", 50000, 0, Integer.MAX_VALUE);
        PORTABLE_DISLOCATOR_ENERGY_CONSUME = BUILDER.comment("Energy consumed per teleportation by the Portable Dislocator in RF/FE").defineInRange("100_portableDislocatorEnergyConsume", 1000, 0, Integer.MAX_VALUE);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

