/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.unfamily.iskautils.Config;
import net.unfamily.iskautils.block.ModBlocks;
import net.unfamily.iskautils.block.entity.ModBlockEntities;
import net.unfamily.iskautils.client.ClientEvents;
import net.unfamily.iskautils.data.VectorCharmData;
import net.unfamily.iskautils.item.ModCreativeModeTabs;
import net.unfamily.iskautils.item.ModItems;
import net.unfamily.iskautils.item.custom.CuriosIntegration;
import net.unfamily.iskautils.network.ModMessages;
import net.unfamily.iskautils.util.ModUtils;
import org.slf4j.Logger;

@Mod(value="iska_utils")
public class IskaUtils {
    public static final String MOD_ID = "iska_utils";
    private static final Logger LOGGER = LogUtils.getLogger();

    public IskaUtils(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::clientSetup);
        }
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        ModBlocks.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        if (ModUtils.isCuriosLoaded()) {
            CuriosIntegration.register(modEventBus);
        }
        modEventBus.addListener(this::addCreative);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ClientEvents.shutdown()));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ModMessages.register();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ClientEvents.init();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @EventBusSubscriber(modid="iska_utils", bus=EventBusSubscriber.Bus.GAME)
    public static class GameEventBusEvents {
        @SubscribeEvent
        public static void onServerStarting(ServerStartingEvent event) {
            VectorCharmData.getInstance();
        }

        @SubscribeEvent
        public static void onServerStopping(ServerStoppingEvent event) {
        }
    }

    @EventBusSubscriber(modid="iska_utils", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SLOW_VECT.get()), (RenderType)RenderType.cutout()));
        }
    }

    @EventBusSubscriber(modid="iska_utils", bus=EventBusSubscriber.Bus.MOD)
    public static class ModEventBusEvents {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            ModMessages.register();
        }
    }
}

