/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.block;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.unfamily.iskautils.block.HellfireIgniterBlock;
import net.unfamily.iskautils.block.PlateBaseBlock;
import net.unfamily.iskautils.block.SmoothBlackstoneWallBlock;
import net.unfamily.iskautils.block.player.PlayerExtremeVectBlock;
import net.unfamily.iskautils.block.player.PlayerFastVectBlock;
import net.unfamily.iskautils.block.player.PlayerModerateVectBlock;
import net.unfamily.iskautils.block.player.PlayerSlowVectBlock;
import net.unfamily.iskautils.block.player.PlayerUltraVectBlock;
import net.unfamily.iskautils.block.standard.ExtremeVectBlock;
import net.unfamily.iskautils.block.standard.FastVectBlock;
import net.unfamily.iskautils.block.standard.ModerateVectBlock;
import net.unfamily.iskautils.block.standard.SlowVectBlock;
import net.unfamily.iskautils.block.standard.UltraVectBlock;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"iska_utils");
    private static final BlockBehaviour.Properties VECTOR_PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(0.3f, 1.0f).sound(SoundType.DEEPSLATE).noOcclusion().noCollission().isRedstoneConductor((state, level, pos) -> false).pushReaction(PushReaction.DESTROY).isViewBlocking((state, level, pos) -> false).lightLevel(state -> 0);
    private static final BlockBehaviour.Properties HELLFIRE_PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.3f, 1.0f).sound(SoundType.STONE).requiresCorrectToolForDrops().lightLevel(state -> (Boolean)state.getValue((Property)HellfireIgniterBlock.POWERED) != false ? 7 : 0);
    public static final DeferredBlock<SlowVectBlock> SLOW_VECT = BLOCKS.register("slow_vect", () -> new SlowVectBlock(VECTOR_PROPERTIES));
    public static final DeferredBlock<ModerateVectBlock> MODERATE_VECT = BLOCKS.register("moderate_vect", () -> new ModerateVectBlock(VECTOR_PROPERTIES));
    public static final DeferredBlock<FastVectBlock> FAST_VECT = BLOCKS.register("fast_vect", () -> new FastVectBlock(VECTOR_PROPERTIES));
    public static final DeferredBlock<ExtremeVectBlock> EXTREME_VECT = BLOCKS.register("extreme_vect", () -> new ExtremeVectBlock(VECTOR_PROPERTIES));
    public static final DeferredBlock<UltraVectBlock> ULTRA_VECT = BLOCKS.register("ultra_vect", () -> new UltraVectBlock(VECTOR_PROPERTIES));
    public static final DeferredBlock<PlayerSlowVectBlock> PLAYER_SLOW_VECT = BLOCKS.register("player_slow_vect", () -> new PlayerSlowVectBlock(VECTOR_PROPERTIES));
    public static final DeferredBlock<PlayerModerateVectBlock> PLAYER_MODERATE_VECT = BLOCKS.register("player_moderate_vect", () -> new PlayerModerateVectBlock(VECTOR_PROPERTIES));
    public static final DeferredBlock<PlayerFastVectBlock> PLAYER_FAST_VECT = BLOCKS.register("player_fast_vect", () -> new PlayerFastVectBlock(VECTOR_PROPERTIES));
    public static final DeferredBlock<PlayerExtremeVectBlock> PLAYER_EXTREME_VECT = BLOCKS.register("player_extreme_vect", () -> new PlayerExtremeVectBlock(VECTOR_PROPERTIES));
    public static final DeferredBlock<PlayerUltraVectBlock> PLAYER_ULTRA_VECT = BLOCKS.register("player_ultra_vect", () -> new PlayerUltraVectBlock(VECTOR_PROPERTIES));
    public static final DeferredBlock<HellfireIgniterBlock> HELLFIRE_IGNITER = BLOCKS.register("hellfire_igniter", () -> new HellfireIgniterBlock(HELLFIRE_PROPERTIES));
    private static final BlockBehaviour.Properties SMOOTH_BLACKSTONE_PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).strength(1.5f, 6.0f).sound(SoundType.DEEPSLATE).requiresCorrectToolForDrops();
    public static final DeferredBlock<Block> SMOOTH_BLACKSTONE = BLOCKS.register("smooth_blackstone", () -> new Block(SMOOTH_BLACKSTONE_PROPERTIES));
    public static final DeferredBlock<SlabBlock> SMOOTH_BLACKSTONE_SLAB = BLOCKS.register("smooth_blackstone_slab", () -> new SlabBlock(SMOOTH_BLACKSTONE_PROPERTIES));
    public static final DeferredBlock<StairBlock> SMOOTH_BLACKSTONE_STAIRS = BLOCKS.register("smooth_blackstone_stairs", () -> new StairBlock(((Block)SMOOTH_BLACKSTONE.get()).defaultBlockState(), SMOOTH_BLACKSTONE_PROPERTIES));
    public static final DeferredBlock<Block> SMOOTH_BLACKSTONE_WALL = BLOCKS.register("smooth_blackstone_wall", () -> new SmoothBlackstoneWallBlock(SMOOTH_BLACKSTONE_PROPERTIES));
    public static final DeferredBlock<PlateBaseBlock> PLATE_BASE_BLOCK = BLOCKS.register("plate_base_block", () -> new PlateBaseBlock(VECTOR_PROPERTIES));

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

