/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.unfamily.iskautils.Config;
import org.slf4j.Logger;

public class VectorBlock
extends HorizontalDirectionalBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty VERTICAL = BooleanProperty.create((String)"vertical");
    public static final MapCodec<VectorBlock> CODEC = VectorBlock.simpleCodec(VectorBlock::new);
    protected static final VoxelShape SHAPE_HORIZONTAL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0);
    protected static final VoxelShape SHAPE_VERTICAL_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape SHAPE_VERTICAL_SOUTH = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_VERTICAL_EAST = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_VERTICAL_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private final Supplier<Double> speedSupplier;
    private final boolean affectsPlayers;

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public VectorBlock(BlockBehaviour.Properties properties, Supplier<Double> speedSupplier, boolean affectsPlayers) {
        super(properties.sound(SoundType.DEEPSLATE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(false)));
        this.speedSupplier = speedSupplier;
        this.affectsPlayers = affectsPlayers;
    }

    public VectorBlock(BlockBehaviour.Properties properties, Supplier<Double> speedSupplier) {
        this(properties, speedSupplier, false);
    }

    public VectorBlock(BlockBehaviour.Properties properties) {
        this(properties, () -> 0.05, false);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isShiftKeyDown()) {
            boolean isVertical = (Boolean)state.getValue((Property)VERTICAL);
            if (isVertical) {
                return InteractionResult.PASS;
            }
            if (!level.isClientSide) {
                Direction currentDirection = (Direction)state.getValue((Property)FACING);
                Direction newDirection = currentDirection.getClockWise();
                level.setBlock(pos, (BlockState)state.setValue((Property)FACING, (Comparable)newDirection), 3);
                level.playSound(null, pos, SoundEvents.STONE_PRESSURE_PLATE_CLICK_ON, SoundSource.BLOCKS, 0.3f, 0.6f);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean vertical = (Boolean)state.getValue((Property)VERTICAL);
        if (vertical) {
            return switch (facing) {
                case Direction.NORTH -> SHAPE_VERTICAL_NORTH;
                case Direction.SOUTH -> SHAPE_VERTICAL_SOUTH;
                case Direction.EAST -> SHAPE_VERTICAL_EAST;
                case Direction.WEST -> SHAPE_VERTICAL_WEST;
                default -> SHAPE_HORIZONTAL;
            };
        }
        return SHAPE_HORIZONTAL;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return false;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        Direction facing;
        boolean vertical = (Boolean)state.getValue((Property)VERTICAL);
        if (!vertical && side != Direction.DOWN) {
            return adjacentBlockState.is((Block)this) ? true : super.skipRendering(state, adjacentBlockState, side);
        }
        if (vertical && side != (facing = (Direction)state.getValue((Property)FACING)).getOpposite()) {
            return adjacentBlockState.is((Block)this) ? true : super.skipRendering(state, adjacentBlockState, side);
        }
        return super.skipRendering(state, adjacentBlockState, side);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        boolean vertical = (Boolean)state.getValue((Property)VERTICAL);
        if (!vertical) {
            BlockPos belowPos = pos.below();
            BlockState belowState = level.getBlockState(belowPos);
            VoxelShape belowShape = belowState.getCollisionShape((BlockGetter)level, belowPos);
            return !belowShape.isEmpty() && this.hasFullFaceOnTop(belowShape);
        }
        Direction attachmentDirection = (Direction)state.getValue((Property)FACING);
        BlockPos attachedPos = pos.relative(attachmentDirection);
        BlockState attachedState = level.getBlockState(attachedPos);
        VoxelShape attachedShape = attachedState.getCollisionShape((BlockGetter)level, attachedPos);
        if (attachedShape.isEmpty()) {
            return false;
        }
        return this.hasFullFaceOnSide(attachedShape, attachmentDirection.getOpposite());
    }

    private boolean hasFullFaceOnTop(VoxelShape shape) {
        return shape.max(Direction.Axis.Y) >= 1.0 && shape.min(Direction.Axis.X) <= 0.01 && shape.max(Direction.Axis.X) >= 0.99 && shape.min(Direction.Axis.Z) <= 0.01 && shape.max(Direction.Axis.Z) >= 0.99;
    }

    private boolean hasFullFaceOnSide(VoxelShape shape, Direction direction) {
        if (shape.isEmpty()) {
            return false;
        }
        switch (direction.getAxis()) {
            case X: {
                return shape.min(Direction.Axis.Y) <= 0.01 && shape.max(Direction.Axis.Y) >= 0.99 && shape.min(Direction.Axis.Z) <= 0.01 && shape.max(Direction.Axis.Z) >= 0.99;
            }
            case Z: {
                return shape.min(Direction.Axis.X) <= 0.01 && shape.max(Direction.Axis.X) >= 0.99 && shape.min(Direction.Axis.Y) <= 0.01 && shape.max(Direction.Axis.Y) >= 0.99;
            }
        }
        return false;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean vertical = (Boolean)state.getValue((Property)VERTICAL);
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            if (!level.isClientSide) {
                level.destroyBlock(pos, true);
            }
            return;
        }
        if (!vertical && fromPos.equals((Object)pos.above())) {
            BlockState aboveState = level.getBlockState(fromPos);
            boolean shouldBreak = false;
            VoxelShape collisionShape = aboveState.getCollisionShape((BlockGetter)level, fromPos);
            if (collisionShape.isEmpty() || !this.isFullBlock(collisionShape)) {
                shouldBreak = true;
            }
            if (shouldBreak && !level.isClientSide) {
                level.destroyBlock(pos, true);
            }
        }
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }

    private boolean isFullBlock(VoxelShape shape) {
        return shape.min(Direction.Axis.X) <= 0.01 && shape.max(Direction.Axis.X) >= 0.99 && shape.min(Direction.Axis.Y) <= 0.01 && shape.max(Direction.Axis.Y) >= 0.99 && shape.min(Direction.Axis.Z) <= 0.01 && shape.max(Direction.Axis.Z) >= 0.99;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide) {
            boolean isPlayer = entity instanceof Player;
            if (this.affectsPlayers && !isPlayer || !this.affectsPlayers && isPlayer) {
                return;
            }
            Direction direction = (Direction)state.getValue((Property)FACING);
            boolean vertical = (Boolean)state.getValue((Property)VERTICAL);
            double speed = this.speedSupplier.get();
            if (isPlayer && ((Player)entity).isShiftKeyDown()) {
                return;
            }
            if (!vertical) {
                this.applyHorizontalMovement(entity, direction, speed, isPlayer);
            } else {
                this.applyVerticalMovement(entity, direction, speed, isPlayer);
            }
        }
    }

    private void applyHorizontalMovement(Entity entity, Direction direction, double speed, boolean isPlayer) {
        if (isPlayer) {
            Player player = (Player)entity;
            Vec3 currentMotion = player.getDeltaMovement();
            double accelerationFactor = 0.6;
            double conserveFactor = 0.75;
            switch (direction) {
                case NORTH: {
                    double targetZ = -speed;
                    double newZ = currentMotion.z * (1.0 - accelerationFactor) + targetZ * accelerationFactor;
                    player.setDeltaMovement(currentMotion.x * conserveFactor, currentMotion.y, newZ);
                    break;
                }
                case SOUTH: {
                    double targetZ = speed;
                    double newZ = currentMotion.z * (1.0 - accelerationFactor) + targetZ * accelerationFactor;
                    player.setDeltaMovement(currentMotion.x * conserveFactor, currentMotion.y, newZ);
                    break;
                }
                case WEST: {
                    double targetX = -speed;
                    double newX = currentMotion.x * (1.0 - accelerationFactor) + targetX * accelerationFactor;
                    player.setDeltaMovement(newX, currentMotion.y, currentMotion.z * conserveFactor);
                    break;
                }
                case EAST: {
                    double targetX = speed;
                    double newX = currentMotion.x * (1.0 - accelerationFactor) + targetX * accelerationFactor;
                    player.setDeltaMovement(newX, currentMotion.y, currentMotion.z * conserveFactor);
                    break;
                }
            }
            player.fallDistance = 0.0f;
            player.hurtMarked = true;
        } else {
            double entitySpeed = speed * 1.5;
            Vec3 currentMotion = entity.getDeltaMovement();
            double entityAccelerationFactor = 0.3;
            switch (direction) {
                case NORTH: {
                    double targetZ = -entitySpeed;
                    double newZ = currentMotion.z * (1.0 - entityAccelerationFactor) + targetZ * entityAccelerationFactor;
                    entity.setDeltaMovement(currentMotion.x, currentMotion.y, newZ);
                    break;
                }
                case SOUTH: {
                    double targetZ = entitySpeed;
                    double newZ = currentMotion.z * (1.0 - entityAccelerationFactor) + targetZ * entityAccelerationFactor;
                    entity.setDeltaMovement(currentMotion.x, currentMotion.y, newZ);
                    break;
                }
                case WEST: {
                    double targetX = -entitySpeed;
                    double newX = currentMotion.x * (1.0 - entityAccelerationFactor) + targetX * entityAccelerationFactor;
                    entity.setDeltaMovement(newX, currentMotion.y, currentMotion.z);
                    break;
                }
                case EAST: {
                    double targetX = entitySpeed;
                    double newX = currentMotion.x * (1.0 - entityAccelerationFactor) + targetX * entityAccelerationFactor;
                    entity.setDeltaMovement(newX, currentMotion.y, currentMotion.z);
                    break;
                }
            }
            if (entity.onGround()) {
                entity.setDeltaMovement(entity.getDeltaMovement().x, Math.min(entity.getDeltaMovement().y, 0.0), entity.getDeltaMovement().z);
            }
            entity.fallDistance = 0.0f;
        }
    }

    private void applyVerticalMovement(Entity entity, Direction direction, double speed, boolean isPlayer) {
        double verticalBoostFactor = isPlayer ? Config.verticalBoostFactor : Config.entityVerticalBoostFactor;
        double verticalBoost = speed * verticalBoostFactor;
        double horizontalSpeed = speed * 1.2;
        Vec3 currentMotion = entity.getDeltaMovement();
        double accelerationFactor = isPlayer ? 0.6 : 0.3;
        double conserveFactor = 0.75;
        switch (direction) {
            case NORTH: {
                double targetZ = -horizontalSpeed;
                double newZ = currentMotion.z * (1.0 - accelerationFactor) + targetZ * accelerationFactor;
                double newY = Math.max(currentMotion.y, verticalBoost);
                entity.setDeltaMovement(currentMotion.x * conserveFactor, newY, newZ);
                break;
            }
            case SOUTH: {
                double targetZ = horizontalSpeed;
                double newZ = currentMotion.z * (1.0 - accelerationFactor) + targetZ * accelerationFactor;
                double newY = Math.max(currentMotion.y, verticalBoost);
                entity.setDeltaMovement(currentMotion.x * conserveFactor, newY, newZ);
                break;
            }
            case EAST: {
                double targetX = horizontalSpeed;
                double newX = currentMotion.x * (1.0 - accelerationFactor) + targetX * accelerationFactor;
                double newY = Math.max(currentMotion.y, verticalBoost);
                entity.setDeltaMovement(newX, newY, currentMotion.z * conserveFactor);
                break;
            }
            case WEST: {
                double targetX = -horizontalSpeed;
                double newX = currentMotion.x * (1.0 - accelerationFactor) + targetX * accelerationFactor;
                double newY = Math.max(currentMotion.y, verticalBoost);
                entity.setDeltaMovement(newX, newY, currentMotion.z * conserveFactor);
                break;
            }
        }
        entity.fallDistance = 0.0f;
        if (isPlayer) {
            ((Player)entity).hurtMarked = true;
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clickedFace = context.getClickedFace();
        Direction horizontalDirection = context.getHorizontalDirection();
        if (clickedFace.getAxis() != Direction.Axis.Y && Config.verticalConveyorEnabled) {
            Direction oppositeFace = clickedFace.getOpposite();
            BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)oppositeFace)).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(true));
            return state;
        }
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)horizontalDirection)).setValue((Property)VERTICAL, (Comparable)Boolean.valueOf(false));
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VERTICAL});
    }
}

