/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.unfamily.iskautils.Config;
import net.unfamily.iskautils.block.HellfireIgniterBlock;
import net.unfamily.iskautils.block.entity.ModBlockEntities;

public class HellfireIgniterBlockEntity
extends BlockEntity {
    private final EnergyStorageImpl energyStorage;
    private IEnergyStorage energyHandler;
    private final int effectiveBufferCapacity = this.determineEffectiveCapacity();
    private final int effectiveEnergyConsume = this.determineEffectiveConsumption();

    public HellfireIgniterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.HELLFIRE_IGNITER_BE.get(), pos, state);
        this.energyStorage = new EnergyStorageImpl(this.effectiveBufferCapacity);
        this.energyHandler = this.energyStorage;
    }

    private int determineEffectiveCapacity() {
        if (Config.hellfireIgniterConsume <= 0) {
            return 0;
        }
        if (Config.hellfireIgniterBuffer <= 0) {
            return 0;
        }
        return Config.hellfireIgniterBuffer;
    }

    private int determineEffectiveConsumption() {
        if (this.effectiveBufferCapacity <= 0) {
            return 0;
        }
        if (Config.hellfireIgniterConsume <= 0) {
            return 0;
        }
        if (Config.hellfireIgniterConsume > this.effectiveBufferCapacity) {
            return this.effectiveBufferCapacity;
        }
        return Config.hellfireIgniterConsume;
    }

    public boolean canReceiveEnergy() {
        return this.effectiveBufferCapacity > 0;
    }

    public boolean requiresEnergyToFunction() {
        return this.effectiveEnergyConsume > 0;
    }

    public void ignite() {
        Level level = this.getLevel();
        if (level == null || level.isClientSide) {
            return;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)HellfireIgniterBlock.FACING);
        BlockPos targetPos = this.getBlockPos().relative(facing);
        BlockState targetState = level.getBlockState(targetPos);
        if (!targetState.isAir()) {
            return;
        }
        if (!this.requiresEnergyToFunction()) {
            this.placeFire(level, targetPos);
            return;
        }
        if (this.energyStorage.getEnergyStored() >= this.effectiveEnergyConsume) {
            this.energyStorage.extractEnergy(this.effectiveEnergyConsume, false);
            this.placeFire(level, targetPos);
        }
    }

    private void placeFire(Level level, BlockPos targetPos) {
        level.setBlockAndUpdate(targetPos, Blocks.FIRE.defaultBlockState());
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (this.canReceiveEnergy()) {
            this.energyStorage.setEnergy(tag.getInt("Energy"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.canReceiveEnergy()) {
            tag.putInt("Energy", this.energyStorage.getEnergyStored());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HellfireIgniterBlockEntity blockEntity) {
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public int getEffectiveBufferCapacity() {
        return this.effectiveBufferCapacity;
    }

    public int getEffectiveEnergyConsume() {
        return this.effectiveEnergyConsume;
    }

    public static class EnergyStorageImpl
    extends EnergyStorage {
        public EnergyStorageImpl(int capacity) {
            super(capacity);
        }

        public void setEnergy(int energy) {
            this.energy = Math.max(0, Math.min(energy, this.capacity));
        }
    }
}

