/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.client;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.unfamily.iskautils.data.VectorCharmData;
import net.unfamily.iskautils.data.VectorFactorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyBindings {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyBindings.class);
    public static final String KEY_CATEGORY_ISKA_UTILS = "key.category.iska_utils";
    public static final String KEY_VECTOR_VERTICAL = "key.iska_utils.vector_vertical";
    public static final String KEY_VECTOR_HORIZONTAL = "key.iska_utils.vector_horizontal";
    public static final String KEY_VECTOR_HOVER = "key.iska_utils.vector_hover";
    public static final String KEY_VECTOR_VERTICAL_DECREASE = "key.iska_utils.vector_vertical_decrease";
    public static final String KEY_VECTOR_HORIZONTAL_DECREASE = "key.iska_utils.vector_horizontal_decrease";
    public static final String KEY_PORTABLE_DISLOCATOR = "key.iska_utils.portable_dislocator";
    public static final KeyMapping VECTOR_VERTICAL_KEY = new KeyMapping("key.iska_utils.vector_vertical", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, "key.category.iska_utils");
    public static final KeyMapping VECTOR_HORIZONTAL_KEY = new KeyMapping("key.iska_utils.vector_horizontal", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 78, "key.category.iska_utils");
    public static final KeyMapping VECTOR_HOVER_KEY = new KeyMapping("key.iska_utils.vector_hover", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 72, "key.category.iska_utils");
    public static final KeyMapping VECTOR_VERTICAL_DECREASE_KEY = new KeyMapping("key.iska_utils.vector_vertical_decrease", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 67, "key.category.iska_utils");
    public static final KeyMapping VECTOR_HORIZONTAL_DECREASE_KEY = new KeyMapping("key.iska_utils.vector_horizontal_decrease", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 66, "key.category.iska_utils");
    public static final KeyMapping PORTABLE_DISLOCATOR_KEY = new KeyMapping("key.iska_utils.portable_dislocator", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 89, "key.category.iska_utils");

    public static void checkKeys() {
        if (Minecraft.getInstance().player != null) {
            VectorFactorType newFactor;
            byte nextFactor;
            byte currentFactor;
            LocalPlayer player = Minecraft.getInstance().player;
            if (VECTOR_VERTICAL_KEY.consumeClick()) {
                currentFactor = VectorCharmData.getVerticalFactorFromPlayer((Player)player);
                nextFactor = (byte)((currentFactor + 1) % 6);
                VectorCharmData.setVerticalFactorToPlayer((Player)player, nextFactor);
                newFactor = VectorFactorType.fromByte(nextFactor);
                player.displayClientMessage((Component)Component.translatable((String)"message.iska_utils.vector_vertical_factor", (Object[])new Object[]{Component.translatable((String)("vectorcharm.factor." + newFactor.getName()))}), true);
            }
            if (VECTOR_HORIZONTAL_KEY.consumeClick()) {
                currentFactor = VectorCharmData.getHorizontalFactorFromPlayer((Player)player);
                nextFactor = (byte)((currentFactor + 1) % 6);
                VectorCharmData.setHorizontalFactorToPlayer((Player)player, nextFactor);
                newFactor = VectorFactorType.fromByte(nextFactor);
                player.displayClientMessage((Component)Component.translatable((String)"message.iska_utils.vector_horizontal_factor", (Object[])new Object[]{Component.translatable((String)("vectorcharm.factor." + newFactor.getName()))}), true);
            }
            if (VECTOR_HOVER_KEY.consumeClick()) {
                byte hoverFactor;
                currentFactor = VectorCharmData.getVerticalFactorFromPlayer((Player)player);
                if (currentFactor == (hoverFactor = 6)) {
                    byte restoredFactor = VectorCharmData.disableHoverModeFromPlayer((Player)player);
                    player.displayClientMessage((Component)Component.translatable((String)"message.iska_utils.vector_hover_mode.off"), true);
                } else {
                    VectorCharmData.setVerticalFactorToPlayer((Player)player, hoverFactor);
                    player.displayClientMessage((Component)Component.translatable((String)"message.iska_utils.vector_hover_mode.hover"), true);
                }
            }
            if (VECTOR_VERTICAL_DECREASE_KEY.consumeClick()) {
                currentFactor = VectorCharmData.getVerticalFactorFromPlayer((Player)player);
                nextFactor = (byte)((currentFactor - 1 + 6) % 6);
                VectorCharmData.setVerticalFactorToPlayer((Player)player, nextFactor);
                VectorFactorType newFactor2 = VectorFactorType.fromByte(nextFactor);
                player.displayClientMessage((Component)Component.translatable((String)"message.iska_utils.vector_vertical_factor", (Object[])new Object[]{Component.translatable((String)("vectorcharm.factor." + newFactor2.getName()))}), true);
            }
            if (VECTOR_HORIZONTAL_DECREASE_KEY.consumeClick()) {
                currentFactor = VectorCharmData.getHorizontalFactorFromPlayer((Player)player);
                nextFactor = (byte)((currentFactor - 1 + 6) % 6);
                VectorCharmData.setHorizontalFactorToPlayer((Player)player, nextFactor);
                VectorFactorType newFactor3 = VectorFactorType.fromByte(nextFactor);
                player.displayClientMessage((Component)Component.translatable((String)"message.iska_utils.vector_horizontal_factor", (Object[])new Object[]{Component.translatable((String)("vectorcharm.factor." + newFactor3.getName()))}), true);
            }
        }
    }

    @EventBusSubscriber(modid="iska_utils", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class KeybindHandler {
        @SubscribeEvent
        public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
            event.register(VECTOR_VERTICAL_KEY);
            event.register(VECTOR_HORIZONTAL_KEY);
            event.register(VECTOR_HOVER_KEY);
            event.register(VECTOR_VERTICAL_DECREASE_KEY);
            event.register(VECTOR_HORIZONTAL_DECREASE_KEY);
            event.register(PORTABLE_DISLOCATOR_KEY);
        }
    }
}

