/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.client;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.unfamily.iskautils.Config;
import net.unfamily.iskautils.data.VectorCharmData;
import net.unfamily.iskautils.data.VectorFactorType;
import net.unfamily.iskautils.item.custom.VectorCharmItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorCharmMovement {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectorCharmMovement.class);
    private static boolean wasInHoverMode = false;
    private static final double HOVER_VALUE = 0.0;
    private static final Set<UUID> processedPlayersThisTick = new HashSet<UUID>();
    private static long lastTickTime = -1L;

    public static void applyMovement(Player player) {
        VectorCharmMovement.applyMovement(player, null);
    }

    public static void applyMovement(Player player, ItemStack sourceCharm) {
        boolean hasHorizontalFactor;
        UUID playerId;
        if (player == null) {
            return;
        }
        if (!Config.verticalCharmEnabled && !Config.horizontalCharmEnabled) {
            return;
        }
        long currentTick = player.level().getGameTime();
        if (currentTick != lastTickTime) {
            processedPlayersThisTick.clear();
            lastTickTime = currentTick;
        }
        if (processedPlayersThisTick.contains(playerId = player.getUUID())) {
            return;
        }
        processedPlayersThisTick.add(playerId);
        byte verticalFactorValue = VectorCharmData.getVerticalFactorFromPlayer(player);
        byte horizontalFactorValue = VectorCharmData.getHorizontalFactorFromPlayer(player);
        boolean isHoverMode = verticalFactorValue == 6;
        boolean wasHoverModePreviously = wasInHoverMode;
        wasInHoverMode = isHoverMode;
        boolean hasVerticalFactor = Config.verticalCharmEnabled && verticalFactorValue > 0 && verticalFactorValue != 6;
        boolean bl = hasHorizontalFactor = Config.horizontalCharmEnabled && horizontalFactorValue > 0;
        if (!(hasVerticalFactor || hasHorizontalFactor || isHoverMode)) {
            return;
        }
        if (hasVerticalFactor || isHoverMode) {
            int energyLevel = isHoverMode ? 6 : (int)verticalFactorValue;
            VectorCharmMovement.applyVerticalMovement(player, verticalFactorValue, isHoverMode, energyLevel, sourceCharm);
            player.fallDistance = 0.0f;
        }
        if (hasHorizontalFactor) {
            VectorCharmMovement.applyHorizontalMovement(player, horizontalFactorValue, horizontalFactorValue, sourceCharm);
        }
    }

    private static void applyVerticalMovement(Player player, byte factorValue, boolean isHoverMode, int energyLevel, ItemStack sourceCharm) {
        Item item;
        ItemStack activeCharm = sourceCharm;
        if (activeCharm == null) {
            activeCharm = VectorCharmItem.getActiveVectorCharm(player, energyLevel);
        }
        if (activeCharm == null || !((item = activeCharm.getItem()) instanceof VectorCharmItem)) {
            return;
        }
        VectorCharmItem charm = (VectorCharmItem)item;
        if (!charm.hasEnoughEnergy(activeCharm, energyLevel)) {
            if (player.level().getGameTime() % 60L == 0L) {
                player.displayClientMessage((Component)Component.literal((String)"\u00a7cVector Charm out of energy!"), true);
            }
            return;
        }
        charm.consumeEnergyForMovement(activeCharm, energyLevel);
        Vec3 currentMotion = player.getDeltaMovement();
        if (isHoverMode) {
            player.setDeltaMovement(currentMotion.x, 0.0, currentMotion.z);
            player.fallDistance = 0.0f;
        } else if (factorValue > 0) {
            double speed = VectorCharmMovement.getVectorSpeed(factorValue);
            double verticalBoost = speed + Config.verticalBoostFactor;
            double accelerationFactor = 0.6;
            double targetY = verticalBoost;
            double newY = currentMotion.y * (1.0 - accelerationFactor) + targetY * accelerationFactor;
            player.setDeltaMovement(currentMotion.x, newY, currentMotion.z);
            player.fallDistance = 0.0f;
        }
        player.hurtMarked = true;
    }

    private static void applyHorizontalMovement(Player player, byte factorValue, int energyLevel, ItemStack sourceCharm) {
        Item item;
        ItemStack activeCharm = sourceCharm;
        if (activeCharm == null) {
            activeCharm = VectorCharmItem.getActiveVectorCharm(player, energyLevel);
        }
        if (activeCharm == null || !((item = activeCharm.getItem()) instanceof VectorCharmItem)) {
            return;
        }
        VectorCharmItem charm = (VectorCharmItem)item;
        if (!charm.hasEnoughEnergy(activeCharm, energyLevel)) {
            if (player.level().getGameTime() % 60L == 0L) {
                player.displayClientMessage((Component)Component.literal((String)"\u00a7cVector Charm out of energy!"), true);
            }
            return;
        }
        charm.consumeEnergyForMovement(activeCharm, energyLevel);
        Vec3 currentMotion = player.getDeltaMovement();
        Vec3 lookVec = player.getLookAngle();
        double speed = VectorCharmMovement.getVectorSpeed(factorValue);
        double targetX = lookVec.x * speed;
        double targetZ = lookVec.z * speed;
        double accelerationFactor = 0.6;
        double conserveFactor = 0.75;
        double newX = currentMotion.x * (1.0 - accelerationFactor) + targetX * accelerationFactor;
        double newZ = currentMotion.z * (1.0 - accelerationFactor) + targetZ * accelerationFactor;
        player.setDeltaMovement(newX, currentMotion.y, newZ);
        player.hurtMarked = true;
    }

    private static double getVectorSpeed(byte factorValue) {
        VectorFactorType factorType = VectorFactorType.fromByte(factorValue);
        return switch (factorType) {
            case VectorFactorType.SLOW -> Config.slowVectorSpeed;
            case VectorFactorType.MODERATE -> Config.moderateVectorSpeed;
            case VectorFactorType.FAST -> Config.fastVectorSpeed;
            case VectorFactorType.EXTREME -> Config.extremeVectorSpeed;
            case VectorFactorType.ULTRA -> Config.ultraVectorSpeed;
            default -> 0.0;
        };
    }
}

