/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorCharmData {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectorCharmData.class);
    private static final String DATA_NAME = "iska_utils_vector_charm_data";
    private static VectorCharmData instance;
    private final Map<UUID, Byte> verticalFactors = new HashMap<UUID, Byte>();
    private final Map<UUID, Byte> horizontalFactors = new HashMap<UUID, Byte>();
    private final Map<UUID, Byte> previousVerticalFactors = new HashMap<UUID, Byte>();
    public static final byte HOVER_MODE_VALUE = 6;
    public static final byte PARACHUTE_MODE_VALUE = 7;
    public static final byte PARACHUTE_ACTIVE_VALUE = 8;
    public static final int PARACHUTE_DURATION = 100;
    private final Map<UUID, Integer> parachuteTicksLeft = new HashMap<UUID, Integer>();
    private boolean isDirty = false;

    private VectorCharmData() {
    }

    public static VectorCharmData getInstance() {
        if (instance == null) {
            instance = new VectorCharmData();
        }
        return instance;
    }

    public void setVerticalFactor(Player player, byte factor) {
        UUID playerId = player.getUUID();
        byte currentFactor = this.verticalFactors.getOrDefault(playerId, (byte)0);
        if (factor == 6 && currentFactor != 6) {
            this.previousVerticalFactors.put(playerId, currentFactor);
        }
        this.verticalFactors.put(playerId, factor);
        this.isDirty = true;
    }

    public byte getVerticalFactor(Player player) {
        UUID playerId = player.getUUID();
        return this.verticalFactors.getOrDefault(playerId, (byte)0);
    }

    public byte disableHoverMode(Player player) {
        UUID playerId = player.getUUID();
        byte previousFactor = this.previousVerticalFactors.getOrDefault(playerId, (byte)0);
        this.verticalFactors.put(playerId, previousFactor);
        this.isDirty = true;
        return previousFactor;
    }

    public void setHorizontalFactor(Player player, byte factor) {
        UUID playerId = player.getUUID();
        this.horizontalFactors.put(playerId, factor);
        this.isDirty = true;
    }

    public byte getHorizontalFactor(Player player) {
        UUID playerId = player.getUUID();
        return this.horizontalFactors.getOrDefault(playerId, (byte)0);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void resetDirty() {
        this.isDirty = false;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        CompoundTag verticalTag = new CompoundTag();
        CompoundTag horizontalTag = new CompoundTag();
        CompoundTag previousVerticalTag = new CompoundTag();
        CompoundTag parachuteTicksTag = new CompoundTag();
        for (Map.Entry<UUID, Byte> entry : this.verticalFactors.entrySet()) {
            verticalTag.putByte(entry.getKey().toString(), entry.getValue().byteValue());
        }
        for (Map.Entry<UUID, Byte> entry : this.horizontalFactors.entrySet()) {
            horizontalTag.putByte(entry.getKey().toString(), entry.getValue().byteValue());
        }
        for (Map.Entry<UUID, Byte> entry : this.previousVerticalFactors.entrySet()) {
            previousVerticalTag.putByte(entry.getKey().toString(), entry.getValue().byteValue());
        }
        for (Map.Entry<UUID, Number> entry : this.parachuteTicksLeft.entrySet()) {
            parachuteTicksTag.putInt(entry.getKey().toString(), ((Integer)entry.getValue()).intValue());
        }
        tag.put("vertical_factors", (Tag)verticalTag);
        tag.put("horizontal_factors", (Tag)horizontalTag);
        tag.put("previous_vertical_factors", (Tag)previousVerticalTag);
        tag.put("parachute_ticks", (Tag)parachuteTicksTag);
        return tag;
    }

    public void load(CompoundTag tag) {
        UUID playerId;
        if (tag.contains("vertical_factors")) {
            CompoundTag verticalTag = tag.getCompound("vertical_factors");
            for (String key : verticalTag.getAllKeys()) {
                try {
                    playerId = UUID.fromString(key);
                    this.verticalFactors.put(playerId, verticalTag.getByte(key));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in vertical_factors: {}", (Object)key);
                }
            }
        }
        if (tag.contains("horizontal_factors")) {
            CompoundTag horizontalTag = tag.getCompound("horizontal_factors");
            for (String key : horizontalTag.getAllKeys()) {
                try {
                    playerId = UUID.fromString(key);
                    this.horizontalFactors.put(playerId, horizontalTag.getByte(key));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in horizontal_factors: {}", (Object)key);
                }
            }
        }
        if (tag.contains("previous_vertical_factors")) {
            CompoundTag previousVerticalTag = tag.getCompound("previous_vertical_factors");
            for (String key : previousVerticalTag.getAllKeys()) {
                try {
                    playerId = UUID.fromString(key);
                    this.previousVerticalFactors.put(playerId, previousVerticalTag.getByte(key));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in previous_vertical_factors: {}", (Object)key);
                }
            }
        }
        if (tag.contains("parachute_ticks")) {
            CompoundTag parachuteTicksTag = tag.getCompound("parachute_ticks");
            for (String key : parachuteTicksTag.getAllKeys()) {
                try {
                    playerId = UUID.fromString(key);
                    this.parachuteTicksLeft.put(playerId, parachuteTicksTag.getInt(key));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Invalid UUID in parachute_ticks: {}", (Object)key);
                }
            }
        }
    }

    public static VectorCharmData get(ServerLevel level) {
        return VectorCharmData.getInstance();
    }

    public void enableParachuteMode(Player player) {
        UUID playerId = player.getUUID();
        byte currentFactor = this.verticalFactors.getOrDefault(playerId, (byte)0);
        if (currentFactor != 6 && currentFactor != 7) {
            this.previousVerticalFactors.put(playerId, currentFactor);
        }
        this.verticalFactors.put(playerId, (byte)7);
        this.parachuteTicksLeft.put(playerId, 100);
        this.isDirty = true;
    }

    public byte disableParachuteMode(Player player) {
        UUID playerId = player.getUUID();
        byte previousFactor = this.previousVerticalFactors.getOrDefault(playerId, (byte)0);
        this.verticalFactors.put(playerId, previousFactor);
        this.parachuteTicksLeft.remove(playerId);
        this.previousVerticalFactors.remove(playerId);
        this.isDirty = true;
        return previousFactor;
    }

    public int getParachuteTicksLeft(Player player) {
        UUID playerId = player.getUUID();
        return this.parachuteTicksLeft.getOrDefault(playerId, 0);
    }

    public boolean decrementParachuteTicks(Player player) {
        UUID playerId = player.getUUID();
        if (!this.parachuteTicksLeft.containsKey(playerId)) {
            return false;
        }
        int ticksLeft = this.parachuteTicksLeft.get(playerId) - 1;
        if (ticksLeft <= 0) {
            this.disableParachuteMode(player);
            return false;
        }
        this.parachuteTicksLeft.put(playerId, ticksLeft);
        return true;
    }

    public static byte getVerticalFactorFromPlayer(Player player) {
        if (player.getPersistentData().contains("VectorCharmVertical")) {
            return player.getPersistentData().getByte("VectorCharmVertical");
        }
        return 0;
    }

    public static void setVerticalFactorToPlayer(Player player, byte factor) {
        byte currentFactor;
        if (factor == 6 && (currentFactor = VectorCharmData.getVerticalFactorFromPlayer(player)) != 6) {
            player.getPersistentData().putByte("VectorCharmPreviousVertical", currentFactor);
        }
        player.getPersistentData().putByte("VectorCharmVertical", factor);
    }

    public static byte getHorizontalFactorFromPlayer(Player player) {
        if (player.getPersistentData().contains("VectorCharmHorizontal")) {
            return player.getPersistentData().getByte("VectorCharmHorizontal");
        }
        return 0;
    }

    public static void setHorizontalFactorToPlayer(Player player, byte factor) {
        player.getPersistentData().putByte("VectorCharmHorizontal", factor);
    }

    public static byte disableHoverModeFromPlayer(Player player) {
        byte previousFactor = 0;
        if (player.getPersistentData().contains("VectorCharmPreviousVertical")) {
            previousFactor = player.getPersistentData().getByte("VectorCharmPreviousVertical");
            player.getPersistentData().remove("VectorCharmPreviousVertical");
        }
        VectorCharmData.setVerticalFactorToPlayer(player, previousFactor);
        return previousFactor;
    }
}

