/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.data;

public enum VectorFactorType {
    NONE(0, "none", 0.0f),
    SLOW(1, "slow", 0.2f),
    MODERATE(2, "moderate", 0.4f),
    FAST(3, "fast", 0.6f),
    EXTREME(4, "extreme", 0.8f),
    ULTRA(5, "ultra", 1.0f),
    UNKNOWN(-1, "unknown", 0.0f);

    private final byte id;
    private final String name;
    private final float factor;

    private VectorFactorType(int id, String name, float factor) {
        this.id = (byte)id;
        this.name = name;
        this.factor = factor;
    }

    public byte getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public float getFactor() {
        return this.factor;
    }

    public static VectorFactorType fromByte(byte id) {
        for (VectorFactorType type : VectorFactorType.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        return UNKNOWN;
    }
}

