/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.item;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.unfamily.iskautils.item.ModItems;
import net.unfamily.iskautils.item.custom.PortableDislocatorItem;
import net.unfamily.iskautils.item.custom.VectorCharmItem;

@EventBusSubscriber(modid="iska_utils", bus=EventBusSubscriber.Bus.MOD)
public class ModItemCapabilities {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> {
            VectorCharmItem vectorCharm;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof VectorCharmItem && (vectorCharm = (VectorCharmItem)patt0$temp).canStoreEnergy()) {
                return new VectorCharmEnergyStorage(vectorCharm, (ItemStack)stack);
            }
            return null;
        }, new ItemLike[]{(ItemLike)ModItems.VECTOR_CHARM.get()});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> {
            PortableDislocatorItem dislocator;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof PortableDislocatorItem && (dislocator = (PortableDislocatorItem)patt0$temp).canStoreEnergy()) {
                return new PortableDislocatorEnergyStorage(dislocator, (ItemStack)stack);
            }
            return null;
        }, new ItemLike[]{(ItemLike)ModItems.PORTABLE_DISLOCATOR.get()});
    }

    public static class PortableDislocatorEnergyStorage
    implements IEnergyStorage {
        private final PortableDislocatorItem dislocator;
        private final ItemStack stack;

        public PortableDislocatorEnergyStorage(PortableDislocatorItem dislocator, ItemStack stack) {
            this.dislocator = dislocator;
            this.stack = stack;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int currentEnergy = this.dislocator.getEnergyStored(this.stack);
            int maxEnergy = this.dislocator.getMaxEnergyStored(this.stack);
            int energyToReceive = Math.min(maxReceive, maxEnergy - currentEnergy);
            if (!simulate && energyToReceive > 0) {
                this.dislocator.setEnergyStored(this.stack, currentEnergy + energyToReceive);
            }
            return energyToReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int currentEnergy = this.dislocator.getEnergyStored(this.stack);
            int energyToExtract = Math.min(maxExtract, currentEnergy);
            if (!simulate && energyToExtract > 0) {
                this.dislocator.setEnergyStored(this.stack, currentEnergy - energyToExtract);
            }
            return energyToExtract;
        }

        public int getEnergyStored() {
            return this.dislocator.getEnergyStored(this.stack);
        }

        public int getMaxEnergyStored() {
            return this.dislocator.getMaxEnergyStored(this.stack);
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return this.dislocator.canStoreEnergy();
        }
    }

    public static class VectorCharmEnergyStorage
    implements IEnergyStorage {
        private final VectorCharmItem vectorCharm;
        private final ItemStack stack;

        public VectorCharmEnergyStorage(VectorCharmItem vectorCharm, ItemStack stack) {
            this.vectorCharm = vectorCharm;
            this.stack = stack;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int currentEnergy = this.vectorCharm.getEnergyStored(this.stack);
            int maxEnergy = this.vectorCharm.getMaxEnergyStored(this.stack);
            int energyToReceive = Math.min(maxReceive, maxEnergy - currentEnergy);
            if (!simulate && energyToReceive > 0) {
                this.vectorCharm.setEnergyStored(this.stack, currentEnergy + energyToReceive);
            }
            return energyToReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int currentEnergy = this.vectorCharm.getEnergyStored(this.stack);
            int energyToExtract = Math.min(maxExtract, currentEnergy);
            if (!simulate && energyToExtract > 0) {
                this.vectorCharm.setEnergyStored(this.stack, currentEnergy - energyToExtract);
            }
            return energyToExtract;
        }

        public int getEnergyStored() {
            return this.vectorCharm.getEnergyStored(this.stack);
        }

        public int getMaxEnergyStored() {
            return this.vectorCharm.getMaxEnergyStored(this.stack);
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return this.vectorCharm.canStoreEnergy();
        }
    }
}

