/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.item.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.unfamily.iskautils.Config;
import net.unfamily.iskautils.client.KeyBindings;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortableDislocatorItem
extends Item {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortableDislocatorItem.class);
    private static final String ENERGY_TAG = "Energy";
    private static final TicketType<Unit> DISLOCATOR_TICKET = TicketType.create((String)"portable_dislocator", (a, b) -> 0, (int)100);
    private static final Map<UUID, TeleportationData> activeTeleportations = new HashMap<UUID, TeleportationData>();
    private static final Map<UUID, TeleportRequest> pendingRequests = new HashMap<UUID, TeleportRequest>();
    private static final int MAX_WAIT_TICKS = 200;
    private static final int MAX_ATTEMPTS = 5;

    public PortableDislocatorItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        String keybindName = KeyBindings.PORTABLE_DISLOCATOR_KEY.getTranslatedKeyMessage().getString();
        tooltipComponents.add((Component)Component.translatable((String)"item.iska_utils.portable_dislocator.tooltip.main", (Object[])new Object[]{keybindName}));
        tooltipComponents.add((Component)Component.translatable((String)"item.iska_utils.portable_dislocator.tooltip.compasses"));
        if (this.canStoreEnergy()) {
            int energy = this.getEnergyStored(stack);
            int maxEnergy = this.getMaxEnergyStored(stack);
            tooltipComponents.add((Component)Component.literal((String)String.format("Energy: %,d / %,d RF", energy, maxEnergy)));
            if (this.requiresEnergyToFunction()) {
                tooltipComponents.add((Component)Component.literal((String)("\u00a77Energy per teleportation: " + this.getEffectiveEnergyConsumption() + " RF")));
            }
        } else {
            tooltipComponents.add((Component)Component.literal((String)"\u00a77No energy required"));
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (level.isClientSide) {
                this.tickInInventory(stack, level, player, slotId, isSelected);
            }
            if (!level.isClientSide) {
                PortableDislocatorItem.handlePendingTeleportation(player, level);
                PortableDislocatorItem.checkForTeleportRequest(player, level);
            }
        }
    }

    private void tickInInventory(ItemStack stack, Level level, Player player, int slotId, boolean isSelected) {
        if (KeyBindings.PORTABLE_DISLOCATOR_KEY.consumeClick()) {
            PortableDislocatorItem.handleDislocatorActivation(player, "inventory");
        }
    }

    public static void tickInCurios(ItemStack stack, Level level, Player player) {
        if (level.isClientSide && KeyBindings.PORTABLE_DISLOCATOR_KEY.consumeClick()) {
            PortableDislocatorItem.handleDislocatorActivation(player, "curios");
        }
        if (!level.isClientSide) {
            PortableDislocatorItem.handlePendingTeleportation(player, level);
            PortableDislocatorItem.checkForTeleportRequest(player, level);
        }
    }

    private static void checkForTeleportRequest(Player player, Level level) {
        UUID playerId = player.getUUID();
        TeleportRequest request = pendingRequests.get(playerId);
        if (request != null && level instanceof ServerLevel) {
            PortableDislocatorItem dislocator;
            LOGGER.info("Processing teleport request from client for player {} to {}, {}", new Object[]{player.getName().getString(), request.targetX, request.targetZ});
            pendingRequests.remove(playerId);
            ItemStack dislocatorStack = PortableDislocatorItem.findPortableDislocator(player);
            if (dislocatorStack != null && (dislocator = (PortableDislocatorItem)dislocatorStack.getItem()).consumeEnergyForTeleportation(dislocatorStack)) {
                PortableDislocatorItem.startServerTeleportation(player, request.targetX, request.targetZ);
            }
        }
    }

    private static void startServerTeleportation(Player player, int targetX, int targetZ) {
        UUID playerId = player.getUUID();
        Random random = new Random();
        int offsetX = random.nextBoolean() ? random.nextInt(201) + 100 : -(random.nextInt(201) + 100);
        int offsetZ = random.nextBoolean() ? random.nextInt(201) + 100 : -(random.nextInt(201) + 100);
        int distance = (int)Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
        int randomizedX = targetX + offsetX;
        int randomizedZ = targetZ + offsetZ;
        TeleportationData data = new TeleportationData(player, randomizedX, randomizedZ);
        data.originalX = targetX;
        data.originalZ = targetZ;
        activeTeleportations.put(playerId, data);
    }

    private static void handlePendingTeleportation(Player player, Level level) {
        block19: {
            UUID playerId = player.getUUID();
            TeleportationData data = activeTeleportations.get(playerId);
            if (data == null) {
                return;
            }
            ++data.ticksWaiting;
            if (data.ticksWaiting > 200) {
                if (data.attemptCount < 5) {
                    PortableDislocatorItem.attemptNewTeleportation(player, data.originalX, data.originalZ, data.attemptCount + 1);
                } else {
                    PortableDislocatorItem.resetTeleportationState(playerId);
                }
                return;
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int chunkX = data.targetX >> 4;
                int chunkZ = data.targetZ >> 4;
                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                serverLevel.getChunkSource().addRegionTicket(DISLOCATOR_TICKET, chunkPos, 2, (Object)Unit.INSTANCE);
                try {
                    ChunkAccess chunk = serverLevel.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.FULL, true);
                    if (chunk == null) {
                        serverLevel.getChunkSource().getChunkNow(chunkX, chunkZ);
                        chunk = serverLevel.getChunk(chunkX, chunkZ);
                    }
                    if (chunk == null) {
                        ChunkMap chunkManager = serverLevel.getChunkSource().chunkMap;
                        chunk = serverLevel.getChunk(chunkX, chunkZ, ChunkStatus.FULL, true);
                    }
                    if (chunk != null) {
                        boolean canAccessBlocks = true;
                        try {
                            BlockPos testPos = new BlockPos(data.targetX, 64, data.targetZ);
                            BlockState blockState = level.getBlockState(testPos);
                        }
                        catch (Exception e) {
                            canAccessBlocks = false;
                        }
                        if (canAccessBlocks) {
                            int safeY = PortableDislocatorItem.findSafeY(level, data.targetX, data.targetZ);
                            if (safeY != -1) {
                                data.loadedChunk = chunkPos;
                                data.chunkLevel = serverLevel;
                                player.teleportTo((double)data.targetX + 0.5, (double)safeY, (double)data.targetZ + 0.5);
                                player.setDeltaMovement(0.0, 0.0, 0.0);
                                PortableDislocatorItem.scheduleChunkUnload(serverLevel, chunkPos, 100);
                                PortableDislocatorItem.resetTeleportationState(playerId);
                                return;
                            }
                            serverLevel.getChunkSource().removeRegionTicket(DISLOCATOR_TICKET, chunkPos, 2, (Object)Unit.INSTANCE);
                            if (data.attemptCount < 5) {
                                PortableDislocatorItem.attemptNewTeleportation(player, data.originalX, data.originalZ, data.attemptCount + 1);
                            } else {
                                PortableDislocatorItem.resetTeleportationState(playerId);
                            }
                            return;
                        }
                        break block19;
                    }
                    if (data.ticksWaiting > 60) {
                        try {
                            BlockPos forcePos = new BlockPos(data.targetX, 64, data.targetZ);
                            level.getBlockState(forcePos);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void scheduleChunkUnload(ServerLevel serverLevel, ChunkPos chunkPos, int delayTicks) {
        LOGGER.info("Scheduling chunk unload for {}, {} after {} ticks", new Object[]{chunkPos.x, chunkPos.z, delayTicks});
        serverLevel.getServer().execute(() -> new Thread(() -> {
            try {
                Thread.sleep(delayTicks * 50);
                serverLevel.getServer().execute(() -> {
                    serverLevel.getChunkSource().removeRegionTicket(DISLOCATOR_TICKET, chunkPos, 2, (Object)Unit.INSTANCE);
                    LOGGER.info("Removed chunk loading ticket for chunk at {}, {}", (Object)chunkPos.x, (Object)chunkPos.z);
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.error("Chunk unload scheduling interrupted", (Throwable)e);
            }
        }).start());
    }

    private static void resetTeleportationState(UUID playerId) {
        LOGGER.info("Resetting teleportation state for player {}", (Object)playerId);
        activeTeleportations.remove(playerId);
        pendingRequests.remove(playerId);
    }

    private static void attemptNewTeleportation(Player player, int originalX, int originalZ, int attemptNumber) {
        int minRange;
        UUID playerId = player.getUUID();
        Random random = new Random();
        int maxRange = switch (attemptNumber) {
            case 2 -> {
                minRange = 50;
                yield 200;
            }
            case 3 -> {
                minRange = 25;
                yield 150;
            }
            case 4 -> {
                minRange = 10;
                yield 100;
            }
            case 5 -> {
                minRange = 5;
                yield 50;
            }
            default -> {
                minRange = 100;
                yield 300;
            }
        };
        int offsetX = random.nextBoolean() ? random.nextInt(maxRange - minRange + 1) + minRange : -(random.nextInt(maxRange - minRange + 1) + minRange);
        int offsetZ = random.nextBoolean() ? random.nextInt(maxRange - minRange + 1) + minRange : -(random.nextInt(maxRange - minRange + 1) + minRange);
        int newX = originalX + offsetX;
        int newZ = originalZ + offsetZ;
        TeleportationData newData = new TeleportationData(player, newX, newZ);
        newData.originalX = originalX;
        newData.originalZ = originalZ;
        newData.attemptCount = attemptNumber;
        activeTeleportations.put(playerId, newData);
    }

    private static int findSafeY(Level level, int x, int z) {
        int finalY;
        int absoluteMinY = level.getMinBuildHeight();
        int absoluteMaxY = level.getMaxBuildHeight();
        int minY = Math.max(absoluteMinY + 5, PortableDislocatorItem.getSafeDimensionMinY(level));
        int maxY = Math.min(absoluteMaxY - 5, PortableDislocatorItem.getSafeDimensionMaxY(level));
        minY = Math.max(minY, PortableDislocatorItem.getBedrockFloorY(level) + 1);
        maxY = Math.min(maxY, PortableDislocatorItem.getBedrockCeilingY(level) - 3);
        int startY = Math.max(50, minY);
        int firstValidPosition = -1;
        int skyAccessPosition = -1;
        for (int y = startY; y <= maxY - 2; ++y) {
            if (!PortableDislocatorItem.isSpaceFree(level, x, y, z) || !PortableDislocatorItem.hasValidGround(level, x, y, z)) continue;
            if (firstValidPosition == -1) {
                firstValidPosition = y;
            }
            if (!level.canSeeSky(new BlockPos(x, y + 1, z))) continue;
            skyAccessPosition = y;
            break;
        }
        int chosenUpwardPosition = -1;
        if (skyAccessPosition != -1) {
            chosenUpwardPosition = skyAccessPosition;
        } else if (firstValidPosition != -1) {
            chosenUpwardPosition = firstValidPosition;
        }
        int downwardPosition = -1;
        if (chosenUpwardPosition == -1) {
            for (int y = startY - 1; y >= minY; --y) {
                if (!PortableDislocatorItem.isSpaceFree(level, x, y, z) || !PortableDislocatorItem.hasValidGround(level, x, y, z)) continue;
                downwardPosition = y;
                break;
            }
        }
        int n = finalY = chosenUpwardPosition != -1 ? chosenUpwardPosition : downwardPosition;
        if (finalY != -1) {
            if (!PortableDislocatorItem.isWithinDimensionLimits(level, finalY)) {
                return -1;
            }
            PortableDislocatorItem.prepareGround(level, x, finalY, z);
            return finalY;
        }
        return -1;
    }

    private static int getSafeDimensionMinY(Level level) {
        String dimensionKey;
        switch (dimensionKey = level.dimension().location().toString()) {
            case "minecraft:the_nether": {
                return 5;
            }
            case "minecraft:the_end": {
                return 50;
            }
        }
        return level.getMinBuildHeight() + 5;
    }

    private static int getSafeDimensionMaxY(Level level) {
        String dimensionKey;
        switch (dimensionKey = level.dimension().location().toString()) {
            case "minecraft:the_nether": {
                return 122;
            }
            case "minecraft:the_end": {
                return level.getMaxBuildHeight() - 5;
            }
        }
        return level.getMaxBuildHeight() - 5;
    }

    private static int getBedrockFloorY(Level level) {
        String dimensionKey;
        switch (dimensionKey = level.dimension().location().toString()) {
            case "minecraft:the_nether": {
                return 0;
            }
            case "minecraft:overworld": {
                return level.getMinBuildHeight();
            }
            case "minecraft:the_end": {
                return 0;
            }
        }
        return level.getMinBuildHeight();
    }

    private static int getBedrockCeilingY(Level level) {
        String dimensionKey;
        switch (dimensionKey = level.dimension().location().toString()) {
            case "minecraft:the_nether": {
                return 127;
            }
            case "minecraft:overworld": {
                return level.getMaxBuildHeight();
            }
            case "minecraft:the_end": {
                return level.getMaxBuildHeight();
            }
        }
        return level.getMaxBuildHeight();
    }

    private static boolean isWithinDimensionLimits(Level level, int y) {
        int safeMinY = Math.max(level.getMinBuildHeight() + 5, PortableDislocatorItem.getSafeDimensionMinY(level));
        int safeMaxY = Math.min(level.getMaxBuildHeight() - 5, PortableDislocatorItem.getSafeDimensionMaxY(level));
        int bedrockFloor = PortableDislocatorItem.getBedrockFloorY(level) + 1;
        int bedrockCeiling = PortableDislocatorItem.getBedrockCeilingY(level) - 3;
        safeMinY = Math.max(safeMinY, bedrockFloor);
        safeMaxY = Math.min(safeMaxY, bedrockCeiling);
        boolean withinLimits = y >= safeMinY && y <= safeMaxY;
        return withinLimits;
    }

    private static boolean isSpaceFree(Level level, int x, int y, int z) {
        BlockPos feetPos = new BlockPos(x, y, z);
        BlockPos headPos = new BlockPos(x, y + 1, z);
        BlockState feetState = level.getBlockState(feetPos);
        BlockState headState = level.getBlockState(headPos);
        if (feetState.is(Blocks.BEDROCK) || headState.is(Blocks.BEDROCK)) {
            return false;
        }
        boolean feetIsLiquid = !feetState.getFluidState().isEmpty();
        boolean headIsLiquid = !headState.getFluidState().isEmpty();
        boolean feetFree = feetState.isAir() || !feetIsLiquid && feetState.is(BlockTags.REPLACEABLE) || !feetIsLiquid && feetState.is(BlockTags.FLOWERS);
        boolean headFree = headState.isAir() || !headIsLiquid && headState.is(BlockTags.REPLACEABLE) || !headIsLiquid && headState.is(BlockTags.FLOWERS);
        return feetFree && headFree;
    }

    private static boolean hasValidGround(Level level, int x, int y, int z) {
        boolean isLiquid;
        String dimensionKey;
        BlockPos groundPos = new BlockPos(x, y - 1, z);
        BlockState groundState = level.getBlockState(groundPos);
        if (groundState.is(Blocks.BEDROCK) && "minecraft:the_nether".equals(dimensionKey = level.dimension().location().toString()) && groundPos.getY() >= 123) {
            return false;
        }
        boolean bl = isLiquid = !groundState.getFluidState().isEmpty();
        if (isLiquid) {
            boolean isWater;
            boolean bl2 = isWater = groundState.is(Blocks.WATER) || groundState.getFluidState().is((Fluid)Fluids.WATER) || groundState.getFluidState().is((Fluid)Fluids.FLOWING_WATER);
            if (!isWater) {
                return false;
            }
        }
        boolean isSolid = groundState.isSolid();
        boolean isWater = isLiquid && (groundState.is(Blocks.WATER) || groundState.getFluidState().is((Fluid)Fluids.WATER) || groundState.getFluidState().is((Fluid)Fluids.FLOWING_WATER));
        boolean isAir = groundState.isAir();
        boolean hasGround = isSolid || isWater;
        return hasGround;
    }

    private static void prepareGround(Level level, int x, int finalY, int z) {
        BlockPos groundPos = new BlockPos(x, finalY - 1, z);
        BlockState groundState = level.getBlockState(groundPos);
        if (!groundState.isSolid() && !groundState.isAir()) {
            boolean isLiquid;
            boolean bl = isLiquid = !groundState.getFluidState().isEmpty();
            if (isLiquid) {
                boolean isWater;
                boolean bl2 = isWater = groundState.is(Blocks.WATER) || groundState.getFluidState().is((Fluid)Fluids.WATER) || groundState.getFluidState().is((Fluid)Fluids.FLOWING_WATER);
                if (isWater) {
                    level.setBlock(groundPos, Blocks.COBBLESTONE.defaultBlockState(), 3);
                }
            }
        }
    }

    @Deprecated
    private static boolean isSafePosition(Level level, int x, int y, int z) {
        return PortableDislocatorItem.isSpaceFree(level, x, y, z) && PortableDislocatorItem.hasValidGround(level, x, y, z);
    }

    private static void handleDislocatorActivation(Player player, String source) {
        UUID playerId = player.getUUID();
        TeleportationData data = activeTeleportations.get(playerId);
        if (data != null) {
            return;
        }
        ItemStack dislocatorStack = PortableDislocatorItem.findPortableDislocator(player);
        if (dislocatorStack == null) {
            return;
        }
        PortableDislocatorItem dislocator = (PortableDislocatorItem)dislocatorStack.getItem();
        if (!dislocator.hasEnoughEnergy(dislocatorStack)) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        LOGGER.info("Checking hands - Main: {}, Off: {}", (Object)(mainHand.isEmpty() ? "empty" : mainHand.getItem().toString()), (Object)(offHand.isEmpty() ? "empty" : offHand.getItem().toString()));
        ItemStack compassStack = null;
        String compassType = null;
        if (PortableDislocatorItem.isValidCompass(mainHand)) {
            compassStack = mainHand;
            compassType = PortableDislocatorItem.getCompassType(mainHand);
            LOGGER.info("Found valid compass in main hand: {}", (Object)compassType);
        } else if (PortableDislocatorItem.isValidCompass(offHand)) {
            compassStack = offHand;
            compassType = PortableDislocatorItem.getCompassType(offHand);
            LOGGER.info("Found valid compass in off hand: {}", (Object)compassType);
        }
        if (compassStack == null || compassType == null) {
            return;
        }
        Pair<Integer, Integer> coordinates = PortableDislocatorItem.extractCoordinates(compassStack, player);
        if (coordinates == null) {
            return;
        }
        if (player.level().isClientSide) {
            TeleportRequest request = new TeleportRequest(player, (Integer)coordinates.getLeft(), (Integer)coordinates.getRight());
            pendingRequests.put(player.getUUID(), request);
        } else if (dislocator.consumeEnergyForTeleportation(dislocatorStack)) {
            PortableDislocatorItem.startServerTeleportation(player, (Integer)coordinates.getLeft(), (Integer)coordinates.getRight());
        }
    }

    @Deprecated
    public static void startTeleportation(Player player, int targetX, int targetZ) {
        LOGGER.info("Legacy startTeleportation called for player {} to coordinates {}, {}", new Object[]{player.getName().getString(), targetX, targetZ});
        if (player.level().isClientSide) {
            TeleportRequest request = new TeleportRequest(player, targetX, targetZ);
            pendingRequests.put(player.getUUID(), request);
        } else {
            PortableDislocatorItem.startServerTeleportation(player, targetX, targetZ);
        }
    }

    private static Pair<Integer, Integer> extractCoordinates(ItemStack compass, Player player) {
        String compassType = compass.getItem().toString();
        DataComponentMap components = compass.getComponents();
        try {
            Pattern patternZX;
            Pattern patternXZ;
            if (compass.has(DataComponents.CUSTOM_DATA)) {
                CustomData customData = (CustomData)compass.get(DataComponents.CUSTOM_DATA);
                CompoundTag nbt = customData.copyTag();
                if (compassType.contains("naturescompass")) {
                    if (nbt.contains("naturescompass:found_x") && nbt.contains("naturescompass:found_z")) {
                        int x = nbt.getInt("naturescompass:found_x");
                        int z = nbt.getInt("naturescompass:found_z");
                        return Pair.of((Object)x, (Object)z);
                    }
                } else if (compassType.contains("explorerscompass") && nbt.contains("explorerscompass:found_x") && nbt.contains("explorerscompass:found_z")) {
                    int x = nbt.getInt("explorerscompass:found_x");
                    int z = nbt.getInt("explorerscompass:found_z");
                    return Pair.of((Object)x, (Object)z);
                }
            }
            Integer foundX = null;
            Integer foundZ = null;
            for (TypedDataComponent entry : components) {
                String componentKey = entry.type().toString();
                Object componentValue = entry.value();
                if (compassType.contains("naturescompass")) {
                    if (componentKey.contains("found_x") && componentValue instanceof Integer) {
                        foundX = (Integer)componentValue;
                    }
                    if (!componentKey.contains("found_z") || !(componentValue instanceof Integer)) continue;
                    foundZ = (Integer)componentValue;
                    continue;
                }
                if (!compassType.contains("explorerscompass")) continue;
                if (componentKey.contains("found_x") && componentValue instanceof Integer) {
                    foundX = (Integer)componentValue;
                }
                if (!componentKey.contains("found_z") || !(componentValue instanceof Integer)) continue;
                foundZ = (Integer)componentValue;
            }
            if (foundX != null && foundZ != null) {
                return Pair.of(foundX, foundZ);
            }
            String compassString = compass.toString();
            if (compassType.contains("naturescompass")) {
                patternXZ = Pattern.compile("naturescompass:found_x=(-?\\d+).*?naturescompass:found_z=(-?\\d+)");
                patternZX = Pattern.compile("naturescompass:found_z=(-?\\d+).*?naturescompass:found_x=(-?\\d+)");
            } else if (compassType.contains("explorerscompass")) {
                patternXZ = Pattern.compile("explorerscompass:found_x=(-?\\d+).*?explorerscompass:found_z=(-?\\d+)");
                patternZX = Pattern.compile("explorerscompass:found_z=(-?\\d+).*?explorerscompass:found_x=(-?\\d+)");
            } else {
                return null;
            }
            Matcher matcherXZ = patternXZ.matcher(compassString);
            if (matcherXZ.find()) {
                int x = Integer.parseInt(matcherXZ.group(1));
                int z = Integer.parseInt(matcherXZ.group(2));
                return Pair.of((Object)x, (Object)z);
            }
            Matcher matcherZX = patternZX.matcher(compassString);
            if (matcherZX.find()) {
                int z = Integer.parseInt(matcherZX.group(1));
                int x = Integer.parseInt(matcherZX.group(2));
                return Pair.of((Object)x, (Object)z);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isValidCompass(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return itemId.toString().equals("naturescompass:naturescompass") || itemId.toString().equals("explorerscompass:explorerscompass");
    }

    private static String getCompassType(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        String itemIdString = itemId.toString();
        if (itemIdString.equals("naturescompass:naturescompass")) {
            return "naturescompass";
        }
        if (itemIdString.equals("explorerscompass:explorerscompass")) {
            return "explorerscompass";
        }
        return null;
    }

    public boolean canStoreEnergy() {
        if (Config.portableDislocatorEnergyConsume == 0) {
            return false;
        }
        return Config.portableDislocatorEnergyCapacity > 0;
    }

    public int getEffectiveEnergyConsumption() {
        if (!this.canStoreEnergy()) {
            return 0;
        }
        int configuredConsumption = Config.portableDislocatorEnergyConsume;
        int maxCapacity = Config.portableDislocatorEnergyCapacity;
        if (configuredConsumption > maxCapacity) {
            return maxCapacity;
        }
        return configuredConsumption;
    }

    public boolean requiresEnergyToFunction() {
        return this.getEffectiveEnergyConsumption() > 0;
    }

    public int getEnergyStored(ItemStack stack) {
        if (!this.canStoreEnergy()) {
            return 0;
        }
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return tag.getInt(ENERGY_TAG);
    }

    public void setEnergyStored(ItemStack stack, int energy) {
        if (!this.canStoreEnergy()) {
            return;
        }
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int maxCapacity = Config.portableDislocatorEnergyCapacity;
        tag.putInt(ENERGY_TAG, Math.max(0, Math.min(energy, maxCapacity)));
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public int getMaxEnergyStored(ItemStack stack) {
        if (!this.canStoreEnergy()) {
            return 0;
        }
        return Config.portableDislocatorEnergyCapacity;
    }

    public boolean hasEnoughEnergy(ItemStack stack) {
        if (!this.requiresEnergyToFunction()) {
            return true;
        }
        int currentEnergy = this.getEnergyStored(stack);
        return currentEnergy >= this.getEffectiveEnergyConsumption();
    }

    public boolean consumeEnergyForTeleportation(ItemStack stack) {
        if (!this.requiresEnergyToFunction()) {
            return true;
        }
        int consumption = this.getEffectiveEnergyConsumption();
        if (consumption <= 0) {
            return true;
        }
        int currentEnergy = this.getEnergyStored(stack);
        if (currentEnergy >= consumption) {
            this.setEnergyStored(stack, currentEnergy - consumption);
            return true;
        }
        return false;
    }

    public static ItemStack findPortableDislocator(Player player) {
        ItemStack mainHand = player.getMainHandItem();
        if (mainHand.getItem() instanceof PortableDislocatorItem) {
            return mainHand;
        }
        ItemStack offHand = player.getOffhandItem();
        if (offHand.getItem() instanceof PortableDislocatorItem) {
            return offHand;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!(stack.getItem() instanceof PortableDislocatorItem)) continue;
            return stack;
        }
        return null;
    }

    private static class TeleportRequest {
        Player player;
        int targetX;
        int targetZ;

        TeleportRequest(Player player, int targetX, int targetZ) {
            this.player = player;
            this.targetX = targetX;
            this.targetZ = targetZ;
        }
    }

    private static class TeleportationData {
        Player player;
        int targetX;
        int targetZ;
        int originalX;
        int originalZ;
        int ticksWaiting;
        ChunkPos loadedChunk;
        ServerLevel chunkLevel;
        int attemptCount;

        TeleportationData(Player player, int targetX, int targetZ) {
            this.player = player;
            this.targetX = targetX;
            this.targetZ = targetZ;
            this.originalX = targetX;
            this.originalZ = targetZ;
            this.ticksWaiting = 0;
            this.loadedChunk = null;
            this.chunkLevel = null;
            this.attemptCount = 1;
        }
    }
}

