/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.item.custom;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.unfamily.iskautils.Config;
import net.unfamily.iskautils.client.VectorCharmMovement;
import net.unfamily.iskautils.util.ModUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorCharmItem
extends Item {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectorCharmItem.class);
    private static final float BOOST_MULTIPLIER = 1.5f;
    private static final String ENERGY_TAG = "Energy";
    private final int effectiveEnergyCapacity;
    private final List<Integer> effectiveEnergyConsume = new ArrayList<Integer>();

    public VectorCharmItem(Item.Properties properties) {
        super(properties);
        this.effectiveEnergyCapacity = -1;
    }

    private int determineEffectiveCapacity() {
        if (Config.vectorCharmEnergyConsume == null) {
            return 0;
        }
        if (Config.vectorCharmEnergyConsume.stream().allMatch(consume -> consume <= 0)) {
            return 0;
        }
        if (Config.vectorCharmEnergyCapacity <= 0) {
            return 0;
        }
        return Config.vectorCharmEnergyCapacity;
    }

    private List<Integer> determineEffectiveConsumption() {
        ArrayList<Integer> effectiveConsume = new ArrayList<Integer>();
        if (Config.vectorCharmEnergyConsume == null) {
            return Arrays.asList(0, 0, 0, 0, 0, 0, 0);
        }
        int capacity = this.determineEffectiveCapacity();
        for (Integer consume : Config.vectorCharmEnergyConsume) {
            if (capacity <= 0) {
                effectiveConsume.add(0);
                continue;
            }
            if (consume <= 0) {
                effectiveConsume.add(0);
                continue;
            }
            if (consume > capacity) {
                effectiveConsume.add(capacity);
                continue;
            }
            effectiveConsume.add(consume);
        }
        return effectiveConsume;
    }

    public boolean canStoreEnergy() {
        int capacity = this.effectiveEnergyCapacity == -1 ? this.determineEffectiveCapacity() : this.effectiveEnergyCapacity;
        return capacity > 0;
    }

    public boolean requiresEnergyToFunction() {
        List<Integer> consumption = this.getEffectiveEnergyConsume();
        return consumption.stream().anyMatch(consume -> consume > 0);
    }

    public int getEnergyConsumption(int speedLevel) {
        List<Integer> consumption = this.getEffectiveEnergyConsume();
        if (speedLevel < 0 || speedLevel >= consumption.size()) {
            return 0;
        }
        return consumption.get(speedLevel);
    }

    private int getEffectiveEnergyCapacity() {
        if (this.effectiveEnergyCapacity == -1) {
            return this.determineEffectiveCapacity();
        }
        return this.effectiveEnergyCapacity;
    }

    private List<Integer> getEffectiveEnergyConsume() {
        if (this.effectiveEnergyConsume.isEmpty() || Config.vectorCharmEnergyConsume == null) {
            return this.determineEffectiveConsumption();
        }
        return this.effectiveEnergyConsume;
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (this.canStoreEnergy()) {
            int energy = this.getEnergyStored(stack);
            int maxEnergy = this.getMaxEnergyStored(stack);
            tooltipComponents.add((Component)Component.literal((String)String.format("Energy: %,d / %,d RF", energy, maxEnergy)));
            if (this.requiresEnergyToFunction()) {
                List<Integer> consumption = this.getEffectiveEnergyConsume();
                tooltipComponents.add((Component)Component.literal((String)"\u00a77Energy consumption per tick:"));
                String[] speedNames = new String[]{"None", "Slow", "Moderate", "Fast", "Extreme", "Ultra", "Hover"};
                for (int i = 0; i < speedNames.length; ++i) {
                    int energyConsumption = i < consumption.size() ? consumption.get(i) : 0;
                    tooltipComponents.add((Component)Component.literal((String)("\u00a78  " + speedNames[i] + ": " + energyConsumption + " RF")));
                }
            }
        } else {
            tooltipComponents.add((Component)Component.literal((String)"\u00a77No energy required"));
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            VectorCharmMovement.applyMovement(player, stack);
        }
    }

    public boolean consumeEnergyForMovement(ItemStack stack, int speedLevel) {
        if (!this.requiresEnergyToFunction()) {
            return true;
        }
        int consumption = this.getEnergyConsumption(speedLevel);
        if (consumption <= 0) {
            return true;
        }
        int currentEnergy = this.getEnergyStored(stack);
        if (currentEnergy >= consumption) {
            this.setEnergyStored(stack, currentEnergy - consumption);
            return true;
        }
        return false;
    }

    public boolean consumeEnergy(ItemStack stack, int speedLevel) {
        if (!this.requiresEnergyToFunction()) {
            return true;
        }
        int consumption = this.getEnergyConsumption(speedLevel);
        if (consumption <= 0) {
            return true;
        }
        int currentEnergy = this.getEnergyStored(stack);
        if (currentEnergy >= consumption) {
            this.setEnergyStored(stack, currentEnergy - consumption);
            return true;
        }
        return false;
    }

    public int getEnergyStored(ItemStack stack) {
        if (!this.canStoreEnergy()) {
            return 0;
        }
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return tag.getInt(ENERGY_TAG);
    }

    public void setEnergyStored(ItemStack stack, int energy) {
        if (!this.canStoreEnergy()) {
            return;
        }
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        int maxCapacity = this.getEffectiveEnergyCapacity();
        tag.putInt(ENERGY_TAG, Math.max(0, Math.min(energy, maxCapacity)));
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return this.getEffectiveEnergyCapacity();
    }

    public static ItemStack getActiveVectorCharm(Player player, int speedLevel) {
        ItemStack curioCharm;
        VectorCharmItem charm;
        VectorCharmItem charm2;
        ItemStack mainHand = player.getMainHandItem();
        Item item = mainHand.getItem();
        if (item instanceof VectorCharmItem && (charm2 = (VectorCharmItem)item).hasEnoughEnergy(mainHand, speedLevel)) {
            return mainHand;
        }
        ItemStack offHand = player.getOffhandItem();
        Item item2 = offHand.getItem();
        if (item2 instanceof VectorCharmItem && (charm = (VectorCharmItem)item2).hasEnoughEnergy(offHand, speedLevel)) {
            return offHand;
        }
        if (ModUtils.isCuriosLoaded() && (curioCharm = VectorCharmItem.checkCuriosSlots(player, speedLevel)) != null) {
            return curioCharm;
        }
        for (ItemStack stack : player.getInventory().items) {
            VectorCharmItem charm3;
            Item item3 = stack.getItem();
            if (!(item3 instanceof VectorCharmItem) || !(charm3 = (VectorCharmItem)item3).hasEnoughEnergy(stack, speedLevel)) continue;
            return stack;
        }
        return null;
    }

    public boolean hasEnoughEnergy(ItemStack stack, int speedLevel) {
        if (!this.requiresEnergyToFunction()) {
            return true;
        }
        int consumption = this.getEnergyConsumption(speedLevel);
        if (consumption <= 0) {
            return true;
        }
        int currentEnergy = this.getEnergyStored(stack);
        return currentEnergy >= consumption;
    }

    public static boolean hasVectorCharm(Player player) {
        return VectorCharmItem.getActiveVectorCharm(player, 0) != null;
    }

    private static ItemStack checkCuriosSlots(Player player, int speedLevel) {
        try {
            Class<?> curioApiClass = Class.forName("top.theillusivec4.curios.api.CuriosApi");
            try {
                Object allEquipped;
                Method getAllEquippedMethod = curioApiClass.getMethod("getAllEquipped", LivingEntity.class);
                if (getAllEquippedMethod != null && (allEquipped = getAllEquippedMethod.invoke(null, player)) instanceof Iterable) {
                    Iterable items = (Iterable)allEquipped;
                    for (Object itemPair : items) {
                        VectorCharmItem charm;
                        Method getStackMethod = itemPair.getClass().getMethod("getRight", new Class[0]);
                        ItemStack stack = (ItemStack)getStackMethod.invoke(itemPair, new Object[0]);
                        Item item = stack.getItem();
                        if (!(item instanceof VectorCharmItem) || !(charm = (VectorCharmItem)item).hasEnoughEnergy(stack, speedLevel)) continue;
                        return stack;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error checking Curios slots: {}", (Object)e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static Vec3 applyBoost(LivingEntity entity, Vec3 motion, int speedLevel) {
        VectorCharmItem charm;
        Item item;
        Player player;
        ItemStack activeCharm;
        if (entity instanceof Player && (activeCharm = VectorCharmItem.getActiveVectorCharm(player = (Player)entity, speedLevel)) != null && (item = activeCharm.getItem()) instanceof VectorCharmItem && (charm = (VectorCharmItem)item).consumeEnergyForVectorPlate(activeCharm, speedLevel)) {
            return motion.multiply(1.5, 1.5, 1.5);
        }
        return motion;
    }

    private boolean consumeEnergyForVectorPlate(ItemStack stack, int speedLevel) {
        if (!this.requiresEnergyToFunction()) {
            return true;
        }
        int consumption = this.getEnergyConsumption(speedLevel) / 4;
        if (consumption <= 0) {
            return true;
        }
        int currentEnergy = this.getEnergyStored(stack);
        if (currentEnergy >= consumption) {
            this.setEnergyStored(stack, currentEnergy - consumption);
            return true;
        }
        return false;
    }

    public static Vec3 applyBoost(LivingEntity entity, Vec3 motion) {
        return VectorCharmItem.applyBoost(entity, motion, 1);
    }

    public static String getCharmLocation(Player player, ItemStack stack) {
        if (player.getMainHandItem() == stack) {
            return "Main Hand";
        }
        if (player.getOffhandItem() == stack) {
            return "Off Hand";
        }
        if (ModUtils.isCuriosLoaded()) {
            try {
                Object allEquipped;
                Class<?> curioApiClass = Class.forName("top.theillusivec4.curios.api.CuriosApi");
                Method getAllEquippedMethod = curioApiClass.getMethod("getAllEquipped", LivingEntity.class);
                if (getAllEquippedMethod != null && (allEquipped = getAllEquippedMethod.invoke(null, player)) instanceof Iterable) {
                    Iterable items = (Iterable)allEquipped;
                    for (Object itemPair : items) {
                        Method getStackMethod = itemPair.getClass().getMethod("getRight", new Class[0]);
                        ItemStack curioStack = (ItemStack)getStackMethod.invoke(itemPair, new Object[0]);
                        if (curioStack != stack) continue;
                        return "Curios";
                    }
                }
            }
            catch (Exception curioApiClass) {
                // empty catch block
            }
        }
        for (int i = 0; i < player.getInventory().items.size(); ++i) {
            if (player.getInventory().items.get(i) != stack) continue;
            return "Inventory Slot " + i;
        }
        return "Unknown";
    }
}

