/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.network.packet;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.unfamily.iskautils.item.custom.PortableDislocatorItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortableDislocatorC2SPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortableDislocatorC2SPacket.class);
    private final int targetX;
    private final int targetZ;

    public PortableDislocatorC2SPacket(int targetX, int targetZ) {
        this.targetX = targetX;
        this.targetZ = targetZ;
    }

    public void handle(ServerPlayer player) {
        if (player == null) {
            LOGGER.error("Server player is null while handling PortableDislocatorC2SPacket");
            return;
        }
        LOGGER.info("Received Portable Dislocator packet from player {} for coordinates {}, {}", new Object[]{player.getName().getString(), this.targetX, this.targetZ});
        PortableDislocatorItem.startTeleportation((Player)player, this.targetX, this.targetZ);
    }

    public static void handlePacket(PortableDislocatorC2SPacket packet, ServerPlayer player) {
        packet.handle(player);
    }
}

