/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.iskautils.network.packet;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.unfamily.iskautils.data.VectorCharmData;
import net.unfamily.iskautils.data.VectorFactorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorCharmC2SPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectorCharmC2SPacket.class);
    private final byte newFactor;
    private final boolean isVertical;

    public VectorCharmC2SPacket(byte newFactor, boolean isVertical) {
        this.newFactor = newFactor;
        this.isVertical = isVertical;
    }

    public void handle(ServerPlayer player) {
        if (player == null) {
            LOGGER.error("Server player is null while handling VectorCharmC2SPacket");
            return;
        }
        ServerLevel level = player.serverLevel();
        VectorCharmData data = VectorCharmData.get(level);
        if (this.isVertical) {
            data.setVerticalFactor((Player)player, this.newFactor);
            VectorFactorType newFactorType = VectorFactorType.fromByte(this.newFactor);
            player.sendSystemMessage((Component)Component.translatable((String)"message.iska_utils.vector_vertical_factor", (Object[])new Object[]{Component.translatable((String)("vectorcharm.factor." + newFactorType.getName()))}));
        } else {
            data.setHorizontalFactor((Player)player, this.newFactor);
            VectorFactorType newFactorType = VectorFactorType.fromByte(this.newFactor);
            player.sendSystemMessage((Component)Component.translatable((String)"message.iska_utils.vector_horizontal_factor", (Object[])new Object[]{Component.translatable((String)("vectorcharm.factor." + newFactorType.getName()))}));
        }
    }

    public static void handlePacket(VectorCharmC2SPacket packet, ServerPlayer player) {
        packet.handle(player);
    }
}

