/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.discordchat;

import com.yourname.discordchat.ChannelTopicUpdater;
import com.yourname.discordchat.DiscordChatCommand;
import com.yourname.discordchat.MessageManager;
import java.util.EnumSet;
import java.util.HashMap;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;
import org.bukkit.Bukkit;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementDisplay;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DiscordChat
extends JavaPlugin
implements Listener {
    private JDA jda;
    private String channelId;
    private String token;
    private boolean enabled;
    private MessageManager messageManager;
    private ChannelTopicUpdater topicUpdater;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.messageManager = new MessageManager(this);
        this.topicUpdater = new ChannelTopicUpdater(this);
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents(this, this);
        if (this.enabled) {
            this.initializeBot();
        } else {
            this.getLogger().warning(this.messageManager.getMessage("console.plugin_disabled_config"));
        }
        this.getCommand("discordchat").setExecutor(new DiscordChatCommand(this));
        this.getLogger().info(this.messageManager.getMessage("console.plugin_enabled"));
    }

    @Override
    public void onDisable() {
        if (this.topicUpdater != null) {
            this.topicUpdater.stop();
        }
        if (this.jda != null) {
            TextChannel channel = this.jda.getTextChannelById(this.channelId);
            if (channel != null) {
                String shutdownMessage = this.messageManager.getMessage("discord.server_stop");
                channel.sendMessage(shutdownMessage).queue();
            }
            this.jda.shutdown();
        }
        this.getLogger().info(this.messageManager.getMessage("console.plugin_disabled"));
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.token = config.getString("discord.token", "");
        this.channelId = config.getString("discord.channel-id", "");
        this.enabled = config.getBoolean("discord.enabled", true);
        if (this.enabled) {
            if (this.token.isEmpty() || this.token.equals("YOUR_BOT_TOKEN_HERE")) {
                this.getLogger().severe(this.messageManager.getMessage("errors.token_missing"));
                this.enabled = false;
            }
            if (this.channelId.isEmpty() || this.channelId.equals("YOUR_CHANNEL_ID_HERE")) {
                this.getLogger().severe(this.messageManager.getMessage("errors.channel_id_missing"));
                this.enabled = false;
            }
        }
    }

    public void reloadDiscordBot() {
        if (this.topicUpdater != null) {
            this.topicUpdater.stop();
        }
        if (this.jda != null) {
            this.jda.shutdown();
        }
        this.reloadConfig();
        this.messageManager.reloadMessages();
        if (this.topicUpdater != null) {
            this.topicUpdater.loadConfig();
        }
        this.loadConfig();
        if (this.enabled) {
            this.initializeBot();
        }
    }

    private void initializeBot() {
        try {
            this.getLogger().info(this.messageManager.getMessage("console.bot_connecting"));
            this.jda = JDABuilder.createDefault(this.token, EnumSet.allOf(GatewayIntent.class)).addEventListeners(new DiscordListener()).build();
            this.jda.awaitReady();
            this.getLogger().info(this.messageManager.getMessage("console.bot_connected"));
            TextChannel channel = this.jda.getTextChannelById(this.channelId);
            if (channel != null) {
                String startupMessage = this.messageManager.getMessage("discord.server_start");
                channel.sendMessage(startupMessage).queue();
            } else {
                this.getLogger().warning(this.messageManager.getFormattedMessage("errors.channel_not_found", "channel_id", this.channelId));
            }
            if (this.topicUpdater != null) {
                this.topicUpdater.start();
            }
        }
        catch (InterruptedException e) {
            this.getLogger().severe("Bot initialization was interrupted");
            this.enabled = false;
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            String errorMessage = this.messageManager.getFormattedMessage("errors.bot_initialization_failed", "error", e.getMessage());
            this.getLogger().severe(errorMessage);
            e.printStackTrace();
            this.enabled = false;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.enabled || event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        String message = event.getMessage();
        this.sendMessageToDiscord(player.getName(), message);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.enabled) {
            return;
        }
        Player player = event.getPlayer();
        this.sendJoinMessageToDiscord(player.getName());
        if (this.topicUpdater != null && this.topicUpdater.isEnabled()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.topicUpdater.forceUpdate(), 20L);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.enabled) {
            return;
        }
        if (!this.getConfig().getBoolean("features.send_death_messages", false)) {
            return;
        }
        Player player = event.getEntity();
        String deathMessage = event.getDeathMessage();
        if (deathMessage != null && !deathMessage.isEmpty()) {
            this.sendDeathMessageToDiscord(player.getName(), deathMessage);
        }
    }

    @EventHandler
    public void onPlayerAdvancement(PlayerAdvancementDoneEvent event) {
        if (!this.enabled) {
            return;
        }
        if (!this.getConfig().getBoolean("features.send_advancement_messages", false)) {
            return;
        }
        Player player = event.getPlayer();
        Advancement advancement = event.getAdvancement();
        if (advancement.getKey().getNamespace().equals("minecraft") && advancement.getDisplay() != null) {
            String keyPath = advancement.getKey().getKey();
            if (keyPath.startsWith("recipes/")) {
                return;
            }
            AdvancementDisplay display = advancement.getDisplay();
            String advancementTitle = display.getTitle();
            String advancementDescription = display.getDescription();
            if (advancementTitle != null && !advancementTitle.trim().isEmpty() && advancementDescription != null && !advancementDescription.trim().isEmpty()) {
                this.sendAdvancementMessageToDiscord(player.getName(), advancementTitle, advancementDescription);
            }
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent event) {
        if (!this.enabled) {
            return;
        }
        Player player = event.getPlayer();
        this.sendLeaveMessageToDiscord(player.getName());
        if (this.topicUpdater != null && this.topicUpdater.isEnabled()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.topicUpdater.forceUpdate(), 20L);
        }
    }

    private void sendMessageToDiscord(String username, String message) {
        if (this.jda == null) {
            return;
        }
        TextChannel channel = this.jda.getTextChannelById(this.channelId);
        if (channel != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("username", username);
            placeholders.put("message", message);
            String formattedMessage = this.messageManager.getDiscordMessage("discord.player_chat", placeholders);
            channel.sendMessage(formattedMessage).queue();
        }
    }

    private void sendJoinMessageToDiscord(String username) {
        if (this.jda == null) {
            return;
        }
        TextChannel channel = this.jda.getTextChannelById(this.channelId);
        if (channel != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("username", username);
            placeholders.put("player_count", String.valueOf(Bukkit.getOnlinePlayers().size()));
            placeholders.put("max_players", String.valueOf(Bukkit.getMaxPlayers()));
            String joinMessage = this.messageManager.getDiscordMessage("discord.player_join", placeholders);
            channel.sendMessage(joinMessage).queue();
        }
    }

    private void sendLeaveMessageToDiscord(String username) {
        if (this.jda == null) {
            return;
        }
        TextChannel channel = this.jda.getTextChannelById(this.channelId);
        if (channel != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("username", username);
            placeholders.put("player_count", String.valueOf(Bukkit.getOnlinePlayers().size() - 1));
            placeholders.put("max_players", String.valueOf(Bukkit.getMaxPlayers()));
            String leaveMessage = this.messageManager.getDiscordMessage("discord.player_leave", placeholders);
            channel.sendMessage(leaveMessage).queue();
        }
    }

    private void sendDeathMessageToDiscord(String username, String deathMessage) {
        if (this.jda == null) {
            return;
        }
        TextChannel channel = this.jda.getTextChannelById(this.channelId);
        if (channel != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("username", username);
            placeholders.put("death_message", deathMessage);
            String formattedMessage = this.messageManager.getDiscordMessage("discord.player_death", placeholders);
            channel.sendMessage(formattedMessage).queue();
        }
    }

    private void sendAdvancementMessageToDiscord(String username, String advancementTitle, String advancementDescription) {
        if (this.jda == null) {
            return;
        }
        TextChannel channel = this.jda.getTextChannelById(this.channelId);
        if (channel != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("username", username);
            placeholders.put("advancement_title", advancementTitle);
            placeholders.put("advancement_description", advancementDescription);
            String formattedMessage = this.messageManager.getDiscordMessage("discord.player_advancement", placeholders);
            channel.sendMessage(formattedMessage).queue();
        }
    }

    public void sendMessageToMinecraft(String username, String message) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("username", username);
        placeholders.put("message", message);
        String formattedMessage = this.messageManager.getFormattedMinecraftMessage("minecraft.discord_message", placeholders);
        Bukkit.broadcastMessage(formattedMessage);
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public boolean isBotConnected() {
        return this.jda != null && this.jda.getStatus() == JDA.Status.CONNECTED;
    }

    public JDA getJDA() {
        return this.jda;
    }

    public ChannelTopicUpdater getTopicUpdater() {
        return this.topicUpdater;
    }

    private class DiscordListener
    extends ListenerAdapter {
        private DiscordListener() {
        }

        @Override
        public void onMessageReceived(MessageReceivedEvent event) {
            if (event.getAuthor().isBot()) {
                return;
            }
            if (!event.getChannel().getId().equals(DiscordChat.this.channelId)) {
                return;
            }
            String username = event.getAuthor().getName();
            String message = event.getMessage().getContentDisplay();
            Bukkit.getScheduler().runTask((Plugin)DiscordChat.this, () -> DiscordChat.this.sendMessageToMinecraft(username, message));
        }
    }
}

