/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.discordchat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageManager {
    private final JavaPlugin plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration(this.messagesFile);
        try (InputStream defConfigStream = this.plugin.getResource("messages.yml");){
            if (defConfigStream != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration(new InputStreamReader(defConfigStream, StandardCharsets.UTF_8));
                this.messagesConfig.setDefaults(defConfig);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.WARNING, "Could not load default messages", e);
        }
    }

    public void reloadMessages() {
        this.loadMessages();
    }

    public String getMessage(String path) {
        return this.messagesConfig.getString(path, "Message not found: " + path);
    }

    public String getFormattedMessage(String path, Map<String, String> placeholders) {
        String message = this.getMessage(path);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return message;
    }

    public String getFormattedMessage(String path, Map<String, String> placeholders, String customFormat) {
        String message;
        String string = message = customFormat != null && !customFormat.isEmpty() ? customFormat : this.getMessage(path);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return message;
    }

    public String getFormattedMinecraftMessage(String path, Map<String, String> placeholders) {
        String message = this.getFormattedMessage(path, placeholders);
        return ChatColor.translateAlternateColorCodes('&', message);
    }

    public String getFormattedMessage(String path, String placeholder, String value) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put(placeholder, value);
        return this.getFormattedMessage(path, placeholders);
    }

    public String getFormattedMinecraftMessage(String path, String placeholder, String value) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put(placeholder, value);
        return this.getFormattedMinecraftMessage(path, placeholders);
    }

    public String getDiscordMessage(String path, Map<String, String> placeholders) {
        return this.getFormattedMessage(path, placeholders);
    }

    public String getDiscordMessage(String path, String placeholder, String value) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put(placeholder, value);
        return this.getDiscordMessage(path, placeholders);
    }

    public void saveMessages() {
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save messages.yml", e);
        }
    }
}

