/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.interactions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.concrete.PrivateChannel;
import net.dv8tion.jda.api.interactions.DiscordLocale;
import net.dv8tion.jda.api.interactions.Interaction;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.JDAImpl;
import net.dv8tion.jda.internal.entities.GuildImpl;
import net.dv8tion.jda.internal.entities.MemberImpl;
import net.dv8tion.jda.internal.entities.UserImpl;
import net.dv8tion.jda.internal.entities.channel.concrete.PrivateChannelImpl;

public class InteractionImpl
implements Interaction {
    protected final long id;
    protected final int type;
    protected final String token;
    protected final Guild guild;
    protected final Member member;
    protected final User user;
    protected final Channel channel;
    protected final DiscordLocale userLocale;
    protected final JDAImpl api;
    private boolean isAck;

    public InteractionImpl(JDAImpl jda, DataObject data) {
        this.api = jda;
        this.id = data.getUnsignedLong("id");
        this.token = data.getString("token");
        this.type = data.getInt("type");
        this.guild = jda.getGuildById(data.getUnsignedLong("guild_id", 0L));
        this.userLocale = DiscordLocale.from(data.getString("locale", "en-US"));
        DataObject channelJson = data.getObject("channel");
        if (this.guild != null) {
            this.member = jda.getEntityBuilder().createMember((GuildImpl)this.guild, data.getObject("member"));
            jda.getEntityBuilder().updateMemberCache((MemberImpl)this.member);
            this.user = this.member.getUser();
            this.channel = this.guild.getGuildChannelById(channelJson.getUnsignedLong("id"));
        } else {
            this.member = null;
            long channelId = channelJson.getUnsignedLong("id");
            ChannelType type = ChannelType.fromId(channelJson.getInt("type"));
            if (type != ChannelType.PRIVATE) {
                throw new IllegalArgumentException("Received interaction in unexpected channel type! Type " + (Object)((Object)type) + " is not supported yet!");
            }
            PrivateChannel channel = jda.getPrivateChannelById(channelId);
            if (channel == null) {
                channel = jda.getEntityBuilder().createPrivateChannel(DataObject.empty().put("id", channelId).put("recipient", data.getObject("user")));
            }
            this.channel = channel;
            User user = channel.getUser();
            if (user == null) {
                user = jda.getEntityBuilder().createUser(data.getObject("user"));
                ((PrivateChannelImpl)channel).setUser(user);
                ((UserImpl)user).setPrivateChannel(channel);
            }
            this.user = user;
        }
    }

    public synchronized void releaseHook(boolean success) {
    }

    public synchronized boolean ack() {
        boolean wasAck = this.isAck;
        this.isAck = true;
        return wasAck;
    }

    @Override
    public synchronized boolean isAcknowledged() {
        return this.isAck;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public int getTypeRaw() {
        return this.type;
    }

    @Override
    @Nonnull
    public String getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    @Nullable
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    @Nonnull
    public DiscordLocale getUserLocale() {
        return this.userLocale;
    }

    @Override
    @Nonnull
    public User getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public Member getMember() {
        return this.member;
    }

    @Override
    @Nonnull
    public JDA getJDA() {
        return this.api;
    }
}

