/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.chat;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslationProvider;
import net.md_5.bungee.chat.TranslationRegistry;

public final class TranslatableComponent
extends BaseComponent {
    private static final Pattern FORMAT = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");
    private String translate;
    private List<BaseComponent> with;
    private String fallback;

    public TranslatableComponent(TranslatableComponent original) {
        super(original);
        this.setTranslate(original.getTranslate());
        this.setFallback(original.getFallback());
        if (original.getWith() != null) {
            ArrayList<BaseComponent> temp = new ArrayList<BaseComponent>();
            for (BaseComponent baseComponent : original.getWith()) {
                temp.add(baseComponent.duplicate());
            }
            this.setWith(temp);
        }
    }

    public TranslatableComponent(String translate, Object ... with) {
        this.setTranslate(translate);
        if (with != null && with.length != 0) {
            ArrayList<BaseComponent> temp = new ArrayList<BaseComponent>();
            for (Object w : with) {
                if (w instanceof BaseComponent) {
                    temp.add((BaseComponent)w);
                    continue;
                }
                temp.add(new TextComponent(String.valueOf(w)));
            }
            this.setWith(temp);
        }
    }

    public TranslatableComponent(TranslationProvider translatable, Object ... with) {
        this(translatable.getTranslationKey(), with);
    }

    @Override
    public TranslatableComponent duplicate() {
        return new TranslatableComponent(this);
    }

    public void setWith(List<BaseComponent> components) {
        for (BaseComponent component : components) {
            component.parent = this;
        }
        this.with = components;
    }

    public void addWith(String text) {
        this.addWith(new TextComponent(text));
    }

    public void addWith(BaseComponent component) {
        if (this.with == null) {
            this.with = new ArrayList<BaseComponent>();
        }
        component.parent = this;
        this.with.add(component);
    }

    @Override
    protected void toPlainText(BaseComponent.StringVisitor builder) {
        this.convert(builder, false);
        super.toPlainText(builder);
    }

    @Override
    protected void toLegacyText(BaseComponent.StringVisitor builder) {
        this.convert(builder, true);
        super.toLegacyText(builder);
    }

    private void convert(BaseComponent.StringVisitor builder, boolean applyFormat) {
        String trans = TranslationRegistry.INSTANCE.translate(this.translate);
        if (trans.equals(this.translate) && this.fallback != null) {
            trans = this.fallback;
        }
        Matcher matcher = FORMAT.matcher(trans);
        int position = 0;
        int i = 0;
        while (matcher.find(position)) {
            int pos = matcher.start();
            if (pos != position) {
                if (applyFormat) {
                    this.addFormat(builder);
                }
                builder.append(trans.substring(position, pos));
            }
            position = matcher.end();
            String formatCode = matcher.group(2);
            switch (formatCode.charAt(0)) {
                case 'd': 
                case 's': {
                    String withIndex2 = matcher.group(1);
                    BaseComponent withComponent = this.with.get(withIndex2 != null ? Integer.parseInt(withIndex2) - 1 : i++);
                    if (applyFormat) {
                        withComponent.toLegacyText(builder);
                        break;
                    }
                    withComponent.toPlainText(builder);
                    break;
                }
                case '%': {
                    if (applyFormat) {
                        this.addFormat(builder);
                    }
                    builder.append(Character.valueOf('%'));
                }
            }
        }
        if (trans.length() != position) {
            if (applyFormat) {
                this.addFormat(builder);
            }
            builder.append(trans.substring(position, trans.length()));
        }
    }

    @Generated
    public String getTranslate() {
        return this.translate;
    }

    @Generated
    public List<BaseComponent> getWith() {
        return this.with;
    }

    @Generated
    public String getFallback() {
        return this.fallback;
    }

    @Generated
    public void setTranslate(String translate) {
        this.translate = translate;
    }

    @Generated
    public void setFallback(String fallback) {
        this.fallback = fallback;
    }

    @Override
    @Generated
    public String toString() {
        return "TranslatableComponent(translate=" + this.getTranslate() + ", with=" + this.getWith() + ", fallback=" + this.getFallback() + ")";
    }

    @Generated
    public TranslatableComponent() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslatableComponent)) {
            return false;
        }
        TranslatableComponent other = (TranslatableComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$translate = this.getTranslate();
        String other$translate = other.getTranslate();
        if (this$translate == null ? other$translate != null : !this$translate.equals(other$translate)) {
            return false;
        }
        List<BaseComponent> this$with = this.getWith();
        List<BaseComponent> other$with = other.getWith();
        if (this$with == null ? other$with != null : !((Object)this$with).equals(other$with)) {
            return false;
        }
        String this$fallback = this.getFallback();
        String other$fallback = other.getFallback();
        return !(this$fallback == null ? other$fallback != null : !this$fallback.equals(other$fallback));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TranslatableComponent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $translate = this.getTranslate();
        result = result * 59 + ($translate == null ? 43 : $translate.hashCode());
        List<BaseComponent> $with = this.getWith();
        result = result * 59 + ($with == null ? 43 : ((Object)$with).hashCode());
        String $fallback = this.getFallback();
        result = result * 59 + ($fallback == null ? 43 : $fallback.hashCode());
        return result;
    }
}

