/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.discordchat;

import com.yourname.discordchat.DiscordChat;
import com.yourname.discordchat.MessageManager;
import java.util.HashMap;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.managers.channel.concrete.TextChannelManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChannelTopicUpdater {
    private final DiscordChat plugin;
    private final MessageManager messageManager;
    private BukkitRunnable updateTask;
    private boolean enabled;
    private int updateInterval;
    private String topicFormat;
    private String lastTopic = "";
    private long lastUpdateTime = 0L;
    private static final long MIN_UPDATE_INTERVAL_MS = 30000L;
    private boolean isUpdating = false;

    public ChannelTopicUpdater(DiscordChat plugin) {
        this.plugin = plugin;
        this.messageManager = plugin.getMessageManager();
        this.loadConfig();
    }

    public void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("features.channel_topic.enabled", true);
        this.updateInterval = Math.max(30, this.plugin.getConfig().getInt("features.channel_topic.update_interval", 30));
        this.topicFormat = this.plugin.getConfig().getString("features.channel_topic.format", "\ud83c\udfae Minecraft Server | Online: {online_players}/{max_players} | Server: {server_name}");
    }

    public void start() {
        if (!this.enabled) {
            this.plugin.getLogger().info(this.messageManager.getMessage("console.channel_topic_disabled"));
            return;
        }
        this.stop();
        this.updateTask = new BukkitRunnable(){

            public void run() {
                long currentTime = System.currentTimeMillis();
                if (currentTime - ChannelTopicUpdater.this.lastUpdateTime < 30000L) {
                    return;
                }
                ChannelTopicUpdater.this.updateChannelTopic();
            }
        };
        this.updateTask.runTaskTimerAsynchronously((Plugin)this.plugin, 20L, (long)this.updateInterval * 20L);
    }

    public void stop() {
        if (this.updateTask != null && !this.updateTask.isCancelled()) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChannelTopic() {
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        try {
            JDA jda = this.plugin.getJDA();
            if (jda == null || jda.getStatus() != JDA.Status.CONNECTED) {
                return;
            }
            String channelId = this.plugin.getConfig().getString("discord.channel-id", "");
            if (channelId.isEmpty()) {
                return;
            }
            TextChannel channel = jda.getTextChannelById(channelId);
            if (channel == null) {
                return;
            }
            String newTopic = this.generateChannelTopic();
            if (newTopic.equals(this.lastTopic)) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastUpdateTime < 30000L) {
                if (this.plugin.getConfig().getBoolean("debug", false)) {
                    this.plugin.getLogger().info("Skipping channel topic update due to rate limiting");
                }
                return;
            }
            this.lastUpdateTime = currentTime;
            ((TextChannelManager)channel.getManager().setTopic(newTopic)).queue(success -> {
                this.lastTopic = newTopic;
                if (this.plugin.getConfig().getBoolean("debug", false)) {
                    this.plugin.getLogger().info(this.messageManager.getMessage("console.channel_topic_updated"));
                }
                this.isUpdating = false;
            }, throwable -> {
                this.isUpdating = false;
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("error", throwable.getMessage());
                String errorMessage = throwable.getMessage();
                if (errorMessage != null && errorMessage.contains("429")) {
                    this.plugin.getLogger().warning("Rate limited while updating channel topic. Consider increasing update interval to 60+ seconds.");
                    this.lastUpdateTime = currentTime + 60000L;
                } else {
                    this.plugin.getLogger().warning(this.messageManager.getFormattedMessage("console.channel_topic_error", placeholders));
                    if (errorMessage != null) {
                        if (errorMessage.toLowerCase().contains("missing permissions") || errorMessage.toLowerCase().contains("permission")) {
                            this.plugin.getLogger().warning("Missing permissions to update channel topic. Bot needs 'Manage Channels' permission.");
                        } else if (errorMessage.toLowerCase().contains("missing access")) {
                            this.plugin.getLogger().warning("Bot doesn't have access to update the channel topic.");
                        }
                    }
                }
            });
        }
        finally {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.isUpdating = false;
            }, 20L);
        }
    }

    private String generateChannelTopic() {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        int maxPlayers = Bukkit.getMaxPlayers();
        String serverName = this.plugin.getConfig().getString("server.name", "");
        if (serverName == null || serverName.isEmpty()) {
            try {
                serverName = Bukkit.getServer().getName();
            }
            catch (Exception e) {
                serverName = "Minecraft Server";
            }
            if (serverName == null || serverName.isEmpty() || serverName.equals("Unknown Server")) {
                serverName = "Minecraft Server";
            }
        }
        placeholders.put("online_players", String.valueOf(onlinePlayers));
        placeholders.put("max_players", String.valueOf(maxPlayers));
        placeholders.put("server_name", serverName);
        return this.messageManager.getFormattedMessage("", placeholders, this.topicFormat);
    }

    public void forceUpdate() {
        if (this.enabled) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastUpdateTime >= 30000L) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::updateChannelTopic);
            } else if (this.plugin.getConfig().getBoolean("debug", false)) {
                this.plugin.getLogger().info("Force update skipped due to rate limiting");
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRunning() {
        return this.updateTask != null && !this.updateTask.isCancelled();
    }
}

