/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.discordchat;

import com.yourname.discordchat.DiscordChat;
import com.yourname.discordchat.MessageManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class DiscordChatCommand
implements CommandExecutor,
TabCompleter {
    private final DiscordChat plugin;
    private final MessageManager messageManager;

    public DiscordChatCommand(DiscordChat plugin) {
        this.plugin = plugin;
        this.messageManager = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        if (args2.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (args2[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("discordchat.reload")) {
                    sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.no_permission", new HashMap<String, String>()));
                    return true;
                }
                try {
                    this.plugin.reloadDiscordBot();
                    sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.reload_success", new HashMap<String, String>()));
                }
                catch (Exception e) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("error", e.getMessage());
                    sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.reload_error", placeholders));
                }
                return true;
            }
            case "help": {
                this.sendHelpMessage(sender);
                return true;
            }
            case "status": {
                if (!sender.hasPermission("discordchat.status")) {
                    sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.no_permission", new HashMap<String, String>()));
                    return true;
                }
                this.sendStatusMessage(sender);
                return true;
            }
            case "toggle": {
                if (!sender.hasPermission("discordchat.admin")) {
                    sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.no_permission", new HashMap<String, String>()));
                    return true;
                }
                if (args2.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /discordchat toggle <deaths|advancements|playercount|topic|nicknames>");
                    return true;
                }
                return this.handleToggleCommand(sender, args2[1]);
            }
        }
        sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.unknown_command", new HashMap<String, String>()));
        return true;
    }

    private boolean handleToggleCommand(CommandSender sender, String feature) {
        switch (feature.toLowerCase()) {
            case "deaths": 
            case "death": {
                boolean currentDeath = this.plugin.getConfig().getBoolean("features.send_death_messages", false);
                this.plugin.getConfig().set("features.send_death_messages", (Object)(!currentDeath ? 1 : 0));
                this.plugin.saveConfig();
                sender.sendMessage("\u00a7eDeath messages " + (!currentDeath ? "\u00a7aenabled" : "\u00a7cdisabled"));
                return true;
            }
            case "advancements": 
            case "advancement": {
                boolean currentAdv = this.plugin.getConfig().getBoolean("features.send_advancement_messages", false);
                this.plugin.getConfig().set("features.send_advancement_messages", (Object)(!currentAdv ? 1 : 0));
                this.plugin.saveConfig();
                sender.sendMessage("\u00a7eAdvancement messages " + (!currentAdv ? "\u00a7aenabled" : "\u00a7cdisabled"));
                return true;
            }
            case "playercount": 
            case "count": {
                boolean currentCount = this.plugin.getConfig().getBoolean("features.show_player_count", true);
                this.plugin.getConfig().set("features.show_player_count", (Object)(!currentCount ? 1 : 0));
                this.plugin.saveConfig();
                sender.sendMessage("\u00a7ePlayer count display " + (!currentCount ? "\u00a7aenabled" : "\u00a7cdisabled"));
                return true;
            }
            case "topic": {
                boolean currentTopic = this.plugin.getConfig().getBoolean("features.channel_topic.enabled", true);
                this.plugin.getConfig().set("features.channel_topic.enabled", (Object)(!currentTopic ? 1 : 0));
                this.plugin.saveConfig();
                if (this.plugin.getTopicUpdater() != null) {
                    this.plugin.getTopicUpdater().stop();
                    this.plugin.getTopicUpdater().loadConfig();
                    if (!currentTopic) {
                        this.plugin.getTopicUpdater().start();
                    }
                }
                sender.sendMessage("\u00a7eChannel topic updates " + (!currentTopic ? "\u00a7aenabled" : "\u00a7cdisabled"));
                return true;
            }
            case "nicknames": 
            case "nickname": {
                boolean currentNicknames = this.plugin.getConfig().getBoolean("discord.use_nicknames", true);
                this.plugin.getConfig().set("discord.use_nicknames", (Object)(!currentNicknames ? 1 : 0));
                this.plugin.saveConfig();
                sender.sendMessage("\u00a7eDiscord nicknames " + (!currentNicknames ? "\u00a7aenabled" : "\u00a7cdisabled"));
                return true;
            }
        }
        sender.sendMessage("\u00a7cUnknown feature. Available: deaths, advancements, playercount, topic, nicknames");
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.help_header", new HashMap<String, String>()));
        sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.help_command", new HashMap<String, String>()));
        if (sender.hasPermission("discordchat.reload")) {
            sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.help_reload", new HashMap<String, String>()));
        }
        if (sender.hasPermission("discordchat.status")) {
            sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.help_status", new HashMap<String, String>()));
        }
        if (sender.hasPermission("discordchat.admin")) {
            sender.sendMessage("\u00a7e/discordchat toggle <feature> \u00a7f- Toggle features on/off");
        }
    }

    private void sendStatusMessage(CommandSender sender) {
        sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.status_header", new HashMap<String, String>()));
        HashMap<String, String> enabledPlaceholders = new HashMap<String, String>();
        boolean enabled = this.plugin.getConfig().getBoolean("discord.enabled");
        enabledPlaceholders.put("status", enabled ? this.messageManager.getMessage("commands.status_yes") : this.messageManager.getMessage("commands.status_no"));
        sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.status_enabled", enabledPlaceholders));
        HashMap<String, String> channelPlaceholders = new HashMap<String, String>();
        String channelId = this.plugin.getConfig().getString("discord.channel-id", "");
        channelPlaceholders.put("channel_id", channelId.isEmpty() || channelId.equals("YOUR_CHANNEL_ID_HERE") ? this.messageManager.getMessage("commands.status_not_configured") : channelId);
        sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.status_channel", channelPlaceholders));
        HashMap<String, String> botPlaceholders = new HashMap<String, String>();
        botPlaceholders.put("status", this.plugin.isBotConnected() ? this.messageManager.getMessage("commands.status_connected") : this.messageManager.getMessage("commands.status_disconnected"));
        sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.status_bot_connected", botPlaceholders));
        if (this.plugin.getTopicUpdater() != null) {
            HashMap<String, String> topicPlaceholders = new HashMap<String, String>();
            boolean topicEnabled = this.plugin.getTopicUpdater().isEnabled();
            boolean topicRunning = this.plugin.getTopicUpdater().isRunning();
            String topicStatus = !topicEnabled ? "\u00a7cDisabled" : (topicRunning ? "\u00a7aRunning" : "\u00a7eEnabled but not running");
            topicPlaceholders.put("status", topicStatus);
            sender.sendMessage(this.messageManager.getFormattedMinecraftMessage("commands.status_topic_updater", topicPlaceholders));
        }
        sender.sendMessage("\u00a76=== Features ===");
        boolean deathEnabled = this.plugin.getConfig().getBoolean("features.send_death_messages", false);
        sender.sendMessage("\u00a7eDeath Messages: " + (deathEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        boolean advancementEnabled = this.plugin.getConfig().getBoolean("features.send_advancement_messages", false);
        sender.sendMessage("\u00a7eAdvancement Messages: " + (advancementEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        boolean playerCountEnabled = this.plugin.getConfig().getBoolean("features.show_player_count", true);
        sender.sendMessage("\u00a7ePlayer Count Display: " + (playerCountEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        boolean nicknamesEnabled = this.plugin.getConfig().getBoolean("discord.use_nicknames", true);
        sender.sendMessage("\u00a7eDiscord Nicknames: " + (nicknamesEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args2) {
        if (args2.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            completions.add("help");
            if (sender.hasPermission("discordchat.reload")) {
                completions.add("reload");
            }
            if (sender.hasPermission("discordchat.status")) {
                completions.add("status");
            }
            if (sender.hasPermission("discordchat.admin")) {
                completions.add("toggle");
            }
            return completions.stream().filter(s -> s.startsWith(args2[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args2.length == 2 && args2[0].equalsIgnoreCase("toggle")) {
            ArrayList<String> features = new ArrayList<String>();
            features.add("deaths");
            features.add("advancements");
            features.add("playercount");
            features.add("topic");
            features.add("nicknames");
            return features.stream().filter(s -> s.startsWith(args2[1].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

