/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.nms.v1_21_R6.entity;

import java.util.Set;
import kr.toxicity.hud.nms.v1_21_R6.entity.CraftsKt;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.util.TriState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataContainer;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010 \u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020!H\u0016J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020!H\u0016J0\u0010-\u001a\u0004\b\u0002H.\"\n\b\u0000\u0010.*\u0004\u0018\u00010/2\u0010\u00100\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H.01H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J:\u0010-\u001a\u0004\b\u0002H.\"\n\b\u0000\u0010.*\u0004\u0018\u00010/2\u0010\u00100\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H.012\b\u00103\u001a\u0004\u0018\u000104H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b9\u00a8\u00066"}, d2={"Lkr/toxicity/hud/nms/v1_21_R6/entity/CraftLivingEntityView;", "Lorg/bukkit/craftbukkit/entity/CraftLivingEntity;", "source", "<init>", "(Lorg/bukkit/craftbukkit/entity/CraftLivingEntity;)V", "getSource", "()Lorg/bukkit/craftbukkit/entity/CraftLivingEntity;", "getHandle", "Lnet/minecraft/world/entity/LivingEntity;", "getPersistentDataContainer", "Lorg/bukkit/craftbukkit/persistence/CraftPersistentDataContainer;", "getLastDamageCause", "Lorg/bukkit/event/entity/EntityDamageEvent;", "setLastDamageCause", "", "event", "permissionValue", "Lnet/kyori/adventure/util/TriState;", "permission", "Lorg/bukkit/permissions/Permission;", "", "getEffectivePermissions", "", "Lorg/bukkit/permissions/PermissionAttachmentInfo;", "hasPermission", "", "name", "perm", "isPermissionSet", "recalculatePermissions", "getTargetBlockExact", "Lorg/bukkit/block/Block;", "maxDistance", "", "rayTraceBlocks", "Lorg/bukkit/util/RayTraceResult;", "", "addPotionEffect", "effect", "Lorg/bukkit/potion/PotionEffect;", "getEquipment", "Lorg/bukkit/inventory/EntityEquipment;", "getShieldBlockingDelay", "setShieldBlockingDelay", "delay", "launchProjectile", "T", "Lorg/bukkit/entity/Projectile;", "projectile", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/bukkit/entity/Projectile;", "velocity", "Lorg/bukkit/util/Vector;", "(Ljava/lang/Class;Lorg/bukkit/util/Vector;)Lorg/bukkit/entity/Projectile;", "v1_21_R6"})
public final class CraftLivingEntityView
extends CraftLivingEntity {
    @NotNull
    private final CraftLivingEntity source;

    public CraftLivingEntityView(@NotNull CraftLivingEntity source) {
        Intrinsics.checkNotNullParameter(source, "source");
        Server server = Bukkit.getServer();
        Intrinsics.checkNotNull(server, "null cannot be cast to non-null type org.bukkit.craftbukkit.CraftServer");
        CraftServer craftServer = (CraftServer)server;
        Entity entity = CraftsKt.getUnsafeHandle((CraftEntity)source);
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
        super(craftServer, (EntityLiving)entity);
        this.source = source;
    }

    @NotNull
    public final CraftLivingEntity getSource() {
        return this.source;
    }

    @NotNull
    public EntityLiving getHandle() {
        Entity entity = CraftsKt.getUnsafeHandle((CraftEntity)this.source);
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
        return (EntityLiving)entity;
    }

    @NotNull
    public CraftPersistentDataContainer getPersistentDataContainer() {
        CraftPersistentDataContainer craftPersistentDataContainer = this.source.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(craftPersistentDataContainer, "getPersistentDataContainer(...)");
        return craftPersistentDataContainer;
    }

    @Nullable
    public EntityDamageEvent getLastDamageCause() {
        return this.source.getLastDamageCause();
    }

    public void setLastDamageCause(@Nullable EntityDamageEvent event) {
        this.source.setLastDamageCause(event);
    }

    @NotNull
    public TriState permissionValue(@NotNull Permission permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        TriState triState = this.source.permissionValue(permission);
        Intrinsics.checkNotNullExpressionValue(triState, "permissionValue(...)");
        return triState;
    }

    @NotNull
    public TriState permissionValue(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        TriState triState = this.source.permissionValue(permission);
        Intrinsics.checkNotNullExpressionValue(triState, "permissionValue(...)");
        return triState;
    }

    @NotNull
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        Set set = this.source.getEffectivePermissions();
        Intrinsics.checkNotNullExpressionValue(set, "getEffectivePermissions(...)");
        return set;
    }

    public boolean hasPermission(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.source.hasPermission(name);
    }

    public boolean hasPermission(@NotNull Permission perm) {
        Intrinsics.checkNotNullParameter(perm, "perm");
        return this.source.hasPermission(perm);
    }

    public boolean isPermissionSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.source.isPermissionSet(name);
    }

    public boolean isPermissionSet(@NotNull Permission perm) {
        Intrinsics.checkNotNullParameter(perm, "perm");
        return this.source.isPermissionSet(perm);
    }

    public void recalculatePermissions() {
        this.source.recalculatePermissions();
    }

    @Nullable
    public Block getTargetBlockExact(int maxDistance) {
        return this.source.getTargetBlockExact(maxDistance);
    }

    @Nullable
    public RayTraceResult rayTraceBlocks(double maxDistance) {
        return this.source.rayTraceBlocks(maxDistance);
    }

    public boolean addPotionEffect(@NotNull PotionEffect effect) {
        Intrinsics.checkNotNullParameter(effect, "effect");
        return this.source.addPotionEffect(effect);
    }

    @NotNull
    public EntityEquipment getEquipment() {
        EntityEquipment entityEquipment = this.source.getEquipment();
        Intrinsics.checkNotNullExpressionValue(entityEquipment, "getEquipment(...)");
        return entityEquipment;
    }

    public int getShieldBlockingDelay() {
        return this.source.getShieldBlockingDelay();
    }

    public void setShieldBlockingDelay(int delay) {
        this.source.setShieldBlockingDelay(delay);
    }

    @NotNull
    public <T extends Projectile> T launchProjectile(@NotNull Class<? extends T> projectile) {
        Intrinsics.checkNotNullParameter(projectile, "projectile");
        Projectile projectile2 = this.source.launchProjectile(projectile);
        Intrinsics.checkNotNullExpressionValue(projectile2, "launchProjectile(...)");
        return (T)projectile2;
    }

    @NotNull
    public <T extends Projectile> T launchProjectile(@NotNull Class<? extends T> projectile, @Nullable Vector velocity) {
        Intrinsics.checkNotNullParameter(projectile, "projectile");
        Projectile projectile2 = this.source.launchProjectile(projectile, velocity);
        Intrinsics.checkNotNullExpressionValue(projectile2, "launchProjectile(...)");
        return (T)projectile2;
    }
}

