/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.bootstrap.bukkit.compatibility.craftengine;

import java.io.File;
import java.util.Map;
import kr.toxicity.hud.api.BetterHudBootstrap;
import kr.toxicity.hud.api.listener.HudListener;
import kr.toxicity.hud.api.placeholder.HudPlaceholder;
import kr.toxicity.hud.api.plugin.ReloadFlagType;
import kr.toxicity.hud.api.plugin.ReloadState;
import kr.toxicity.hud.api.trigger.HudTrigger;
import kr.toxicity.hud.api.update.UpdateEvent;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.bootstrap.bukkit.BukkitBootstrapImpl;
import kr.toxicity.hud.bootstrap.bukkit.compatibility.Compatibility;
import kr.toxicity.hud.bootstrap.bukkit.util.EventsKt;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.NoWhenBranchMatchedException;
import kr.toxicity.hud.shaded.kotlin.collections.MapsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.PluginsKt;
import net.momirealms.craftengine.bukkit.api.event.AsyncResourcePackCacheEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R0\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR8\u0010\u000f\u001a&\u0012\u0004\u0012\u00020\u0005\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\n0\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR&\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR&\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00140\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR&\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00140\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lkr/toxicity/hud/bootstrap/bukkit/compatibility/craftengine/CraftEngineCompatibility;", "Lkr/toxicity/hud/bootstrap/bukkit/compatibility/Compatibility;", "<init>", "()V", "website", "", "getWebsite", "()Ljava/lang/String;", "triggers", "", "Lkr/toxicity/hud/shaded/kotlin/Function1;", "Lkr/toxicity/hud/api/yaml/YamlObject;", "Lkr/toxicity/hud/api/trigger/HudTrigger;", "getTriggers", "()Ljava/util/Map;", "listeners", "Lkr/toxicity/hud/api/update/UpdateEvent;", "Lkr/toxicity/hud/api/listener/HudListener;", "getListeners", "numbers", "Lkr/toxicity/hud/api/placeholder/HudPlaceholder;", "", "getNumbers", "strings", "getStrings", "booleans", "", "getBooleans", "start", "", "bukkit"})
public final class CraftEngineCompatibility
implements Compatibility {
    @NotNull
    private final String website;
    @NotNull
    private final Map<String, Function1<YamlObject, HudTrigger<?>>> triggers = MapsKt.emptyMap();
    @NotNull
    private final Map<String, Function1<YamlObject, Function1<UpdateEvent, HudListener>>> listeners = MapsKt.emptyMap();
    @NotNull
    private final Map<String, HudPlaceholder<Number>> numbers = MapsKt.emptyMap();
    @NotNull
    private final Map<String, HudPlaceholder<String>> strings = MapsKt.emptyMap();
    @NotNull
    private final Map<String, HudPlaceholder<Boolean>> booleans = MapsKt.emptyMap();

    public CraftEngineCompatibility() {
        this.website = "https://polymart.org/product/7624/craftengine";
    }

    @Override
    @NotNull
    public String getWebsite() {
        return this.website;
    }

    @Override
    @NotNull
    public Map<String, Function1<YamlObject, HudTrigger<?>>> getTriggers() {
        return this.triggers;
    }

    @Override
    @NotNull
    public Map<String, Function1<YamlObject, Function1<UpdateEvent, HudListener>>> getListeners() {
        return this.listeners;
    }

    @Override
    @NotNull
    public Map<String, HudPlaceholder<Number>> getNumbers() {
        return this.numbers;
    }

    @Override
    @NotNull
    public Map<String, HudPlaceholder<String>> getStrings() {
        return this.strings;
    }

    @Override
    @NotNull
    public Map<String, HudPlaceholder<Boolean>> getBooleans() {
        return this.booleans;
    }

    @Override
    public void start() {
        ConfigManagerImpl.INSTANCE.preReload();
        if (ConfigManagerImpl.INSTANCE.getMergeWithExternalResources()) {
            BetterHudBootstrap betterHudBootstrap = PluginsKt.getBOOTSTRAP();
            Intrinsics.checkNotNull(betterHudBootstrap, "null cannot be cast to non-null type kr.toxicity.hud.bootstrap.bukkit.BukkitBootstrapImpl");
            ((BukkitBootstrapImpl)betterHudBootstrap).setSkipInitialReload(true);
        }
        EventsKt.registerListener(new Listener(){

            @EventHandler
            public final void generate(AsyncResourcePackCacheEvent $this$generate) {
                Intrinsics.checkNotNullParameter($this$generate, "<this>");
                if (!ConfigManagerImpl.INSTANCE.getMergeWithExternalResources()) {
                    return;
                }
                ReloadState reloadState = PluginsKt.getPLUGIN().reload(new ReloadFlagType[0]);
                Intrinsics.checkNotNullExpressionValue(reloadState, "reload(...)");
                ReloadState result = reloadState;
                if (result instanceof ReloadState.Success) {
                    File file = ((ReloadState.Success)result).directory();
                    if (file != null) {
                        File it = file;
                        boolean bl = false;
                        if (it.isFile()) {
                            $this$generate.cacheData().externalZips().add(it.toPath());
                        } else if (it.isDirectory()) {
                            $this$generate.cacheData().externalFolders().add(it.toPath());
                        }
                        String[] stringArray = new String[]{"Successfully merged with CraftEngine."};
                        PluginsKt.info(stringArray);
                    }
                } else if (result instanceof ReloadState.OnReload) {
                    String[] stringArray = new String[]{"BetterHud is still on reload!"};
                    PluginsKt.warn(stringArray);
                } else if (result instanceof ReloadState.Failure) {
                    Throwable throwable = ((ReloadState.Failure)result).throwable();
                    Intrinsics.checkNotNullExpressionValue(throwable, "throwable(...)");
                    FunctionsKt.handle(throwable, "Unable to merge with CraftEngine.");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        });
    }
}

