/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.layout;

import kr.toxicity.hud.api.yaml.YamlElement;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.element.HudElement;
import kr.toxicity.hud.layout.LayoutGroup;
import kr.toxicity.hud.location.PixelLocation;
import kr.toxicity.hud.placeholder.ColorOverride;
import kr.toxicity.hud.placeholder.ConditionBuilder;
import kr.toxicity.hud.placeholder.ConditionSource;
import kr.toxicity.hud.placeholder.PlaceholderSource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shader.RenderScale;
import kr.toxicity.hud.shader.ShaderProperty;
import kr.toxicity.hud.util.YamlsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004:\u0002$%R\u0012\u0010\u0005\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006&\u00c0\u0006\u0003"}, d2={"Lkr/toxicity/hud/layout/HudLayout;", "T", "Lkr/toxicity/hud/element/HudElement;", "Lkr/toxicity/hud/placeholder/ConditionSource;", "Lkr/toxicity/hud/placeholder/PlaceholderSource;", "source", "getSource", "()Lkr/toxicity/hud/element/HudElement;", "outline", "", "getOutline", "()I", "layer", "getLayer", "property", "getProperty", "follow", "", "getFollow", "()Ljava/lang/String;", "location", "Lkr/toxicity/hud/location/PixelLocation;", "getLocation", "()Lkr/toxicity/hud/location/PixelLocation;", "cancelIfFollowerNotExists", "", "getCancelIfFollowerNotExists", "()Z", "renderScale", "Lkr/toxicity/hud/shader/RenderScale;", "getRenderScale", "()Lkr/toxicity/hud/shader/RenderScale;", "tick", "", "getTick", "()J", "Identifier", "Impl", "dist"})
public interface HudLayout<T extends HudElement>
extends ConditionSource,
PlaceholderSource {
    @NotNull
    public T getSource();

    public int getOutline();

    public int getLayer();

    public int getProperty();

    @Nullable
    public String getFollow();

    @NotNull
    public PixelLocation getLocation();

    public boolean getCancelIfFollowerNotExists();

    @NotNull
    public RenderScale getRenderScale();

    public long getTick();

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static <T extends HudElement> ConditionSource.Impl plus(@NotNull HudLayout<T> $this, @NotNull ConditionSource other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return ((HudLayout)$this).plus(other);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lkr/toxicity/hud/layout/HudLayout$Identifier;", "", "name", "", "getName", "()Ljava/lang/String;", "dist"})
    public static interface Identifier {
        @NotNull
        public String getName();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u00020\u0005B'\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0011\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0004H\u0096\u0003R\u0016\u0010\u0006\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0012\u00100\u001a\u000201X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0012\u00104\u001a\u000205X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0012\u00108\u001a\u00020\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0012\u0010;\u001a\u00020\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b<\u0010:\u00a8\u0006="}, d2={"Lkr/toxicity/hud/layout/HudLayout$Impl;", "T", "Lkr/toxicity/hud/element/HudElement;", "Lkr/toxicity/hud/layout/HudLayout;", "Lkr/toxicity/hud/placeholder/ConditionSource;", "Lkr/toxicity/hud/placeholder/PlaceholderSource;", "source", "group", "Lkr/toxicity/hud/layout/LayoutGroup;", "originalLoc", "Lkr/toxicity/hud/location/PixelLocation;", "yaml", "Lkr/toxicity/hud/api/yaml/YamlObject;", "<init>", "(Lkr/toxicity/hud/element/HudElement;Lkr/toxicity/hud/layout/LayoutGroup;Lkr/toxicity/hud/location/PixelLocation;Lkr/toxicity/hud/api/yaml/YamlObject;)V", "getSource", "()Lkr/toxicity/hud/element/HudElement;", "Lkr/toxicity/hud/element/HudElement;", "outline", "", "getOutline", "()I", "layer", "getLayer", "property", "getProperty", "follow", "", "getFollow", "()Ljava/lang/String;", "location", "getLocation", "()Lkr/toxicity/hud/location/PixelLocation;", "cancelIfFollowerNotExists", "", "getCancelIfFollowerNotExists", "()Z", "renderScale", "Lkr/toxicity/hud/shader/RenderScale;", "getRenderScale", "()Lkr/toxicity/hud/shader/RenderScale;", "tick", "", "getTick", "()J", "plus", "Lkr/toxicity/hud/placeholder/ConditionSource$Impl;", "other", "colorOverrides", "Lkr/toxicity/hud/placeholder/ColorOverride$Builder;", "getColorOverrides", "()Lkr/toxicity/hud/placeholder/ColorOverride$Builder;", "conditions", "Lkr/toxicity/hud/placeholder/ConditionBuilder;", "getConditions", "()Lkr/toxicity/hud/placeholder/ConditionBuilder;", "placeholderOption", "getPlaceholderOption", "()Lkr/toxicity/hud/api/yaml/YamlObject;", "stringPlaceholderFormat", "getStringPlaceholderFormat", "dist"})
    public static final class Impl<T extends HudElement>
    implements HudLayout<T>,
    ConditionSource,
    PlaceholderSource {
        private final /* synthetic */ ConditionSource.Impl $$delegate_0;
        private final /* synthetic */ PlaceholderSource.Impl $$delegate_1;
        @NotNull
        private final T source;
        private final int outline;
        private final int layer;
        private final int property;
        @Nullable
        private final String follow;
        @NotNull
        private final PixelLocation location;
        private final boolean cancelIfFollowerNotExists;
        @NotNull
        private final RenderScale renderScale;
        private final long tick;

        public Impl(@NotNull T source, @NotNull LayoutGroup group, @NotNull PixelLocation originalLoc, @NotNull YamlObject yaml) {
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(group, "group");
            Intrinsics.checkNotNullParameter(originalLoc, "originalLoc");
            Intrinsics.checkNotNullParameter(yaml, "yaml");
            this.$$delegate_0 = ((ConditionSource)source).plus(new ConditionSource.Impl(yaml)).plus(group);
            this.$$delegate_1 = new PlaceholderSource.Impl(yaml);
            this.source = source;
            this.outline = YamlsKt.getShadow(yaml, "outline");
            this.layer = yaml.getAsInt("layer", 0);
            YamlElement yamlElement = yaml.get("properties");
            this.property = ShaderProperty.Companion.properties(yamlElement != null ? yamlElement.asArray() : null);
            YamlElement yamlElement2 = yaml.get("follow");
            this.follow = yamlElement2 != null ? yamlElement2.asString() : null;
            this.location = new PixelLocation(yaml).plus(originalLoc).plus(PixelLocation.Companion.getHotBarHeight());
            this.cancelIfFollowerNotExists = yaml.getAsBoolean("cancel-if-follower-not-exists", true);
            this.renderScale = RenderScale.Companion.fromConfig(this.getLocation(), yaml);
            this.tick = yaml.getAsLong("tick", 1L);
        }

        @Override
        @NotNull
        public T getSource() {
            return this.source;
        }

        @Override
        public int getOutline() {
            return this.outline;
        }

        @Override
        public int getLayer() {
            return this.layer;
        }

        @Override
        public int getProperty() {
            return this.property;
        }

        @Override
        @Nullable
        public String getFollow() {
            return this.follow;
        }

        @Override
        @NotNull
        public PixelLocation getLocation() {
            return this.location;
        }

        @Override
        public boolean getCancelIfFollowerNotExists() {
            return this.cancelIfFollowerNotExists;
        }

        @Override
        @NotNull
        public RenderScale getRenderScale() {
            return this.renderScale;
        }

        @Override
        public long getTick() {
            return this.tick;
        }

        @Override
        @NotNull
        public ConditionBuilder getConditions() {
            return this.$$delegate_0.getConditions();
        }

        @Override
        @NotNull
        public ColorOverride.Builder getColorOverrides() {
            return this.$$delegate_0.getColorOverrides();
        }

        @Override
        @NotNull
        public ConditionSource.Impl plus(@NotNull ConditionSource other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return this.$$delegate_0.plus(other);
        }

        @Override
        @NotNull
        public YamlObject getPlaceholderOption() {
            return this.$$delegate_1.getPlaceholderOption();
        }

        @Override
        @NotNull
        public YamlObject getStringPlaceholderFormat() {
            return this.$$delegate_1.getStringPlaceholderFormat();
        }
    }
}

