/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.layout;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import kr.toxicity.hud.api.yaml.YamlElement;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.background.HudBackground;
import kr.toxicity.hud.element.HudElement;
import kr.toxicity.hud.element.TextElement;
import kr.toxicity.hud.equation.TEquation;
import kr.toxicity.hud.layout.HudLayout;
import kr.toxicity.hud.layout.LayoutGroup;
import kr.toxicity.hud.layout.enums.LayoutAlign;
import kr.toxicity.hud.location.PixelLocation;
import kr.toxicity.hud.manager.BackgroundManager;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.manager.MinecraftManager;
import kr.toxicity.hud.manager.TextManagerImpl;
import kr.toxicity.hud.placeholder.ColorOverride;
import kr.toxicity.hud.placeholder.ConditionBuilder;
import kr.toxicity.hud.placeholder.ConditionSource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Pair;
import kr.toxicity.hud.shaded.kotlin.TuplesKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function2;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Ref;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shader.HudShader;
import kr.toxicity.hud.shader.RenderScale;
import kr.toxicity.hud.shader.ShaderGroup;
import kr.toxicity.hud.text.ImageTextScale;
import kr.toxicity.hud.util.AdventuresKt;
import kr.toxicity.hud.util.ComponentDeserializer;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.GsonsKt;
import kr.toxicity.hud.util.MapsKt;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u0000 H2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005HIJKLJ\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\fH\u0016J\b\u0010@\u001a\u00020AH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0012\u0010!\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0012\u0010%\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u0012\u0010'\u001a\u00020(X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0012\u0010+\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000eR\u0012\u0010-\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000eR\u0012\u0010/\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u000eR\u0012\u00101\u001a\u00020\"X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010$R\u0012\u00103\u001a\u000204X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0012\u00107\u001a\u000208X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\"\u0010B\u001a\u0012\u0012\u0004\u0012\u00020D0Cj\b\u0012\u0004\u0012\u00020D`EX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006M\u00c0\u0006\u0003"}, d2={"Lkr/toxicity/hud/layout/TextLayout;", "Lkr/toxicity/hud/layout/HudLayout;", "Lkr/toxicity/hud/element/TextElement;", "pattern", "", "getPattern", "()Ljava/lang/String;", "scale", "", "getScale", "()D", "space", "", "getSpace", "()I", "align", "Lkr/toxicity/hud/layout/enums/LayoutAlign;", "getAlign", "()Lkr/toxicity/hud/layout/enums/LayoutAlign;", "lineAlign", "getLineAlign", "color", "Lnet/kyori/adventure/text/format/TextColor;", "getColor", "()Lnet/kyori/adventure/text/format/TextColor;", "numberEquation", "Lkr/toxicity/hud/equation/TEquation;", "getNumberEquation", "()Lkr/toxicity/hud/equation/TEquation;", "numberFormat", "Ljava/text/DecimalFormat;", "getNumberFormat", "()Ljava/text/DecimalFormat;", "disableNumberFormat", "", "getDisableNumberFormat", "()Z", "useLegacyFormat", "getUseLegacyFormat", "legacySerializer", "Lkr/toxicity/hud/util/ComponentDeserializer;", "getLegacySerializer", "()Lkr/toxicity/hud/util/ComponentDeserializer;", "line", "getLine", "splitWidth", "getSplitWidth", "lineWidth", "getLineWidth", "forceSplit", "getForceSplit", "background", "Lkr/toxicity/hud/layout/TextLayout$BackgroundInfo;", "getBackground", "()Lkr/toxicity/hud/layout/TextLayout$BackgroundInfo;", "emoji", "Lkr/toxicity/hud/layout/TextLayout$EmojiInfo;", "getEmoji", "()Lkr/toxicity/hud/layout/TextLayout$EmojiInfo;", "identifier", "Lkr/toxicity/hud/layout/HudLayout$Identifier;", "shader", "Lkr/toxicity/hud/shader/HudShader;", "ascent", "startJson", "Lcom/google/gson/JsonArray;", "imageCharMap", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lkr/toxicity/hud/text/ImageTextScale;", "Lkr/toxicity/hud/util/IntKeyMap;", "getImageCharMap", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Companion", "BackgroundInfo", "EmojiInfo", "TextIdentifier", "Impl", "dist"})
public interface TextLayout
extends HudLayout<TextElement> {
    @NotNull
    public static final Companion Companion = kr.toxicity.hud.layout.TextLayout$Companion.$$INSTANCE;

    @NotNull
    public String getPattern();

    public double getScale();

    public int getSpace();

    @NotNull
    public LayoutAlign getAlign();

    @NotNull
    public LayoutAlign getLineAlign();

    @NotNull
    public TextColor getColor();

    @NotNull
    public TEquation getNumberEquation();

    @NotNull
    public DecimalFormat getNumberFormat();

    public boolean getDisableNumberFormat();

    public boolean getUseLegacyFormat();

    @NotNull
    public ComponentDeserializer getLegacySerializer();

    public int getLine();

    public int getSplitWidth();

    public int getLineWidth();

    public boolean getForceSplit();

    @NotNull
    public BackgroundInfo getBackground();

    @NotNull
    public EmojiInfo getEmoji();

    @NotNull
    default public HudLayout.Identifier identifier(@NotNull HudShader shader, int ascent) {
        Intrinsics.checkNotNullParameter(shader, "shader");
        return new TextIdentifier(new ShaderGroup(shader, ((TextElement)this.getSource()).getId(), ascent), this);
    }

    @NotNull
    default public JsonArray startJson() {
        Object[] objectArray = new Object[1];
        Pair[] pairArray = new Pair[]{TuplesKt.to("type", "space"), TuplesKt.to("advances", GsonsKt.buildJsonObject(arg_0 -> TextLayout.startJson$lambda$0(this, arg_0)))};
        objectArray[0] = GsonsKt.jsonObjectOf(pairArray);
        return GsonsKt.jsonArrayOf(objectArray);
    }

    @NotNull
    public Int2ObjectMap<ImageTextScale> getImageCharMap();

    private static Unit startJson$lambda$0(TextLayout this$0, JsonObject $this$buildJsonObject) {
        Intrinsics.checkNotNullParameter($this$buildJsonObject, "$this$buildJsonObject");
        $this$buildJsonObject.addProperty(" ", (Number)4);
        if (this$0.getSpace() != 0) {
            $this$buildJsonObject.addProperty(AdventuresKt.parseChar(786432), (Number)this$0.getSpace());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lkr/toxicity/hud/layout/TextLayout$BackgroundInfo;", "", "source", "Lkr/toxicity/hud/background/HudBackground;", "scale", "", "<init>", "(Lkr/toxicity/hud/background/HudBackground;D)V", "getSource", "()Lkr/toxicity/hud/background/HudBackground;", "getScale", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dist"})
    public static final class BackgroundInfo {
        @Nullable
        private final HudBackground source;
        private final double scale;

        public BackgroundInfo(@Nullable HudBackground source, double scale) {
            this.source = source;
            this.scale = scale;
        }

        @Nullable
        public final HudBackground getSource() {
            return this.source;
        }

        public final double getScale() {
            return this.scale;
        }

        @Nullable
        public final HudBackground component1() {
            return this.source;
        }

        public final double component2() {
            return this.scale;
        }

        @NotNull
        public final BackgroundInfo copy(@Nullable HudBackground source, double scale) {
            return new BackgroundInfo(source, scale);
        }

        public static /* synthetic */ BackgroundInfo copy$default(BackgroundInfo backgroundInfo, HudBackground hudBackground, double d, int n, Object object) {
            if ((n & 1) != 0) {
                hudBackground = backgroundInfo.source;
            }
            if ((n & 2) != 0) {
                d = backgroundInfo.scale;
            }
            return backgroundInfo.copy(hudBackground, d);
        }

        @NotNull
        public String toString() {
            return "BackgroundInfo(source=" + this.source + ", scale=" + this.scale + ")";
        }

        public int hashCode() {
            int result = this.source == null ? 0 : this.source.hashCode();
            result = result * 31 + Double.hashCode(this.scale);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BackgroundInfo)) {
                return false;
            }
            BackgroundInfo backgroundInfo = (BackgroundInfo)other;
            if (!Intrinsics.areEqual(this.source, backgroundInfo.source)) {
                return false;
            }
            return Double.compare(this.scale, backgroundInfo.scale) == 0;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lkr/toxicity/hud/layout/TextLayout$Companion;", "", "<init>", "()V", "emojiProviderMap", "", "Lkr/toxicity/hud/layout/TextLayout$Companion$EmojiProvider;", "EmojiProvider", "dist"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final List<EmojiProvider> emojiProviderMap;

        private Companion() {
        }

        private static final Int2ObjectMap emojiProviderMap$lambda$0(TextLayout layout, Function0 getter) {
            Intrinsics.checkNotNullParameter(layout, "layout");
            Intrinsics.checkNotNullParameter(getter, "getter");
            return ConfigManagerImpl.INSTANCE.getLoadMinecraftDefaultTextures() ? MinecraftManager.INSTANCE.applyAll(layout, getter) : (Int2ObjectMap<ImageTextScale>)MapsKt.toIntKeyMap(kr.toxicity.hud.shaded.kotlin.collections.MapsKt.emptyMap());
        }

        static {
            $$INSTANCE = new Companion();
            emojiProviderMap = CollectionsKt.listOf(Companion::emojiProviderMap$lambda$0);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e2\u0080\u0001\u0018\u00002*\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00070\u0001\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lkr/toxicity/hud/layout/TextLayout$Companion$EmojiProvider;", "Lkr/toxicity/hud/shaded/kotlin/Function2;", "Lkr/toxicity/hud/layout/TextLayout;", "Lkr/toxicity/hud/shaded/kotlin/Function0;", "", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lkr/toxicity/hud/text/ImageTextScale;", "Lkr/toxicity/hud/util/IntKeyMap;", "dist"})
        private static interface EmojiProvider
        extends Function2<TextLayout, Function0<? extends Integer>, Int2ObjectMap<ImageTextScale>> {
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static HudLayout.Identifier identifier(@NotNull TextLayout $this, @NotNull HudShader shader, int ascent) {
            Intrinsics.checkNotNullParameter(shader, "shader");
            return $this.identifier(shader, ascent);
        }

        @Deprecated
        @NotNull
        public static JsonArray startJson(@NotNull TextLayout $this) {
            return $this.startJson();
        }

        @Deprecated
        @NotNull
        public static ConditionSource.Impl plus(@NotNull TextLayout $this, @NotNull ConditionSource other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return $this.plus(other);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lkr/toxicity/hud/layout/TextLayout$EmojiInfo;", "", "location", "Lkr/toxicity/hud/location/PixelLocation;", "scale", "", "<init>", "(Lkr/toxicity/hud/location/PixelLocation;D)V", "getLocation", "()Lkr/toxicity/hud/location/PixelLocation;", "getScale", "()D", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dist"})
    public static final class EmojiInfo {
        @NotNull
        private final PixelLocation location;
        private final double scale;

        public EmojiInfo(@NotNull PixelLocation location, double scale) {
            Intrinsics.checkNotNullParameter(location, "location");
            this.location = location;
            this.scale = scale;
        }

        @NotNull
        public final PixelLocation getLocation() {
            return this.location;
        }

        public final double getScale() {
            return this.scale;
        }

        @NotNull
        public final PixelLocation component1() {
            return this.location;
        }

        public final double component2() {
            return this.scale;
        }

        @NotNull
        public final EmojiInfo copy(@NotNull PixelLocation location, double scale) {
            Intrinsics.checkNotNullParameter(location, "location");
            return new EmojiInfo(location, scale);
        }

        public static /* synthetic */ EmojiInfo copy$default(EmojiInfo emojiInfo, PixelLocation pixelLocation, double d, int n, Object object) {
            if ((n & 1) != 0) {
                pixelLocation = emojiInfo.location;
            }
            if ((n & 2) != 0) {
                d = emojiInfo.scale;
            }
            return emojiInfo.copy(pixelLocation, d);
        }

        @NotNull
        public String toString() {
            return "EmojiInfo(location=" + this.location + ", scale=" + this.scale + ")";
        }

        public int hashCode() {
            int result = this.location.hashCode();
            result = result * 31 + Double.hashCode(this.scale);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EmojiInfo)) {
                return false;
            }
            EmojiInfo emojiInfo = (EmojiInfo)other;
            if (!Intrinsics.areEqual(this.location, emojiInfo.location)) {
                return false;
            }
            return Double.compare(this.scale, emojiInfo.scale) == 0;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000fJ\u0011\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020RH\u0096\u0003R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u000200X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u000204X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u000208X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0014\u0010;\u001a\u000200X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00102R\u0014\u0010=\u001a\u00020>X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0014\u0010A\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u001cR\u0014\u0010C\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u001cR\u0014\u0010E\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u001cR\u0014\u0010G\u001a\u000200X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u00102R$\u0010I\u001a\u0012\u0012\u0004\u0012\u00020K0Jj\b\u0012\u0004\u0012\u00020K`LX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u0012\u0010S\u001a\u000200X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bT\u00102R\u0012\u0010U\u001a\u00020VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bW\u0010XR\u0012\u0010Y\u001a\u00020ZX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u0014\u0010]\u001a\u0004\u0018\u00010\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b^\u0010\u0014R\u0012\u0010_\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b`\u0010\u001cR\u0012\u0010a\u001a\u00020\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bb\u0010cR\u0012\u0010d\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\be\u0010\u001cR\u0012\u0010f\u001a\u00020\nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bg\u0010hR\u0012\u0010i\u001a\u00020\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bj\u0010\u001cR\u0012\u0010k\u001a\u00020lX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bm\u0010nR\u0012\u0010o\u001a\u00020\nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bp\u0010hR\u0012\u0010q\u001a\u00020rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bs\u0010t\u00a8\u0006u"}, d2={"Lkr/toxicity/hud/layout/TextLayout$Impl;", "Lkr/toxicity/hud/layout/TextLayout;", "Lkr/toxicity/hud/layout/HudLayout;", "Lkr/toxicity/hud/element/TextElement;", "s", "", "source", "group", "Lkr/toxicity/hud/layout/LayoutGroup;", "yamlObject", "Lkr/toxicity/hud/api/yaml/YamlObject;", "loc", "Lkr/toxicity/hud/location/PixelLocation;", "<init>", "(Ljava/lang/String;Lkr/toxicity/hud/element/TextElement;Lkr/toxicity/hud/layout/LayoutGroup;Lkr/toxicity/hud/api/yaml/YamlObject;Lkr/toxicity/hud/location/PixelLocation;)V", "(Ljava/lang/String;Lkr/toxicity/hud/layout/LayoutGroup;Lkr/toxicity/hud/api/yaml/YamlObject;Lkr/toxicity/hud/location/PixelLocation;)V", "getSource", "()Lkr/toxicity/hud/element/TextElement;", "pattern", "getPattern", "()Ljava/lang/String;", "scale", "", "getScale", "()D", "space", "", "getSpace", "()I", "align", "Lkr/toxicity/hud/layout/enums/LayoutAlign;", "getAlign", "()Lkr/toxicity/hud/layout/enums/LayoutAlign;", "lineAlign", "getLineAlign", "color", "Lnet/kyori/adventure/text/format/TextColor;", "getColor", "()Lnet/kyori/adventure/text/format/TextColor;", "numberEquation", "Lkr/toxicity/hud/equation/TEquation;", "getNumberEquation", "()Lkr/toxicity/hud/equation/TEquation;", "numberFormat", "Ljava/text/DecimalFormat;", "getNumberFormat", "()Ljava/text/DecimalFormat;", "disableNumberFormat", "", "getDisableNumberFormat", "()Z", "background", "Lkr/toxicity/hud/layout/TextLayout$BackgroundInfo;", "getBackground", "()Lkr/toxicity/hud/layout/TextLayout$BackgroundInfo;", "emoji", "Lkr/toxicity/hud/layout/TextLayout$EmojiInfo;", "getEmoji", "()Lkr/toxicity/hud/layout/TextLayout$EmojiInfo;", "useLegacyFormat", "getUseLegacyFormat", "legacySerializer", "Lkr/toxicity/hud/util/ComponentDeserializer;", "getLegacySerializer", "()Lkr/toxicity/hud/util/ComponentDeserializer;", "line", "getLine", "splitWidth", "getSplitWidth", "lineWidth", "getLineWidth", "forceSplit", "getForceSplit", "imageCharMap", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lkr/toxicity/hud/text/ImageTextScale;", "Lkr/toxicity/hud/util/IntKeyMap;", "getImageCharMap", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "plus", "Lkr/toxicity/hud/placeholder/ConditionSource$Impl;", "other", "Lkr/toxicity/hud/placeholder/ConditionSource;", "cancelIfFollowerNotExists", "getCancelIfFollowerNotExists", "colorOverrides", "Lkr/toxicity/hud/placeholder/ColorOverride$Builder;", "getColorOverrides", "()Lkr/toxicity/hud/placeholder/ColorOverride$Builder;", "conditions", "Lkr/toxicity/hud/placeholder/ConditionBuilder;", "getConditions", "()Lkr/toxicity/hud/placeholder/ConditionBuilder;", "follow", "getFollow", "layer", "getLayer", "location", "getLocation", "()Lkr/toxicity/hud/location/PixelLocation;", "outline", "getOutline", "placeholderOption", "getPlaceholderOption", "()Lkr/toxicity/hud/api/yaml/YamlObject;", "property", "getProperty", "renderScale", "Lkr/toxicity/hud/shader/RenderScale;", "getRenderScale", "()Lkr/toxicity/hud/shader/RenderScale;", "stringPlaceholderFormat", "getStringPlaceholderFormat", "tick", "", "getTick", "()J", "dist"})
    @SourceDebugExtension(value={"SMAP\nTextLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextLayout.kt\nkr/toxicity/hud/layout/TextLayout$Impl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1915#2,2:184\n*S KotlinDebug\n*F\n+ 1 TextLayout.kt\nkr/toxicity/hud/layout/TextLayout$Impl\n*L\n177#1:184,2\n*E\n"})
    public static final class Impl
    implements TextLayout,
    HudLayout<TextElement> {
        private final /* synthetic */ HudLayout.Impl<TextElement> $$delegate_0;
        @NotNull
        private final TextElement source;
        @NotNull
        private final String pattern;
        private final double scale;
        private final int space;
        @NotNull
        private final LayoutAlign align;
        @NotNull
        private final LayoutAlign lineAlign;
        @NotNull
        private final TextColor color;
        @NotNull
        private final TEquation numberEquation;
        @NotNull
        private final DecimalFormat numberFormat;
        private final boolean disableNumberFormat;
        @NotNull
        private final BackgroundInfo background;
        @NotNull
        private final EmojiInfo emoji;
        private final boolean useLegacyFormat;
        @NotNull
        private final ComponentDeserializer legacySerializer;
        private final int line;
        private final int splitWidth;
        private final int lineWidth;
        private final boolean forceSplit;
        @NotNull
        private final Int2ObjectMap<ImageTextScale> imageCharMap;

        /*
         * WARNING - void declaration
         */
        public Impl(@NotNull String s, @NotNull TextElement source, @NotNull LayoutGroup group, @NotNull YamlObject yamlObject, @NotNull PixelLocation loc) {
            void $this$imageCharMap_u24lambda_u240;
            int n;
            int $this$line_u24lambda_u240;
            int n2;
            void $this$emoji_u24lambda_u2412;
            double d;
            PixelLocation pixelLocation;
            HudBackground hudBackground;
            DecimalFormat decimalFormat;
            TEquation tEquation;
            Object it;
            Impl impl;
            Intrinsics.checkNotNullParameter(s, "s");
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(group, "group");
            Intrinsics.checkNotNullParameter(yamlObject, "yamlObject");
            Intrinsics.checkNotNullParameter(loc, "loc");
            this.$$delegate_0 = new HudLayout.Impl<HudElement>(source, group, loc, yamlObject);
            this.source = source;
            YamlElement yamlElement = yamlObject.get("pattern");
            this.pattern = FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, () -> Impl.pattern$lambda$0(s));
            this.scale = yamlObject.getAsDouble("scale", 1.0);
            this.space = yamlObject.getAsInt("space", 0);
            YamlElement yamlElement2 = yamlObject.get("align");
            this.align = FunctionsKt.toLayoutAlign(yamlElement2 != null ? yamlElement2.asString() : null);
            YamlElement yamlElement3 = yamlObject.get("line-align");
            this.lineAlign = FunctionsKt.toLayoutAlign(yamlElement3 != null ? yamlElement3.asString() : null);
            Object object = yamlObject.get("color");
            if (object == null || (object = object.asString()) == null || (object = AdventuresKt.toTextColor((String)object)) == null) {
                NamedTextColor namedTextColor = NamedTextColor.WHITE;
                Intrinsics.checkNotNullExpressionValue(namedTextColor, "WHITE");
                object = (TextColor)namedTextColor;
            }
            this.color = object;
            Impl impl2 = this;
            Object object2 = yamlObject.get("number-equation");
            if (object2 != null && (object2 = object2.asString()) != null) {
                Object object3 = object2;
                impl = impl2;
                boolean bl = false;
                tEquation = new TEquation((String)it);
                impl2 = impl;
            } else {
                tEquation = TEquation.Companion.getT();
            }
            impl2.numberEquation = tEquation;
            Impl impl3 = this;
            Object object4 = yamlObject.get("number-format");
            if (object4 != null && (object4 = object4.asString()) != null) {
                it = object4;
                impl = impl3;
                boolean bl = false;
                decimalFormat = new DecimalFormat((String)it);
                impl3 = impl;
            } else {
                decimalFormat = ConfigManagerImpl.INSTANCE.getNumberFormat();
            }
            impl3.numberFormat = decimalFormat;
            this.disableNumberFormat = yamlObject.getAsBoolean("disable-number-format", true);
            Impl impl4 = this;
            Object object5 = yamlObject.get("background");
            if (object5 != null && (object5 = object5.asString()) != null) {
                void it2;
                Object object6 = object5;
                impl = impl4;
                boolean bl = false;
                hudBackground = BackgroundManager.INSTANCE.getBackground((String)it2);
                impl4 = impl;
            } else {
                hudBackground = null;
            }
            double d2 = yamlObject.getAsDouble("background-scale", this.getScale());
            HudBackground hudBackground2 = hudBackground;
            impl4.background = new BackgroundInfo(hudBackground2, d2);
            Impl impl5 = this;
            YamlElement yamlElement4 = yamlObject.get("emoji-pixel");
            if (yamlElement4 != null && (yamlElement4 = yamlElement4.asObject()) != null) {
                void it3;
                YamlElement bl = yamlElement4;
                impl = impl5;
                boolean bl2 = false;
                pixelLocation = new PixelLocation((YamlObject)it3);
                impl5 = impl;
            } else {
                pixelLocation = PixelLocation.Companion.getZero();
            }
            double d3 = d = yamlObject.getAsDouble("emoji-scale", 1.0);
            PixelLocation pixelLocation2 = pixelLocation;
            impl = impl5;
            boolean bl = false;
            if ($this$emoji_u24lambda_u2412 <= 0.0) {
                throw new RuntimeException("emoji-scale cannot be <= 0");
            }
            Unit unit = Unit.INSTANCE;
            double d4 = d;
            PixelLocation pixelLocation3 = pixelLocation2;
            impl.emoji = new EmojiInfo(pixelLocation3, d4);
            this.useLegacyFormat = yamlObject.getAsBoolean("use-legacy-format", ConfigManagerImpl.INSTANCE.getUseLegacyFormat());
            Object object7 = yamlObject.get("legacy-serializer");
            if (object7 == null || (object7 = object7.asString()) == null || (object7 = AdventuresKt.toLegacySerializer((String)object7)) == null) {
                object7 = ConfigManagerImpl.INSTANCE.getLegacySerializer();
            }
            this.legacySerializer = object7;
            int $this$emoji_u24lambda_u2412 = n2 = yamlObject.getAsInt("line", 1);
            impl = this;
            boolean bl3 = false;
            if ($this$line_u24lambda_u240 < 1) {
                throw new RuntimeException("line cannot be < 1: " + s);
            }
            impl.line = n2;
            Impl impl6 = this;
            if (this.getLine() == 1) {
                n = Integer.MAX_VALUE;
            } else {
                void $this$splitWidth_u24lambda_u240;
                $this$line_u24lambda_u240 = n2 = yamlObject.getAsInt("split-width", 200);
                impl = impl6;
                boolean bl4 = false;
                if ($this$splitWidth_u24lambda_u240 < true) {
                    throw new RuntimeException("split-width cannot be < 1: " + s);
                }
                impl6 = impl;
                n = n2;
            }
            impl6.splitWidth = n;
            this.lineWidth = yamlObject.getAsInt("line-width", 10);
            this.forceSplit = yamlObject.getAsBoolean("force-split", false);
            Impl $this$splitWidth_u24lambda_u240 = this;
            impl = this;
            boolean bl5 = false;
            Int2ObjectOpenHashMap map = MapsKt.toIntKeyMap((Map)$this$imageCharMap_u24lambda_u240.getSource().getImageTextScale());
            Ref.IntRef baseValue = new Ref.IntRef();
            baseValue.element = 786432 + map.size();
            Function0<Integer> getter = () -> Impl.imageCharMap$lambda$0$0(baseValue);
            Iterable $this$forEach$iv = kr.toxicity.hud.layout.TextLayout$Companion.emojiProviderMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Companion.EmojiProvider it4 = (Companion.EmojiProvider)element$iv;
                boolean bl6 = false;
                ((Map)map).putAll((Map)it4.invoke($this$imageCharMap_u24lambda_u240, getter));
            }
            impl.imageCharMap = (Int2ObjectMap)map;
        }

        @Override
        @NotNull
        public TextElement getSource() {
            return this.source;
        }

        /*
         * WARNING - void declaration
         */
        public Impl(@NotNull String s, @NotNull LayoutGroup group, @NotNull YamlObject yamlObject, @NotNull PixelLocation loc) {
            void n;
            Intrinsics.checkNotNullParameter(s, "s");
            Intrinsics.checkNotNullParameter(group, "group");
            Intrinsics.checkNotNullParameter(yamlObject, "yamlObject");
            Intrinsics.checkNotNullParameter(loc, "loc");
            YamlElement yamlElement = yamlObject.get("name");
            String string = FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, () -> Impl._init_$lambda$0(s));
            String string2 = s;
            Impl impl = this;
            boolean bl = false;
            TextElement textElement = FunctionsKt.ifNull(TextManagerImpl.INSTANCE.getText((String)n), () -> Impl._init_$lambda$1$0((String)n));
            impl(string2, textElement, group, yamlObject, loc);
        }

        @Override
        @NotNull
        public String getPattern() {
            return this.pattern;
        }

        @Override
        public double getScale() {
            return this.scale;
        }

        @Override
        public int getSpace() {
            return this.space;
        }

        @Override
        @NotNull
        public LayoutAlign getAlign() {
            return this.align;
        }

        @Override
        @NotNull
        public LayoutAlign getLineAlign() {
            return this.lineAlign;
        }

        @Override
        @NotNull
        public TextColor getColor() {
            return this.color;
        }

        @Override
        @NotNull
        public TEquation getNumberEquation() {
            return this.numberEquation;
        }

        @Override
        @NotNull
        public DecimalFormat getNumberFormat() {
            return this.numberFormat;
        }

        @Override
        public boolean getDisableNumberFormat() {
            return this.disableNumberFormat;
        }

        @Override
        @NotNull
        public BackgroundInfo getBackground() {
            return this.background;
        }

        @Override
        @NotNull
        public EmojiInfo getEmoji() {
            return this.emoji;
        }

        @Override
        public boolean getUseLegacyFormat() {
            return this.useLegacyFormat;
        }

        @Override
        @NotNull
        public ComponentDeserializer getLegacySerializer() {
            return this.legacySerializer;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getSplitWidth() {
            return this.splitWidth;
        }

        @Override
        public int getLineWidth() {
            return this.lineWidth;
        }

        @Override
        public boolean getForceSplit() {
            return this.forceSplit;
        }

        @Override
        @NotNull
        public Int2ObjectMap<ImageTextScale> getImageCharMap() {
            return this.imageCharMap;
        }

        @Override
        public int getOutline() {
            return this.$$delegate_0.getOutline();
        }

        @Override
        public int getLayer() {
            return this.$$delegate_0.getLayer();
        }

        @Override
        public int getProperty() {
            return this.$$delegate_0.getProperty();
        }

        @Override
        @Nullable
        public String getFollow() {
            return this.$$delegate_0.getFollow();
        }

        @Override
        @NotNull
        public PixelLocation getLocation() {
            return this.$$delegate_0.getLocation();
        }

        @Override
        public boolean getCancelIfFollowerNotExists() {
            return this.$$delegate_0.getCancelIfFollowerNotExists();
        }

        @Override
        @NotNull
        public RenderScale getRenderScale() {
            return this.$$delegate_0.getRenderScale();
        }

        @Override
        public long getTick() {
            return this.$$delegate_0.getTick();
        }

        @Override
        @NotNull
        public ConditionBuilder getConditions() {
            return this.$$delegate_0.getConditions();
        }

        @Override
        @NotNull
        public ColorOverride.Builder getColorOverrides() {
            return this.$$delegate_0.getColorOverrides();
        }

        @Override
        @NotNull
        public ConditionSource.Impl plus(@NotNull ConditionSource other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return this.$$delegate_0.plus(other);
        }

        @Override
        @NotNull
        public YamlObject getPlaceholderOption() {
            return this.$$delegate_0.getPlaceholderOption();
        }

        @Override
        @NotNull
        public YamlObject getStringPlaceholderFormat() {
            return this.$$delegate_0.getStringPlaceholderFormat();
        }

        private static final String _init_$lambda$1$0(String $n) {
            return "this text doesn't exist: " + $n;
        }

        private static final String _init_$lambda$0(String $s) {
            return "name value not set: " + $s;
        }

        private static final String pattern$lambda$0(String $s) {
            return "pattern value not set: " + $s;
        }

        private static final int imageCharMap$lambda$0$0(Ref.IntRef $baseValue) {
            ++$baseValue.element;
            return $baseValue.element;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0082\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u001b\u001a\u00020\u001cX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lkr/toxicity/hud/layout/TextLayout$TextIdentifier;", "Lkr/toxicity/hud/layout/HudLayout$Identifier;", "delegate", "layout", "Lkr/toxicity/hud/layout/TextLayout;", "<init>", "(Lkr/toxicity/hud/layout/HudLayout$Identifier;Lkr/toxicity/hud/layout/TextLayout;)V", "getDelegate", "()Lkr/toxicity/hud/layout/HudLayout$Identifier;", "scale", "", "getScale", "()D", "background", "Lkr/toxicity/hud/layout/TextLayout$BackgroundInfo;", "getBackground", "()Lkr/toxicity/hud/layout/TextLayout$BackgroundInfo;", "emoji", "Lkr/toxicity/hud/layout/TextLayout$EmojiInfo;", "getEmoji", "()Lkr/toxicity/hud/layout/TextLayout$EmojiInfo;", "equals", "", "other", "", "hashCode", "", "name", "", "getName", "()Ljava/lang/String;", "dist"})
    public static final class TextIdentifier
    implements HudLayout.Identifier {
        @NotNull
        private final HudLayout.Identifier delegate;
        private final double scale;
        @NotNull
        private final BackgroundInfo background;
        @NotNull
        private final EmojiInfo emoji;

        public TextIdentifier(@NotNull HudLayout.Identifier delegate, @NotNull TextLayout layout) {
            Intrinsics.checkNotNullParameter(delegate, "delegate");
            Intrinsics.checkNotNullParameter(layout, "layout");
            this.delegate = delegate;
            this.scale = layout.getScale();
            this.background = layout.getBackground();
            this.emoji = layout.getEmoji();
        }

        @NotNull
        public final HudLayout.Identifier getDelegate() {
            return this.delegate;
        }

        public final double getScale() {
            return this.scale;
        }

        @NotNull
        public final BackgroundInfo getBackground() {
            return this.background;
        }

        @NotNull
        public final EmojiInfo getEmoji() {
            return this.emoji;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextIdentifier)) {
                return false;
            }
            if (!(this.scale == ((TextIdentifier)other).scale)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.delegate, ((TextIdentifier)other).delegate)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.background, ((TextIdentifier)other).background)) {
                return false;
            }
            return Intrinsics.areEqual(this.emoji, ((TextIdentifier)other).emoji);
        }

        public int hashCode() {
            int result = Double.hashCode(this.scale);
            result = 31 * result + this.delegate.hashCode();
            result = 31 * result + this.background.hashCode();
            result = 31 * result + this.emoji.hashCode();
            return result;
        }

        @Override
        @NotNull
        public String getName() {
            return this.delegate.getName();
        }
    }
}

