/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.hud.Hud;
import kr.toxicity.hud.api.manager.HudManager;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.hud.HudImpl;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.MapsKt;
import kr.toxicity.hud.util.YamlsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!H\u0016J\b\u0010\"\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkr/toxicity/hud/manager/HudManagerImpl;", "Lkr/toxicity/hud/manager/BetterHudManager;", "Lkr/toxicity/hud/api/manager/HudManager;", "<init>", "()V", "managerName", "", "getManagerName", "()Ljava/lang/String;", "supportExternalPacks", "", "getSupportExternalPacks", "()Z", "hudMap", "Ljava/util/HashMap;", "Lkr/toxicity/hud/hud/HudImpl;", "start", "", "getHud", "Lkr/toxicity/hud/api/hud/Hud;", "name", "preReload", "reload", "workingDirectory", "Ljava/io/File;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "postReload", "getAllNames", "", "getAllHuds", "", "end", "dist"})
@SourceDebugExtension(value={"SMAP\nHudManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HudManagerImpl.kt\nkr/toxicity/hud/manager/HudManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1915#2,2:56\n*S KotlinDebug\n*F\n+ 1 HudManagerImpl.kt\nkr/toxicity/hud/manager/HudManagerImpl\n*L\n42#1:56,2\n*E\n"})
public final class HudManagerImpl
implements BetterHudManager,
HudManager {
    @NotNull
    public static final HudManagerImpl INSTANCE = new HudManagerImpl();
    @NotNull
    private static final String managerName = "HUD";
    private static final boolean supportExternalPacks = true;
    @NotNull
    private static final HashMap<String, HudImpl> hudMap = new HashMap();

    private HudManagerImpl() {
    }

    @Override
    @NotNull
    public String getManagerName() {
        return managerName;
    }

    @Override
    public boolean getSupportExternalPacks() {
        return supportExternalPacks;
    }

    @Override
    public void start() {
    }

    @Override
    @Nullable
    public Hud getHud(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return hudMap.get(name);
    }

    @Override
    public void preReload() {
        hudMap.clear();
    }

    @Override
    public void reload(@NotNull File workingDirectory, @NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        File file = FilesKt.subFolder(workingDirectory, "huds");
        BetterCommandSource betterCommandSource = info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        YamlsKt.forEachAllYaml(file, betterCommandSource, (arg_0, arg_1, arg_2) -> HudManagerImpl.reload$lambda$0(info, resource, arg_0, arg_1, arg_2));
    }

    @Override
    public void postReload() {
        Collection<HudImpl> collection = hudMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HudImpl it = (HudImpl)element$iv;
            boolean bl = false;
            it.setJsonArray(null);
        }
    }

    @Override
    @NotNull
    public Set<String> getAllNames() {
        Set<String> set = Collections.unmodifiableSet(hudMap.keySet());
        Intrinsics.checkNotNullExpressionValue(set, "unmodifiableSet(...)");
        return set;
    }

    @Override
    @NotNull
    public Set<Hud> getAllHuds() {
        Collection<HudImpl> collection = hudMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.toSet((Iterable)collection);
    }

    @Override
    public void end() {
    }

    private static final HudImpl reload$lambda$0$0$0(String $s, GlobalResource $resource, YamlObject $yamlObject) {
        return new HudImpl($s, $resource, $yamlObject);
    }

    private static final String reload$lambda$0$1(String $s, File $file) {
        return "Unable to load this hud: " + $s + " in " + $file.getName();
    }

    private static final Unit reload$lambda$0(ReloadInfo $info, GlobalResource $resource, File file, String s, YamlObject yamlObject) {
        Object object;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(yamlObject, "yamlObject");
        HudManagerImpl hudManagerImpl = INSTANCE;
        try {
            HudManagerImpl $this$reload_u24lambda_u240_u240 = hudManagerImpl;
            boolean bl = false;
            MapsKt.putSync((Map)hudMap, "hud", () -> HudManagerImpl.reload$lambda$0$0$0(s, $resource, yamlObject));
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        FunctionsKt.handleFailure(object, $info, () -> HudManagerImpl.reload$lambda$0$1(s, file));
        return Unit.INSTANCE;
    }
}

