/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.player.HudPlayer;
import kr.toxicity.hud.api.player.HudPlayerHead;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.element.HeadElement;
import kr.toxicity.hud.layout.HudLayout;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.manager.EncodeManager;
import kr.toxicity.hud.manager.PlayerManagerImpl;
import kr.toxicity.hud.pack.PackGenerator;
import kr.toxicity.hud.player.head.GameProfileSkinProvider;
import kr.toxicity.hud.player.head.HudPlayerHeadImpl;
import kr.toxicity.hud.player.head.PlayerSkinProvider;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.collections.IntIterator;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.random.Random;
import kr.toxicity.hud.shaded.kotlin.ranges.IntRange;
import kr.toxicity.hud.shaded.kotlin.text.StringsKt;
import kr.toxicity.hud.shaded.net.jodah.expiringmap.ExpirationPolicy;
import kr.toxicity.hud.shaded.net.jodah.expiringmap.ExpiringMap;
import kr.toxicity.hud.util.EncodesKt;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.ImagesKt;
import kr.toxicity.hud.util.MapsKt;
import kr.toxicity.hud.util.PluginsKt;
import kr.toxicity.hud.util.YamlsKt;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020\u001dJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0005J\u000e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u000eJ\b\u0010(\u001a\u00020!H\u0016J\u000e\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005J\u000e\u0010+\u001a\u00020,2\u0006\u0010*\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010-\u001a\u00020\u0005J\b\u0010.\u001a\u00020!H\u0016J \u0010/\u001a\u00020!2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020!H\u0016J\b\u00107\u001a\u00020!H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0011\u001aB\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014 \u0013* \u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0016\u001aB\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014 \u0013* \u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00050\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lkr/toxicity/hud/manager/PlayerHeadManager;", "Lkr/toxicity/hud/manager/BetterHudManager;", "<init>", "()V", "managerName", "", "getManagerName", "()Ljava/lang/String;", "supportExternalPacks", "", "getSupportExternalPacks", "()Z", "skinProviders", "Ljava/util/ArrayList;", "Lkr/toxicity/hud/player/head/PlayerSkinProvider;", "defaultProviders", "Lkr/toxicity/hud/player/head/GameProfileSkinProvider;", "headLock", "", "kr.toxicity.hud.shaded.kotlin.jvm.PlatformType", "Lkr/toxicity/hud/player/head/HudPlayerHeadImpl;", "", "headCache", "Lkr/toxicity/hud/shaded/net/jodah/expiringmap/ExpiringMap;", "headMap", "Ljava/util/HashMap;", "Lkr/toxicity/hud/element/HeadElement;", "headNameComponent", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkr/toxicity/hud/layout/HudLayout$Identifier;", "getHead", "group", "setHead", "", "string", "loadingHeadMap", "loadingHead", "Lkr/toxicity/hud/shaded/kotlin/Function0;", "addSkinProvider", "provider", "start", "provideSkin", "playerName", "provideHead", "Lkr/toxicity/hud/api/player/HudPlayerHead;", "name", "preReload", "reload", "workingDirectory", "Ljava/io/File;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "postReload", "end", "dist"})
@SourceDebugExtension(value={"SMAP\nPlayerHeadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerHeadManager.kt\nkr/toxicity/hud/manager/PlayerHeadManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1586#2:142\n1661#2,3:143\n*S KotlinDebug\n*F\n+ 1 PlayerHeadManager.kt\nkr/toxicity/hud/manager/PlayerHeadManager\n*L\n58#1:142\n58#1:143,3\n*E\n"})
public final class PlayerHeadManager
implements BetterHudManager {
    @NotNull
    public static final PlayerHeadManager INSTANCE = new PlayerHeadManager();
    @NotNull
    private static final String managerName = "Player head";
    private static final boolean supportExternalPacks = true;
    @NotNull
    private static final ArrayList<PlayerSkinProvider> skinProviders = new ArrayList();
    @NotNull
    private static final GameProfileSkinProvider defaultProviders = new GameProfileSkinProvider();
    private static final Map<String, HudPlayerHeadImpl> headLock = Collections.synchronizedMap(new WeakHashMap());
    private static final ExpiringMap<String, HudPlayerHeadImpl> headCache = ExpiringMap.builder().expiration(60L, TimeUnit.SECONDS).expirationPolicy(ExpirationPolicy.ACCESSED).build();
    @NotNull
    private static final HashMap<String, HeadElement> headMap = new HashMap();
    @NotNull
    private static final ConcurrentHashMap<HudLayout.Identifier, String> headNameComponent = new ConcurrentHashMap();
    @NotNull
    private static final HashMap<String, HudPlayerHeadImpl> loadingHeadMap = new HashMap();
    @NotNull
    private static Function0<HudPlayerHeadImpl> loadingHead = PlayerHeadManager::loadingHead$lambda$0;

    private PlayerHeadManager() {
    }

    @Override
    @NotNull
    public String getManagerName() {
        return managerName;
    }

    @Override
    public boolean getSupportExternalPacks() {
        return supportExternalPacks;
    }

    @Nullable
    public final String getHead(@NotNull HudLayout.Identifier group) {
        Intrinsics.checkNotNullParameter(group, "group");
        return headNameComponent.get(group);
    }

    public final void setHead(@NotNull HudLayout.Identifier group, @NotNull String string) {
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(string, "string");
        ((Map)headNameComponent).put(group, string);
    }

    public final void addSkinProvider(@NotNull PlayerSkinProvider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        ((Collection)skinProviders).add(provider);
    }

    @Override
    public void start() {
        PluginsKt.getPLUGIN().loadAssets("skin", PlayerHeadManager::start$lambda$0);
    }

    @NotNull
    public final String provideSkin(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        Iterator<PlayerSkinProvider> iterator2 = skinProviders.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<PlayerSkinProvider> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object object;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            PlayerHeadManager playerHeadManager = this;
            try {
                Object value;
                Object object2;
                block8: {
                    PlayerSkinProvider skinProvider;
                    block7: {
                        PlayerHeadManager $this$provideSkin_u24lambda_u240 = playerHeadManager;
                        boolean bl = false;
                        object2 = PlayerManagerImpl.INSTANCE.getHudPlayer(playerName);
                        if (object2 == null) break block7;
                        HudPlayer it = object2;
                        boolean bl2 = false;
                        String string = skinProvider.provide(it);
                        object2 = string;
                        if (string != null) break block8;
                    }
                    object2 = skinProvider.provide(playerName);
                }
                Object object3 = value = object2;
                if (object3 != null) {
                    return object3;
                }
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
        }
        return defaultProviders.provide(playerName);
    }

    @NotNull
    public final HudPlayerHead provideHead(@NotNull String playerName) {
        HudPlayerHead hudPlayerHead;
        Intrinsics.checkNotNullParameter(playerName, "playerName");
        HudPlayerHeadImpl hudPlayerHeadImpl = (HudPlayerHeadImpl)headCache.get((Object)playerName);
        if (hudPlayerHeadImpl != null) {
            hudPlayerHead = hudPlayerHeadImpl;
        } else {
            PlayerHeadManager $this$provideHead_u24lambda_u240 = this;
            boolean bl = false;
            HudPlayerHeadImpl hudPlayerHeadImpl2 = headLock.computeIfAbsent(playerName, arg_0 -> PlayerHeadManager.provideHead$lambda$0$1(arg_0 -> PlayerHeadManager.provideHead$lambda$0$0(playerName, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue(hudPlayerHeadImpl2, "run(...)");
            hudPlayerHead = hudPlayerHeadImpl2;
        }
        return hudPlayerHead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final HeadElement getHead(@NotNull String name) {
        HeadElement headElement;
        Intrinsics.checkNotNullParameter(name, "name");
        HashMap<String, HeadElement> hashMap = headMap;
        synchronized (hashMap) {
            boolean bl = false;
            headElement = headMap.get(name);
        }
        return headElement;
    }

    @Override
    public void preReload() {
        headMap.clear();
        headNameComponent.clear();
        headLock.clear();
        headCache.clear();
    }

    @Override
    public void reload(@NotNull File workingDirectory, @NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        String name = ConfigManagerImpl.INSTANCE.getLoadingHead();
        loadingHead = Intrinsics.areEqual(name, "random") ? PlayerHeadManager::reload$lambda$0 : () -> PlayerHeadManager.reload$lambda$1(name);
        File file = FilesKt.subFolder(workingDirectory, "heads");
        BetterCommandSource betterCommandSource = info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        YamlsKt.forEachAllYaml(file, betterCommandSource, (arg_0, arg_1, arg_2) -> PlayerHeadManager.reload$lambda$2(info, resource, arg_0, arg_1, arg_2));
    }

    @Override
    public void postReload() {
        headNameComponent.clear();
    }

    @Override
    public void end() {
    }

    private static final HudPlayerHeadImpl loadingHead$lambda$0() {
        return HudPlayerHeadImpl.Companion.getAllBlack();
    }

    /*
     * WARNING - void declaration
     */
    private static final void start$lambda$0(String s, InputStream stream) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull(stream);
        BufferedImage image = ImagesKt.toImage(stream);
        Map map = loadingHeadMap;
        Intrinsics.checkNotNull(s);
        String string = StringsKt.substringBeforeLast$default(s, '.', null, 2, null);
        Iterable $this$map$iv = new IntRange(0, 63);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TextColor textColor = TextColor.color((int)image.getRGB((int)(i % 8), (int)(i / 8)));
            Intrinsics.checkNotNullExpressionValue(textColor, "color(...)");
            collection.add(textColor);
        }
        Map map2 = kr.toxicity.hud.shaded.kotlin.collections.MapsKt.emptyMap();
        List list = (List)destination$iv$iv;
        HudPlayerHeadImpl hudPlayerHeadImpl = new HudPlayerHeadImpl(list, map2);
        map.put(string, hudPlayerHeadImpl);
    }

    private static final void provideHead$lambda$0$0$0(String $playerName) {
        HudPlayerHeadImpl head = HudPlayerHeadImpl.Companion.of($playerName);
        ExpiringMap<String, HudPlayerHeadImpl> expiringMap = headCache;
        Intrinsics.checkNotNullExpressionValue(expiringMap, "headCache");
        ((Map)expiringMap).put($playerName, head);
        headLock.remove($playerName);
    }

    private static final HudPlayerHeadImpl provideHead$lambda$0$0(String $playerName, String it) {
        CompletableFuture.runAsync(() -> PlayerHeadManager.provideHead$lambda$0$0$0($playerName));
        return loadingHead.invoke();
    }

    private static final HudPlayerHeadImpl provideHead$lambda$0$1(Function1 $tmp0, Object p0) {
        return (HudPlayerHeadImpl)$tmp0.invoke(p0);
    }

    private static final byte[] reload$lambda$2$0$0$0(int $pixel) {
        BufferedImage bufferedImage;
        BufferedImage $this$reload_u24lambda_u242_u240_u240_u240_u240 = bufferedImage = new BufferedImage($pixel, $pixel, 2);
        boolean bl = false;
        Graphics2D $this$reload_u24lambda_u242_u240_u240_u240_u240_u240 = $this$reload_u24lambda_u242_u240_u240_u240_u240.createGraphics();
        boolean bl2 = false;
        $this$reload_u24lambda_u242_u240_u240_u240_u240_u240.setColor(Color.WHITE);
        $this$reload_u24lambda_u242_u240_u240_u240_u240_u240.fillRect(0, 0, $pixel, $pixel);
        $this$reload_u24lambda_u242_u240_u240_u240_u240_u240.dispose();
        return ImagesKt.toByteArray(bufferedImage);
    }

    private static final HeadElement reload$lambda$2$0$0(String $s, YamlObject $yamlObject, GlobalResource $resource) {
        HeadElement head = new HeadElement($s, $yamlObject);
        int pixel = head.getPixel();
        PackGenerator.INSTANCE.addTask((Iterable<String>)CollectionsKt.plus((Collection)$resource.getTextures(), EncodesKt.encodeKey("pixel_" + pixel, EncodeManager.EncodeNamespace.TEXTURES) + ".png"), () -> PlayerHeadManager.reload$lambda$2$0$0$0(pixel));
        return head;
    }

    private static final String reload$lambda$2$1(String $s, File $file) {
        return "Unable to load this head: " + $s + " in " + $file.getName();
    }

    private static final HudPlayerHeadImpl reload$lambda$0() {
        HudPlayerHeadImpl hudPlayerHeadImpl;
        if (!((Map)loadingHeadMap).isEmpty()) {
            Collection<HudPlayerHeadImpl> collection = loadingHeadMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            hudPlayerHeadImpl = CollectionsKt.random(collection, Random.Default);
        } else {
            hudPlayerHeadImpl = HudPlayerHeadImpl.Companion.getAllBlack();
        }
        return hudPlayerHeadImpl;
    }

    private static final HudPlayerHeadImpl reload$lambda$1(String $name) {
        HudPlayerHeadImpl hudPlayerHeadImpl = loadingHeadMap.get($name);
        if (hudPlayerHeadImpl == null) {
            hudPlayerHeadImpl = HudPlayerHeadImpl.Companion.getAllBlack();
        }
        return hudPlayerHeadImpl;
    }

    private static final Unit reload$lambda$2(ReloadInfo $info, GlobalResource $resource, File file, String s, YamlObject yamlObject) {
        Object object;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(yamlObject, "yamlObject");
        PlayerHeadManager playerHeadManager = INSTANCE;
        try {
            PlayerHeadManager $this$reload_u24lambda_u242_u240 = playerHeadManager;
            boolean bl = false;
            MapsKt.putSync((Map)headMap, "head", () -> PlayerHeadManager.reload$lambda$2$0$0(s, yamlObject, $resource));
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        FunctionsKt.handleFailure(object, $info, () -> PlayerHeadManager.reload$lambda$2$1(s, file));
        return Unit.INSTANCE;
    }
}

