/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kr.toxicity.hud.api.manager.PlayerManager;
import kr.toxicity.hud.api.player.HudPlayer;
import kr.toxicity.hud.api.player.PointedLocation;
import kr.toxicity.hud.api.player.PointedLocationProvider;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.popup.PopupIteratorGroup;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.player.HudPlayerImpl;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0010J\u001c\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u000fJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\u0010\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010!\u001a\u00020\u0006J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0014H\u0016J\b\u0010$\u001a\u00020\u0016H\u0016J \u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0016H\u0016J\b\u0010-\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lkr/toxicity/hud/manager/PlayerManagerImpl;", "Lkr/toxicity/hud/manager/BetterHudManager;", "Lkr/toxicity/hud/api/manager/PlayerManager;", "<init>", "()V", "managerName", "", "getManagerName", "()Ljava/lang/String;", "supportExternalPacks", "", "getSupportExternalPacks", "()Z", "playerMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lkr/toxicity/hud/api/player/HudPlayer;", "stringPlayer", "locationProviders", "", "Lkr/toxicity/hud/api/player/PointedLocationProvider;", "start", "", "provideLocation", "player", "addHudPlayer", "uuid", "Lkr/toxicity/hud/shaded/kotlin/Function0;", "Lkr/toxicity/hud/player/HudPlayerImpl;", "removeHudPlayer", "getAllHudPlayer", "", "getHudPlayer", "name", "addLocationProvider", "provider", "preReload", "reload", "workingDirectory", "Ljava/io/File;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "postReload", "end", "dist"})
@SourceDebugExtension(value={"SMAP\nPlayerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerManagerImpl.kt\nkr/toxicity/hud/manager/PlayerManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,84:1\n1915#2,2:85\n1915#2:87\n1916#2:90\n1915#2,2:91\n1915#2,2:93\n221#3,2:88\n*S KotlinDebug\n*F\n+ 1 PlayerManagerImpl.kt\nkr/toxicity/hud/manager/PlayerManagerImpl\n*L\n32#1:85,2\n61#1:87\n61#1:90\n74#1:91,2\n80#1:93,2\n62#1:88,2\n*E\n"})
public final class PlayerManagerImpl
implements BetterHudManager,
PlayerManager {
    @NotNull
    public static final PlayerManagerImpl INSTANCE = new PlayerManagerImpl();
    @NotNull
    private static final String managerName = "Player";
    private static final boolean supportExternalPacks;
    @NotNull
    private static final ConcurrentHashMap<UUID, HudPlayer> playerMap;
    @NotNull
    private static final ConcurrentHashMap<String, HudPlayer> stringPlayer;
    @NotNull
    private static final List<PointedLocationProvider> locationProviders;

    private PlayerManagerImpl() {
    }

    @Override
    @NotNull
    public String getManagerName() {
        return managerName;
    }

    @Override
    public boolean getSupportExternalPacks() {
        return supportExternalPacks;
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void provideLocation(@NotNull HudPlayer player) {
        Set<PointedLocation> set;
        Intrinsics.checkNotNullParameter(player, "player");
        Set<PointedLocation> set2 = player.getPointedLocation();
        Intrinsics.checkNotNullExpressionValue(set2, "getPointedLocation(...)");
        Set<PointedLocation> set3 = set = set2;
        synchronized (set3) {
            boolean bl = false;
            set.clear();
            Iterable $this$forEach$iv = locationProviders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection<PointedLocation> provided;
                PointedLocationProvider it = (PointedLocationProvider)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue(it.provide(player), "provide(...)");
                if (!(!provided.isEmpty())) continue;
                CollectionsKt.addAll((Collection)set, (Iterable)provided);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final HudPlayer addHudPlayer(@NotNull UUID uuid, @NotNull Function0<? extends HudPlayerImpl> player) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(player, "player");
        HudPlayer hudPlayer = playerMap.computeIfAbsent(uuid, arg_0 -> PlayerManagerImpl.addHudPlayer$lambda$1(arg_0 -> PlayerManagerImpl.addHudPlayer$lambda$0(player, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(hudPlayer, "computeIfAbsent(...)");
        return hudPlayer;
    }

    @Nullable
    public final HudPlayer removeHudPlayer(@NotNull UUID uuid) {
        HudPlayer hudPlayer;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        HudPlayer hudPlayer2 = playerMap.remove(uuid);
        if (hudPlayer2 != null) {
            HudPlayer hudPlayer3;
            HudPlayer $this$removeHudPlayer_u24lambda_u240 = hudPlayer3 = hudPlayer2;
            boolean bl = false;
            stringPlayer.remove($this$removeHudPlayer_u24lambda_u240.name());
            hudPlayer = hudPlayer3;
        } else {
            hudPlayer = null;
        }
        return hudPlayer;
    }

    @Override
    @NotNull
    public Collection<HudPlayer> getAllHudPlayer() {
        Collection<HudPlayer> collection = Collections.unmodifiableCollection(playerMap.values());
        Intrinsics.checkNotNullExpressionValue(collection, "unmodifiableCollection(...)");
        return collection;
    }

    @Override
    @Nullable
    public HudPlayer getHudPlayer(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return playerMap.get(uuid);
    }

    @Nullable
    public final HudPlayer getHudPlayer(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return stringPlayer.get(name);
    }

    @Override
    public void addLocationProvider(@NotNull PointedLocationProvider provider) {
        Intrinsics.checkNotNullParameter(provider, "provider");
        ((Collection)locationProviders).add(provider);
    }

    @Override
    public void preReload() {
        Collection<HudPlayer> collection = playerMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map<String, PopupIteratorGroup> $this$forEach$iv2;
            HudPlayer it = (HudPlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it.getPopupGroupIteratorMap(), "getPopupGroupIteratorMap(...)");
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, PopupIteratorGroup>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, PopupIteratorGroup> element$iv2;
                Map.Entry<String, PopupIteratorGroup> value = element$iv2 = iterator2.next();
                boolean bl2 = false;
                value.getValue().clear();
            }
            it.getPopupGroupIteratorMap().clear();
            it.getPopupKeyMap().clear();
        }
    }

    @Override
    public void reload(@NotNull File workingDirectory, @NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
    }

    @Override
    public void postReload() {
        Collection<HudPlayer> collection = playerMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HudPlayer p0 = (HudPlayer)element$iv;
            boolean bl = false;
            p0.reload();
        }
    }

    @Override
    public void end() {
        ArrayList<HudPlayer> list = new ArrayList<HudPlayer>(playerMap.values());
        playerMap.clear();
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HudPlayer it = (HudPlayer)element$iv;
            boolean bl = false;
            it.save();
        }
    }

    private static final Collection locationProviders$lambda$0(HudPlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return player.pointers();
    }

    private static final HudPlayer addHudPlayer$lambda$0(Function0 $player, UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Object r = $player.invoke();
        HudPlayerImpl $this$addHudPlayer_u24lambda_u240_u240 = (HudPlayerImpl)r;
        boolean bl = false;
        ((Map)stringPlayer).put($this$addHudPlayer_u24lambda_u240_u240.name(), $this$addHudPlayer_u24lambda_u240_u240);
        return (HudPlayer)r;
    }

    private static final HudPlayer addHudPlayer$lambda$1(Function1 $tmp0, Object p0) {
        return (HudPlayer)$tmp0.invoke(p0);
    }

    static {
        playerMap = new ConcurrentHashMap();
        stringPlayer = new ConcurrentHashMap();
        PointedLocationProvider[] pointedLocationProviderArray = new PointedLocationProvider[]{PlayerManagerImpl::locationProviders$lambda$0};
        locationProviders = CollectionsKt.mutableListOf(pointedLocationProviderArray);
    }
}

