/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.pack;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.pack.PackFile;
import kr.toxicity.hud.pack.PackMeta;
import kr.toxicity.hud.pack.PackOverlay;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.collections.MapsKt;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.io.FilesKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Ref;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.text.Regex;
import kr.toxicity.hud.shaded.kotlin.text.StringsKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.ListsKt;
import kr.toxicity.hud.util.PluginsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002J$\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002J\"\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkr/toxicity/hud/pack/PackGenerator;", "", "<init>", "()V", "tasks", "Ljava/util/TreeMap;", "", "Lkr/toxicity/hud/pack/PackFile;", "generate", "", "", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "mergeFolder", "", "mergeTarget", "Ljava/io/File;", "metaBlock", "Lkr/toxicity/hud/shaded/kotlin/Function1;", "Lkr/toxicity/hud/pack/PackMeta;", "mergeZip", "addTask", "dir", "", "byteArray", "Lkr/toxicity/hud/shaded/kotlin/Function0;", "dist"})
@SourceDebugExtension(value={"SMAP\nPackGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackGenerator.kt\nkr/toxicity/hud/pack/PackGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1915#2,2:115\n1915#2,2:117\n*S KotlinDebug\n*F\n+ 1 PackGenerator.kt\nkr/toxicity/hud/pack/PackGenerator\n*L\n19#1:115,2\n30#1:117,2\n*E\n"})
public final class PackGenerator {
    @NotNull
    public static final PackGenerator INSTANCE = new PackGenerator();
    @NotNull
    private static final TreeMap<String, PackFile> tasks = new TreeMap();

    private PackGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, byte[]> generate(@NotNull ReloadInfo info) {
        Map map;
        Object $this$generate_u24lambda_u240;
        Intrinsics.checkNotNullParameter(info, "info");
        BetterCommandSource betterCommandSource = info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        BetterCommandSource sender = betterCommandSource;
        Map map2 = this;
        try {
            TreeMap treeMap;
            Object it;
            $this$generate_u24lambda_u240 = map2;
            boolean bl = false;
            Ref.ObjectRef meta = new Ref.ObjectRef();
            meta.element = PackMeta.Companion.getDefault();
            Iterable $this$forEach$iv = ConfigManagerImpl.INSTANCE.getMergeOtherFolders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl2 = false;
                File file = PluginsKt.getDATA_FOLDER().getParentFile();
                Intrinsics.checkNotNullExpressionValue(file, "getParentFile(...)");
                File mergeTarget = kr.toxicity.hud.util.FilesKt.subFolder(file, (String)it);
                if (mergeTarget.isDirectory()) {
                    super.mergeFolder(mergeTarget, arg_0 -> PackGenerator.generate$lambda$0$0$0(meta, arg_0));
                    continue;
                }
                if (!Intrinsics.areEqual(FilesKt.getExtension(mergeTarget), "zip")) continue;
                super.mergeZip(mergeTarget, arg_0 -> PackGenerator.generate$lambda$0$0$1(meta, arg_0));
            }
            $this$forEach$iv = PackOverlay.getEntries();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PackOverlay)((Object)element$iv);
                boolean bl3 = false;
                ((PackOverlay)((Object)it)).loadAssets();
            }
            ((PackGenerator)$this$generate_u24lambda_u240).addTask((Iterable<String>)CollectionsKt.listOf("pack.mcmeta"), () -> PackGenerator.generate$lambda$0$2(meta));
            InputStream inputStream = PluginsKt.getBOOTSTRAP().resource("icon.png");
            if (inputStream != null) {
                Object object = inputStream;
                int n = 8192;
                object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
                Throwable throwable = null;
                try {
                    it = (BufferedInputStream)object;
                    boolean bl4 = false;
                    byte[] read = ((InputStream)it).readAllBytes();
                    ((PackGenerator)$this$generate_u24lambda_u240).addTask((Iterable<String>)CollectionsKt.listOf("pack.png"), () -> PackGenerator.generate$lambda$0$3$0(read));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                }
            }
            TreeMap $this$generate_u24lambda_u240_u244 = treeMap = new TreeMap();
            boolean bl5 = false;
            Collection<PackFile> collection = tasks.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            ListsKt.forEachAsync(collection, arg_0 -> PackGenerator.generate$lambda$0$4$0($this$generate_u24lambda_u240_u244, arg_0));
            $this$generate_u24lambda_u240 = Result.constructor-impl(treeMap);
        }
        catch (Throwable bl) {
            $this$generate_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        map2 = $this$generate_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl(map2);
        if (throwable == null) {
            map = map2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            FunctionsKt.handle(it, sender, "Unable to make a resource pack.");
            map = MapsKt.emptyMap();
        }
        Map resourcePack = map;
        tasks.clear();
        return resourcePack;
    }

    private final void mergeFolder(File mergeTarget, Function1<? super PackMeta, Unit> metaBlock) {
        int mergeLength = mergeTarget.getPath().length() + 1;
        kr.toxicity.hud.util.FilesKt.forEach(mergeTarget, arg_0 -> PackGenerator.mergeFolder$lambda$2(metaBlock, mergeLength, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeZip(File mergeTarget, Function1<? super PackMeta, Unit> metaBlock) {
        Closeable closeable = new FileInputStream(mergeTarget);
        int n = 8192;
        closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        Throwable throwable = null;
        try {
            ZipInputStream it = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry entry = null;
            do {
                ZipEntry e;
                if ((entry = it.getNextEntry()) == null) continue;
                boolean bl2 = false;
                byte[] read = it.readAllBytes();
                if (Intrinsics.areEqual(e.getName(), "pack.mcmeta")) {
                    Object $this$mergeZip_u24lambda_u240_u240_u240;
                    var11_14 = INSTANCE;
                    try {
                        $this$mergeZip_u24lambda_u240_u240_u240 = var11_14;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull(read);
                        metaBlock.invoke(kr.toxicity.hud.util.FilesKt.toMcmeta(read));
                        $this$mergeZip_u24lambda_u240_u240_u240 = Result.constructor-impl(Unit.INSTANCE);
                    }
                    catch (Throwable bl3) {
                        $this$mergeZip_u24lambda_u240_u240_u240 = Result.constructor-impl(ResultKt.createFailure(bl3));
                    }
                    var11_14 = $this$mergeZip_u24lambda_u240_u240_u240;
                    if (Result.exceptionOrNull-impl(var11_14) != null) {
                        Throwable e2;
                        boolean bl4 = false;
                        FunctionsKt.handle(e2, "Invalid pack.mcmeta: " + mergeTarget.getPath());
                    }
                } else {
                    String string = e.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    var11_14 = string;
                    Regex regex = new Regex("[/,\\\\]");
                    int n2 = 0;
                    INSTANCE.addTask((Iterable<String>)regex.split((CharSequence)var11_14, n2), () -> PackGenerator.mergeZip$lambda$0$0$2(read));
                }
                it.closeEntry();
            } while (entry != null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTask(@NotNull Iterable<String> dir, @NotNull Function0<byte[]> byteArray) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        String str = CollectionsKt.joinToString$default(dir, "/", null, null, 0, null, null, 62, null);
        TreeMap<String, PackFile> treeMap = tasks;
        synchronized (treeMap) {
            boolean bl = false;
            PackFile packFile = tasks.computeIfAbsent(str, arg_0 -> PackGenerator.addTask$lambda$0$1(arg_0 -> PackGenerator.addTask$lambda$0$0(str, byteArray, arg_0), arg_0));
        }
    }

    private static final Unit generate$lambda$0$0$0(Ref.ObjectRef $meta, PackMeta subMeta) {
        Intrinsics.checkNotNullParameter(subMeta, "subMeta");
        $meta.element = ((PackMeta)$meta.element).plus(subMeta);
        return Unit.INSTANCE;
    }

    private static final Unit generate$lambda$0$0$1(Ref.ObjectRef $meta, PackMeta subMeta) {
        Intrinsics.checkNotNullParameter(subMeta, "subMeta");
        $meta.element = ((PackMeta)$meta.element).plus(subMeta);
        return Unit.INSTANCE;
    }

    private static final byte[] generate$lambda$0$3$0(byte[] $read) {
        Intrinsics.checkNotNull($read);
        return $read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit generate$lambda$0$4$0(TreeMap $this_apply, PackFile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        byte[] get2 = it.invoke();
        TreeMap treeMap = $this_apply;
        synchronized (treeMap) {
            boolean bl = false;
            $this_apply.put(it.getPath(), get2);
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final byte[] generate$lambda$0$2(Ref.ObjectRef $meta) {
        return ((PackMeta)$meta.element).toByteArray();
    }

    private static final Unit mergeFolder$addFile$lambda$0(int $mergeLength, File t) {
        Intrinsics.checkNotNullParameter(t, "t");
        PackGenerator.mergeFolder$addFile($mergeLength, t);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] mergeFolder$addFile$lambda$1(File $target) {
        byte[] byArray;
        Closeable closeable = new FileInputStream($target);
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream stream = (BufferedInputStream)closeable;
            boolean bl = false;
            byArray = stream.readAllBytes();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(byArray, "use(...)");
        return byArray;
    }

    private static final void mergeFolder$addFile(int mergeLength, File target) {
        if (target.isDirectory()) {
            kr.toxicity.hud.util.FilesKt.forEach(target, arg_0 -> PackGenerator.mergeFolder$addFile$lambda$0(mergeLength, arg_0));
        } else {
            String string = target.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
            String string2 = string.substring(mergeLength);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            char[] cArray = new char[]{File.separatorChar};
            INSTANCE.addTask(StringsKt.split$default((CharSequence)string2, cArray, false, 0, 6, null), () -> PackGenerator.mergeFolder$addFile$lambda$1(target));
        }
    }

    private static final Unit mergeFolder$lambda$2(Function1 $metaBlock, int $mergeLength, File target) {
        Intrinsics.checkNotNullParameter(target, "target");
        if (Intrinsics.areEqual(target.getName(), "pack.mcmeta")) {
            Object $this$mergeFolder_u24lambda_u242_u240;
            Object object = INSTANCE;
            try {
                $this$mergeFolder_u24lambda_u242_u240 = object;
                boolean bl = false;
                $metaBlock.invoke(kr.toxicity.hud.util.FilesKt.toMcmeta(target));
                $this$mergeFolder_u24lambda_u242_u240 = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$mergeFolder_u24lambda_u242_u240 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object = $this$mergeFolder_u24lambda_u242_u240;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable != null) {
                Throwable e = throwable;
                boolean bl = false;
                FunctionsKt.handle(e, "Invalid pack.mcmeta: " + target.getPath());
            }
        } else {
            PackGenerator.mergeFolder$addFile($mergeLength, target);
        }
        return Unit.INSTANCE;
    }

    private static final byte[] mergeZip$lambda$0$0$2(byte[] $read) {
        Intrinsics.checkNotNull($read);
        return $read;
    }

    private static final PackFile addTask$lambda$0$0(String $str, Function0 $byteArray, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new PackFile($str, $byteArray);
    }

    private static final PackFile addTask$lambda$0$1(Function1 $tmp0, Object p0) {
        return (PackFile)$tmp0.invoke(p0);
    }
}

