/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.pack;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.pack.PackUUID;
import kr.toxicity.hud.pack.PackUploader;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.enums.EnumEntries;
import kr.toxicity.hud.shaded.kotlin.enums.EnumEntriesKt;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.io.FilesKt;
import kr.toxicity.hud.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.sequences.SequencesKt;
import kr.toxicity.hud.shaded.kotlin.text.StringsKt;
import kr.toxicity.hud.util.ListsKt;
import kr.toxicity.hud.util.PluginsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH&j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u000e"}, d2={"Lkr/toxicity/hud/pack/PackType;", "", "<init>", "(Ljava/lang/String;I)V", "FOLDER", "ZIP", "NONE", "generate", "Ljava/io/File;", "byteMap", "", "", "", "Companion", "dist"})
public abstract class PackType
extends Enum<PackType> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final DecimalFormat decimal;
    public static final /* enum */ PackType FOLDER;
    public static final /* enum */ PackType ZIP;
    public static final /* enum */ PackType NONE;
    private static final /* synthetic */ PackType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private PackType() {
    }

    @Nullable
    public abstract File generate(@NotNull Map<String, byte[]> var1);

    public static PackType[] values() {
        return (PackType[])$VALUES.clone();
    }

    public static PackType valueOf(String value) {
        return Enum.valueOf(PackType.class, value);
    }

    @NotNull
    public static EnumEntries<PackType> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ PackType(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        FOLDER = new FOLDER("FOLDER", 0);
        ZIP = new ZIP("ZIP", 1);
        NONE = new NONE("NONE", 2);
        $VALUES = packTypeArray = new PackType[]{PackType.FOLDER, PackType.ZIP, PackType.NONE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        decimal = new DecimalFormat("#,###.###");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010$\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002J \u0010\t\u001a\u00020\n*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkr/toxicity/hud/pack/PackType$Companion;", "", "<init>", "()V", "decimal", "Ljava/text/DecimalFormat;", "mbFormat", "", "", "isSameHash", "", "", "", "target", "Ljava/io/File;", "dist"})
    @SourceDebugExtension(value={"SMAP\nPackType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackType.kt\nkr/toxicity/hud/pack/PackType$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1915#2,2:136\n*S KotlinDebug\n*F\n+ 1 PackType.kt\nkr/toxicity/hud/pack/PackType$Companion\n*L\n121#1:136,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String mbFormat(long $this$mbFormat) {
            DecimalFormat decimalFormat = decimal;
            BigDecimal bigDecimal = new BigDecimal($this$mbFormat + ".000").divide(new BigDecimal("1048576.000"), RoundingMode.HALF_EVEN);
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "divide(...)");
            return decimalFormat.format(bigDecimal) + "MB";
        }

        private final boolean isSameHash(Map<String, byte[]> $this$isSameHash, File target) {
            Boolean bl;
            Object object;
            Object $this$isSameHash_u24lambda_u240_u240;
            File $this$isSameHash_u24lambda_u240 = new File(kr.toxicity.hud.util.FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), ".cache"), "zip-hash.txt");
            boolean bl2 = false;
            Object object2 = $this$isSameHash_u24lambda_u240;
            try {
                $this$isSameHash_u24lambda_u240_u240 = object2;
                boolean bl3 = false;
                $this$isSameHash_u24lambda_u240_u240 = Result.constructor-impl(MessageDigest.getInstance("SHA-256"));
            }
            catch (Throwable bl3) {
                $this$isSameHash_u24lambda_u240_u240 = Result.constructor-impl(ResultKt.createFailure(bl3));
            }
            object2 = $this$isSameHash_u24lambda_u240_u240;
            if (Result.isSuccess-impl(object2)) {
                MessageDigest digest = (MessageDigest)object2;
                boolean bl4 = false;
                Iterable $this$forEach$iv = $this$isSameHash.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    byte[] it = (byte[])element$iv;
                    boolean bl5 = false;
                    digest.update(it);
                }
                object = Result.constructor-impl(UUID.nameUUIDFromBytes(digest.digest()).toString());
            } else {
                object = Result.constructor-impl(object2);
            }
            object2 = object;
            String string = (String)(Result.isFailure-impl(object2) ? null : object2);
            if (string != null) {
                boolean same;
                String it = string;
                boolean bl6 = false;
                boolean bl7 = same = target.exists() && $this$isSameHash_u24lambda_u240.exists() && Intrinsics.areEqual(FilesKt.readText$default($this$isSameHash_u24lambda_u240, null, 1, null), it);
                if (!same) {
                    FilesKt.writeText$default($this$isSameHash_u24lambda_u240, it, null, 2, null);
                }
                bl = same;
            } else {
                bl = null;
            }
            return Intrinsics.areEqual(bl, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0016\u00a8\u0006\b"}, d2={"kr/toxicity/hud/pack/PackType.FOLDER", "Lkr/toxicity/hud/pack/PackType;", "generate", "Ljava/io/File;", "byteMap", "", "", "", "dist"})
    @SourceDebugExtension(value={"SMAP\nPackType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackType.kt\nkr/toxicity/hud/pack/PackType$FOLDER\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1342#2,2:136\n1#3:138\n*S KotlinDebug\n*F\n+ 1 PackType.kt\nkr/toxicity/hud/pack/PackType$FOLDER\n*L\n58#1:136,2\n*E\n"})
    static final class FOLDER
    extends PackType {
        /*
         * WARNING - void declaration
         */
        FOLDER() {
            void var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public File generate(@NotNull Map<String, byte[]> byteMap) {
            long l;
            Object value;
            String[] stringArray;
            Object stream;
            Intrinsics.checkNotNullParameter(byteMap, "byteMap");
            if (PackUploader.INSTANCE.stop()) {
                String[] stringArray2 = new String[]{"Resource pack host is stopped."};
                PluginsKt.info(stringArray2);
            }
            File file = PluginsKt.getDATA_FOLDER().getParentFile();
            Intrinsics.checkNotNullExpressionValue(file, "getParentFile(...)");
            File file2 = kr.toxicity.hud.util.FilesKt.subFolder(file, ConfigManagerImpl.INSTANCE.getBuildFolderLocation());
            if (Companion.isSameHash(byteMap, file2)) {
                return file2;
            }
            FOLDER $this$generate_u24lambda_u240 = this;
            boolean bl = false;
            String after = ConfigManagerImpl.INSTANCE.getBuildFolderLocation() + File.separatorChar;
            Object object = file2;
            Serializable $this$generate_u24lambda_u240_u240 = object;
            boolean bl2 = false;
            $this$generate_u24lambda_u240_u240.mkdirs();
            object = Files.walk(((File)object).toPath(), new FileVisitOption[0]);
            $this$generate_u24lambda_u240_u240 = null;
            try {
                stream = (Stream)object;
                boolean bl3 = false;
                stream = stream.collect(Collectors.toMap(arg_0 -> FOLDER.generate$lambda$0$1$0(after, arg_0), FOLDER::generate$lambda$0$1$1, FOLDER::generate$lambda$0$1$2, FOLDER::generate$lambda$0$1$3));
            }
            catch (Throwable bl3) {
                $this$generate_u24lambda_u240_u240 = bl3;
                throw bl3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)$this$generate_u24lambda_u240_u240);
            }
            Object pathMap = stream;
            ListsKt.forEachAsync((Collection)byteMap.entrySet(), arg_0 -> FOLDER.generate$lambda$3((TreeMap)pathMap, file2, arg_0));
            if (ConfigManagerImpl.INSTANCE.getClearBuildFolder()) {
                void $this$forEach$iv;
                Set set = ((TreeMap)pathMap).entrySet();
                Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
                stringArray = SequencesKt.filter(CollectionsKt.asSequence(set), FOLDER::generate$lambda$4);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    object = (Map.Entry)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull(object);
                    value = (File)object.getValue();
                    ((File)value).delete();
                }
            }
            stringArray = new String[1];
            Iterable iterable = byteMap.values();
            Companion companion = Companion;
            int n = 0;
            String[] stringArray3 = stringArray;
            long l2 = 0L;
            for (Object t : iterable) {
                void it;
                value = (byte[])t;
                l = l2;
                boolean bl5 = false;
                long l3 = ((void)it).length;
                l2 = l + l3;
            }
            l = l2;
            stringArray3[n] = "File packed: " + companion.mbFormat(l);
            PluginsKt.info(stringArray);
            return file2;
        }

        private static final String generate$lambda$0$1$0(String $after, Path it) {
            Intrinsics.checkNotNull(it);
            return StringsKt.substringAfter$default(((Object)it).toString(), $after, null, 2, null);
        }

        private static final File generate$lambda$0$1$1(Path it) {
            return it.toFile();
        }

        private static final File generate$lambda$0$1$2(File file, File b) {
            return b;
        }

        private static final TreeMap generate$lambda$0$1$3() {
            return new TreeMap(Comparator.reverseOrder());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final File generate$toFile(String $this$generate_u24toFile, TreeMap<String, File> pathMap, File file) {
            File file2;
            String replace = StringsKt.replace$default($this$generate_u24toFile, '/', File.separatorChar, false, 4, null);
            Intrinsics.checkNotNull(pathMap);
            TreeMap<String, File> treeMap = pathMap;
            synchronized (treeMap) {
                boolean $i$a$-synchronized-PackType$FOLDER$generate$toFile$22 = false;
                File $i$a$-synchronized-PackType$FOLDER$generate$toFile$22 = pathMap.remove(replace);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var5_4
                file2 = $i$a$-synchronized-PackType$FOLDER$generate$toFile$22;
            }
            File file3 = file2;
            if (file2 == null) {
                File file4;
                File $this$generate_u24toFile_u24lambda_u242 = file4 = new File(file, replace);
                boolean bl = false;
                $this$generate_u24toFile_u24lambda_u242.getParentFile().mkdirs();
                file3 = file4;
            }
            return file3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit generate$lambda$3(TreeMap $pathMap, File $file, Map.Entry entry) {
            Intrinsics.checkNotNullParameter(entry, "<destruct>");
            String path = (String)entry.getKey();
            byte[] bytes = (byte[])entry.getValue();
            Closeable closeable = new FileOutputStream(kr.toxicity.hud.pack.PackType$FOLDER.generate$toFile(path, $pathMap, $file));
            int n = 8192;
            closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
            Throwable throwable = null;
            try {
                BufferedOutputStream it = (BufferedOutputStream)closeable;
                boolean bl = false;
                it.write(bytes);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return Unit.INSTANCE;
        }

        private static final boolean generate$lambda$4(Map.Entry entry) {
            Intrinsics.checkNotNullParameter(entry, "<destruct>");
            String key = (String)entry.getKey();
            Intrinsics.checkNotNull(key);
            return !StringsKt.startsWith$default(key, "assets/" + ConfigManagerImpl.INSTANCE.getNamespace(), false, 2, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0016\u00a8\u0006\b"}, d2={"kr/toxicity/hud/pack/PackType.NONE", "Lkr/toxicity/hud/pack/PackType;", "generate", "Ljava/io/File;", "byteMap", "", "", "", "dist"})
    static final class NONE
    extends PackType {
        /*
         * WARNING - void declaration
         */
        NONE() {
            void var1_1;
        }

        @Override
        @Nullable
        public File generate(@NotNull Map<String, byte[]> byteMap) {
            Intrinsics.checkNotNullParameter(byteMap, "byteMap");
            if (PackUploader.INSTANCE.stop()) {
                String[] stringArray = new String[]{"Resource pack host is stopped."};
                PluginsKt.info(stringArray);
            }
            return null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0016\u00a8\u0006\b"}, d2={"kr/toxicity/hud/pack/PackType.ZIP", "Lkr/toxicity/hud/pack/PackType;", "generate", "Ljava/io/File;", "byteMap", "", "", "", "dist"})
    @SourceDebugExtension(value={"SMAP\nPackType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackType.kt\nkr/toxicity/hud/pack/PackType$ZIP\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,135:1\n1#2:136\n221#3,2:137\n*S KotlinDebug\n*F\n+ 1 PackType.kt\nkr/toxicity/hud/pack/PackType$ZIP\n*L\n75#1:137,2\n*E\n"})
    static final class ZIP
    extends PackType {
        /*
         * WARNING - void declaration
         */
        ZIP() {
            void var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public File generate(@NotNull Map<String, byte[]> byteMap) {
            File file;
            block16: {
                PackUUID packUUID;
                Object object;
                Intrinsics.checkNotNullParameter(byteMap, "byteMap");
                file = new File(PluginsKt.getDATA_FOLDER().getParentFile(), ConfigManagerImpl.INSTANCE.getBuildFolderLocation() + ".zip");
                if (!Companion.isSameHash(byteMap, file)) {
                    MessageDigest digest = MessageDigest.getInstance("SHA-1");
                    Object object2 = new FileOutputStream(file);
                    int n = 8192;
                    Object it = object2 instanceof BufferedOutputStream ? (BufferedOutputStream)object2 : new BufferedOutputStream((OutputStream)object2, n);
                    boolean bl = false;
                    it = new DigestOutputStream((OutputStream)it, digest);
                    boolean bl2 = false;
                    object2 = new ZipOutputStream((OutputStream)it);
                    it = null;
                    try {
                        Object zip = (ZipOutputStream)object2;
                        boolean bl3 = false;
                        ((ZipOutputStream)zip).setComment("BetterHud's resource pack.");
                        ((ZipOutputStream)zip).setLevel(9);
                        Map<String, byte[]> $this$forEach$iv = byteMap;
                        boolean $i$f$forEach = false;
                        object = $this$forEach$iv.entrySet().iterator();
                        while (object.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry it2 = element$iv = (Map.Entry)object.next();
                            boolean bl4 = false;
                            ZipEntry entry = new ZipEntry((String)it2.getKey());
                            ((ZipOutputStream)zip).putNextEntry(entry);
                            ((FilterOutputStream)zip).write((byte[])it2.getValue());
                            ((ZipOutputStream)zip).closeEntry();
                            if (!ConfigManagerImpl.INSTANCE.getEnableProtection()) continue;
                            entry.setCrc(((byte[])it2.getValue()).length);
                            entry.setSize(new BigInteger((byte[])it2.getValue()).mod(BigInteger.valueOf(Long.MAX_VALUE)).longValue());
                        }
                        zip = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        it = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)it);
                    }
                    object2 = new String[]{"Zip packed: " + Companion.mbFormat(file.length())};
                    PluginsKt.info((String[])object2);
                    Intrinsics.checkNotNull(digest);
                    Object $this$generate_u24lambda_u243 = object2 = PackUUID.Companion.from(digest);
                    boolean bl5 = false;
                    ((PackUUID)$this$generate_u24lambda_u243).save();
                    v0 = object2;
                } else {
                    v0 = packUUID = PackUUID.Companion.getPrevious();
                }
                if (packUUID == null) break block16;
                PackUUID uuid = packUUID;
                boolean bl = false;
                if (ConfigManagerImpl.INSTANCE.getEnableSelfHost()) {
                    Closeable closeable = new FileInputStream(file);
                    int n = 8192;
                    closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
                    PackUUID packUUID2 = uuid;
                    PackUploader packUploader = PackUploader.INSTANCE;
                    Throwable throwable = null;
                    try {
                        BufferedInputStream it = (BufferedInputStream)closeable;
                        boolean bl6 = false;
                        object = it.readAllBytes();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                    byte[] byArray = object;
                    Intrinsics.checkNotNullExpressionValue(byArray, "use(...)");
                    packUploader.upload(packUUID2, byArray);
                }
            }
            return file;
        }
    }
}

