/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.pack;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import kr.toxicity.hud.shaded.kotlin.Lazy;
import kr.toxicity.hud.shaded.kotlin.LazyKt;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.text.CharsKt;
import kr.toxicity.hud.shaded.kotlin.text.Charsets;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.PluginsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u0096\u0080\u0004J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\n\u0010\u001b\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lkr/toxicity/hud/pack/PackUUID;", "", "digest", "", "hash", "", "uuid", "Ljava/util/UUID;", "<init>", "([BLjava/lang/String;Ljava/util/UUID;)V", "getDigest", "()[B", "getHash", "()Ljava/lang/String;", "getUuid", "()Ljava/util/UUID;", "save", "", "equals", "", "other", "hashCode", "", "component1", "component2", "component3", "copy", "toString", "Companion", "dist"})
public final class PackUUID {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] digest;
    @NotNull
    private final String hash;
    @NotNull
    private final UUID uuid;
    @NotNull
    private static final Lazy<File> cacheFile$delegate = LazyKt.lazy(PackUUID::cacheFile_delegate$lambda$0);
    @Nullable
    private static PackUUID _previous;

    public PackUUID(@NotNull byte[] digest, @NotNull String hash, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(digest, "digest");
        Intrinsics.checkNotNullParameter(hash, "hash");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        this.digest = digest;
        this.hash = hash;
        this.uuid = uuid;
    }

    @NotNull
    public final byte[] getDigest() {
        return this.digest;
    }

    @NotNull
    public final String getHash() {
        return this.hash;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    public final void save() {
        PackUUID.Companion.setPrevious(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PackUUID)) {
            return false;
        }
        if (!Arrays.equals(this.digest, ((PackUUID)other).digest)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.hash, ((PackUUID)other).hash)) {
            return false;
        }
        return Intrinsics.areEqual(this.uuid, ((PackUUID)other).uuid);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.digest);
        result = 31 * result + this.hash.hashCode();
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    @NotNull
    public final byte[] component1() {
        return this.digest;
    }

    @NotNull
    public final String component2() {
        return this.hash;
    }

    @NotNull
    public final UUID component3() {
        return this.uuid;
    }

    @NotNull
    public final PackUUID copy(@NotNull byte[] digest, @NotNull String hash, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(digest, "digest");
        Intrinsics.checkNotNullParameter(hash, "hash");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return new PackUUID(digest, hash, uuid);
    }

    public static /* synthetic */ PackUUID copy$default(PackUUID packUUID, byte[] byArray, String string, UUID uUID, int n, Object object) {
        if ((n & 1) != 0) {
            byArray = packUUID.digest;
        }
        if ((n & 2) != 0) {
            string = packUUID.hash;
        }
        if ((n & 4) != 0) {
            uUID = packUUID.uuid;
        }
        return packUUID.copy(byArray, string, uUID);
    }

    @NotNull
    public String toString() {
        return "PackUUID(digest=" + Arrays.toString(this.digest) + ", hash=" + this.hash + ", uuid=" + this.uuid + ")";
    }

    private static final File cacheFile_delegate$lambda$0() {
        return new File(FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), ".cache"), "pack-digest.txt");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lkr/toxicity/hud/pack/PackUUID$Companion;", "", "<init>", "()V", "cacheFile", "Ljava/io/File;", "getCacheFile", "()Ljava/io/File;", "cacheFile$delegate", "Lkr/toxicity/hud/shaded/kotlin/Lazy;", "_previous", "Lkr/toxicity/hud/pack/PackUUID;", "value", "previous", "getPrevious", "()Lkr/toxicity/hud/pack/PackUUID;", "setPrevious", "(Lkr/toxicity/hud/pack/PackUUID;)V", "load", "getLoad", "from", "messageDigest", "Ljava/security/MessageDigest;", "dist"})
    @SourceDebugExtension(value={"SMAP\nPackUUID.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackUUID.kt\nkr/toxicity/hud/pack/PackUUID$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final File getCacheFile() {
            Lazy lazy = cacheFile$delegate;
            return (File)lazy.getValue();
        }

        @Nullable
        public final PackUUID getPrevious() {
            PackUUID packUUID = _previous;
            if (packUUID == null) {
                PackUUID packUUID2 = this.getLoad();
                if (packUUID2 != null) {
                    PackUUID packUUID3;
                    PackUUID it = packUUID3 = packUUID2;
                    boolean bl = false;
                    _previous = it;
                    packUUID = packUUID3;
                } else {
                    packUUID = null;
                }
            }
            return packUUID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void setPrevious(PackUUID value) {
            PackUUID packUUID;
            PackUUID packUUID2 = value;
            if (packUUID2 != null) {
                Object $this$_set_previous__u24lambda_u240_u240_u240;
                PackUUID packUUID3;
                PackUUID $this$_set_previous__u24lambda_u240 = packUUID3 = packUUID2;
                boolean bl = false;
                File $this$_set_previous__u24lambda_u240_u240 = Companion.getCacheFile();
                boolean bl2 = false;
                Object object = $this$_set_previous__u24lambda_u240_u240;
                try {
                    $this$_set_previous__u24lambda_u240_u240_u240 = object;
                    boolean bl3 = false;
                    Object object2 = $this$_set_previous__u24lambda_u240_u240_u240;
                    Object object3 = Charsets.UTF_8;
                    int n = 8192;
                    Object object4 = object2;
                    object4 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object4), (Charset)object3);
                    object2 = object4 instanceof BufferedWriter ? (BufferedWriter)object4 : new BufferedWriter((Writer)object4, n);
                    object3 = null;
                    try {
                        BufferedWriter it = (BufferedWriter)object2;
                        boolean bl4 = false;
                        it.write(Base64.getEncoder().encodeToString($this$_set_previous__u24lambda_u240.getDigest()) + "\n");
                        it.write($this$_set_previous__u24lambda_u240.getHash() + "\n");
                        it.write($this$_set_previous__u24lambda_u240.getUuid().toString());
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        object3 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                    }
                    $this$_set_previous__u24lambda_u240_u240_u240 = Result.constructor-impl(true);
                }
                catch (Throwable bl3) {
                    $this$_set_previous__u24lambda_u240_u240_u240 = Result.constructor-impl(ResultKt.createFailure(bl3));
                }
                object = $this$_set_previous__u24lambda_u240_u240_u240;
                Throwable throwable = Result.exceptionOrNull-impl(object);
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl5 = false;
                    FunctionsKt.handle(it, "Unable to save pack digest.");
                }
                packUUID = packUUID3;
            } else {
                packUUID = null;
            }
            _previous = packUUID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final PackUUID getLoad() {
            PackUUID packUUID;
            File $this$_get_load__u24lambda_u240 = this.getCacheFile();
            boolean bl = false;
            if ($this$_get_load__u24lambda_u240.exists()) {
                Object object;
                Object $this$_get_load__u24lambda_u240_u240;
                Object object2 = $this$_get_load__u24lambda_u240;
                try {
                    PackUUID packUUID2;
                    $this$_get_load__u24lambda_u240_u240 = object2;
                    boolean bl2 = false;
                    Object object3 = $this$_get_load__u24lambda_u240_u240;
                    Object object4 = Charsets.UTF_8;
                    int n = 8192;
                    Object object5 = object3;
                    object5 = new InputStreamReader((InputStream)new FileInputStream((File)object5), (Charset)object4);
                    object3 = object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, n);
                    object4 = null;
                    try {
                        BufferedReader it = (BufferedReader)object3;
                        boolean bl3 = false;
                        byte[] byArray = Base64.getDecoder().decode(it.readLine());
                        Intrinsics.checkNotNullExpressionValue(byArray, "decode(...)");
                        String string = it.readLine();
                        Intrinsics.checkNotNullExpressionValue(string, "readLine(...)");
                        UUID uUID = UUID.fromString(it.readLine());
                        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
                        packUUID2 = new PackUUID(byArray, string, uUID);
                    }
                    catch (Throwable throwable) {
                        object4 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
                    }
                    $this$_get_load__u24lambda_u240_u240 = Result.constructor-impl(packUUID2);
                }
                catch (Throwable bl2) {
                    $this$_get_load__u24lambda_u240_u240 = Result.constructor-impl(ResultKt.createFailure(bl2));
                }
                object2 = $this$_get_load__u24lambda_u240_u240;
                Throwable throwable = Result.exceptionOrNull-impl(object2);
                if (throwable == null) {
                    object = object2;
                } else {
                    Throwable it = throwable;
                    boolean bl4 = false;
                    FunctionsKt.handle(it, "Unable to load pack digest.");
                    object = null;
                }
                packUUID = (PackUUID)object;
            } else {
                packUUID = null;
            }
            return packUUID;
        }

        @NotNull
        public final PackUUID from(@NotNull MessageDigest messageDigest) {
            Intrinsics.checkNotNullParameter(messageDigest, "messageDigest");
            StringBuilder hash = new StringBuilder(40);
            byte[] digest = messageDigest.digest();
            Intrinsics.checkNotNull(digest);
            byte[] byArray = digest;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte element;
                byte by = element = byArray[i];
                hash.append(CharsKt.digitToChar(by >> 4 & 0xF, 16)).append(CharsKt.digitToChar(by & 0xF, 16));
            }
            String string = hash.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String string2 = string;
            int t = 0;
            int n2 = 0;
            byte[] byArray2 = new byte[20];
            while (n2 < 20) {
                int n3 = n2++;
                byArray2[n3] = (byte)(Character.digit(hash.codePointAt(t++), 16) << 4 | Character.digit(hash.codePointAt(t++), 16));
            }
            UUID uuid = UUID.nameUUIDFromBytes(byArray2);
            Intrinsics.checkNotNull(uuid);
            return new PackUUID(digest, string2, uuid);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

