/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.shaded.kr.toxicity.command.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.command.CommandArgument;
import kr.toxicity.command.CommandListener;
import kr.toxicity.command.SenderType;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.BetterCommand;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.CommandMessage;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.MessageFunction;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.MethodExecutor;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Command;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class CommandModule<W extends BetterCommandSource>
implements CommandArgument<W> {
    public static final CommandMessage REQUIRED_ARGUMENT = new CommandMessage("internal.required_argument", (Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append(Component.text().content("(value)").color((TextColor)NamedTextColor.RED))).append(Component.text().content(" - ").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)"Required").color((TextColor)NamedTextColor.WHITE))).build());
    public static final CommandMessage OPTIONAL_ARGUMENT = new CommandMessage("internal.optional_argument", (Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    ").append(Component.text().content("[value]").color((TextColor)NamedTextColor.DARK_AQUA))).append(Component.text().content(" - ").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)"Optional").color((TextColor)NamedTextColor.WHITE))).build());
    public static final CommandMessage CHILDREN = new CommandMessage("internal.type.children", Component.text((String)"<children>").color((TextColor)NamedTextColor.GREEN));
    public static final CommandMessage ALIASES = new CommandMessage("internal.aliases", Component.text((String)"Aliases:").color((TextColor)NamedTextColor.DARK_AQUA));
    public static final CommandMessage PERMISSIONS = new CommandMessage("internal.permissions", Component.text((String)"Permissions:").color((TextColor)NamedTextColor.DARK_AQUA));
    public static final CommandMessage CLICK_MESSAGE = new CommandMessage("internal.click_message", (Component)Component.text((String)"Click to suggest command."));
    public static final CommandMessage UNKNOWN_DESCRIPTION = new CommandMessage("internal.unknown_command", (Component)Component.text((String)"Unknown description."));
    private final BetterCommand root;
    private final String name;
    private String helpName;
    private String[] aliases;
    private String permission;
    private Predicate<? super W> predicate = w -> true;
    private MessageFunction<W> description;
    private SenderType[] type = SenderType.values();
    private final List<CommandArgument<W>> arguments = new ArrayList<CommandArgument<W>>();

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public String[] aliases() {
        return this.aliases != null ? this.aliases : new String[]{};
    }

    @NotNull
    public CommandModule<W> aliases(@Nullable String[] aliases) {
        this.aliases = aliases;
        return this;
    }

    @Override
    @NotNull
    public MessageFunction<W> description() {
        return this.description != null ? this.description : new MessageFunction(UNKNOWN_DESCRIPTION);
    }

    @NotNull
    public CommandModule<W> description(@NotNull String key, @NotNull Component component) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(component, "component");
        return this.description(new CommandMessage(key, component));
    }

    @NotNull
    public CommandModule<W> description(@NotNull CommandMessage description) {
        Objects.requireNonNull(description, "description");
        return this.description(new MessageFunction(description));
    }

    @NotNull
    public CommandModule<W> description(@Nullable MessageFunction<W> description) {
        this.description = description;
        return this;
    }

    @Override
    @Nullable
    public String permission() {
        return this.permission;
    }

    @NotNull
    public CommandModule<W> permission(@Nullable String permission) {
        this.permission = permission;
        return this;
    }

    @NotNull
    public CommandModule<W> andPredicate(@NotNull Predicate<? super W> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        Predicate old = this.predicate;
        this.predicate = w -> old.test((Object)w) && predicate.test((Object)w);
        return this;
    }

    @NotNull
    public CommandModule<W> orPredicate(@NotNull Predicate<? super W> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        Predicate old = this.predicate;
        this.predicate = w -> old.test((Object)w) || predicate.test((Object)w);
        return this;
    }

    @NotNull
    public CommandModule<W> children(@NotNull String name, @NotNull Consumer<CommandModule<? super W>> consumer) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(consumer, "consumer");
        CommandModule child = this.root.module(name);
        child.helpName(this.helpName() + " " + name);
        consumer.accept(child);
        this.arguments.add(child);
        return this;
    }

    @NotNull
    public SenderType[] type() {
        return this.type;
    }

    @NotNull
    public CommandModule<W> type(@NotNull SenderType[] type) {
        Objects.requireNonNull(type, "type");
        this.type = type;
        return this;
    }

    @NotNull
    public String helpName() {
        return this.helpName != null ? this.helpName : this.name;
    }

    @NotNull
    public CommandModule<W> helpName(@NotNull String helpName) {
        Objects.requireNonNull(helpName, "helpName");
        this.helpName = helpName;
        return this;
    }

    @Override
    @NotNull
    public Component usage(@NotNull W w) {
        int size = this.arguments.size();
        Object args = size <= 6 ? this.arguments.stream().map(CommandArgument::name).collect(Collectors.joining("\n")) : this.arguments.subList(0, 6).stream().map(CommandArgument::name).collect(Collectors.joining("\n")) + "\n+" + (size - 6);
        return this.component(w, CHILDREN).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)args)));
    }

    @NotNull
    public CommandModule<W> executes(@NotNull CommandListener executor) {
        for (Method method : executor.getClass().getMethods()) {
            if (method.getAnnotation(Command.class) == null) continue;
            this.arguments.add(new MethodExecutor(this.root, executor, method));
        }
        return this;
    }

    private int maxPage() {
        return (int)Math.ceil((double)this.arguments.size() / 6.0);
    }

    private void showHelp(int page, W source) {
        if (source == null) {
            return;
        }
        Component info = this.component(source, this.root.prefix().info());
        Audience audience = source.audience();
        int maxPage = this.maxPage();
        page = Math.max(Math.min(page, maxPage), 1);
        audience.sendMessage(info.append(Component.text().content("----------< " + page + " / " + maxPage + " >----------").color((TextColor)NamedTextColor.GRAY)));
        audience.sendMessage(info);
        audience.sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append(info)).append(this.component(source, REQUIRED_ARGUMENT)));
        audience.sendMessage((ComponentLike)((TextComponent.Builder)Component.text().append(info)).append(this.component(source, OPTIONAL_ARGUMENT)));
        audience.sendMessage(info);
        for (CommandArgument<W> args : this.arguments.subList((page - 1) * 6, Math.min(page * 6, this.arguments.size()))) {
            String perm;
            TextComponent.Builder hover = Component.text();
            String commandName = "/" + this.helpName() + " " + args.name();
            boolean first = false;
            if (args.aliases().length > 0) {
                first = true;
                ((TextComponent.Builder)((TextComponent.Builder)hover.append(this.component(source, ALIASES))).append((Component)Component.newline())).append((Component)Component.text((String)String.join((CharSequence)", ", args.aliases())));
            }
            if ((perm = args.permission()) != null) {
                if (first) {
                    ((TextComponent.Builder)hover.append((Component)Component.newline())).append((Component)Component.newline());
                } else {
                    first = true;
                }
                ((TextComponent.Builder)((TextComponent.Builder)hover.append(this.component(source, PERMISSIONS))).append((Component)Component.newline())).append((Component)Component.text((String)perm));
            }
            if (first) {
                ((TextComponent.Builder)hover.append((Component)Component.newline())).append((Component)Component.newline());
            }
            hover.append(this.component(source, CLICK_MESSAGE));
            TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)Component.text().append(info)).append(((TextComponent.Builder)Component.text().content(commandName).color((TextColor)NamedTextColor.GOLD)).hoverEvent((HoverEventSource)HoverEvent.showText((ComponentLike)hover)));
            Component usageComponent = args.usage(source);
            if (usageComponent != null) {
                ((TextComponent.Builder)builder.append((Component)Component.space())).append(usageComponent);
            }
            audience.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)builder.append(Component.text((String)" - ").color((TextColor)NamedTextColor.GRAY))).append(this.component(source, args.description().find(source)))).clickEvent(ClickEvent.suggestCommand((String)commandName)));
        }
        audience.sendMessage(info);
        audience.sendMessage(info.append(Component.text().content("------------------------------").color((TextColor)NamedTextColor.GRAY)));
    }

    @NotNull
    private Component component(W source, @NotNull CommandMessage message) {
        return this.root.registry.find((BetterCommandSource)source, message);
    }

    @Override
    @NotNull
    public <S> @Unmodifiable List<LiteralArgumentBuilder<S>> build(@NotNull Function<S, W> mapper) {
        String[] aliases = this.aliases();
        ArrayList<String> lists = new ArrayList<String>(1 + aliases.length);
        lists.add(this.name);
        lists.addAll(Arrays.asList(aliases));
        EnumSet<SenderType> set = EnumSet.copyOf(Arrays.asList(this.type));
        return lists.stream().map(s -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)s).requires(source -> {
                BetterCommandSource wrapper = (BetterCommandSource)mapper.apply(source);
                if (wrapper == null) {
                    return true;
                }
                if (!this.predicate.test(wrapper)) {
                    return false;
                }
                if (this.permission != null && !wrapper.hasPermission(this.permission)) {
                    return false;
                }
                return set.contains((Object)wrapper.type());
            });
            ((LiteralArgumentBuilder)builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"help").requires(source -> {
                BetterCommandSource wrapper = (BetterCommandSource)mapper.apply(source);
                if (wrapper == null) {
                    return true;
                }
                if (!this.predicate.test(wrapper)) {
                    return false;
                }
                if (this.permission != null && !wrapper.hasPermission(this.permission + ".help")) {
                    return false;
                }
                return set.contains((Object)wrapper.type());
            })).then(RequiredArgumentBuilder.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1, (int)this.maxPage())).executes(context -> {
                this.showHelp((Integer)context.getArgument("page", Integer.TYPE), (BetterCommandSource)mapper.apply(context.getSource()));
                return 0;
            }))).executes(context -> {
                this.showHelp(1, (BetterCommandSource)mapper.apply(context.getSource()));
                return 0;
            }))).executes(context -> {
                this.showHelp(0, (BetterCommandSource)mapper.apply(context.getSource()));
                return 0;
            });
            for (CommandArgument<W> argument : this.arguments) {
                for (LiteralArgumentBuilder subBuilder : argument.build(mapper)) {
                    builder.then(subBuilder);
                }
            }
            return builder;
        }).toList();
    }

    @Generated
    CommandModule(BetterCommand root, String name) {
        this.root = root;
        this.name = name;
    }
}

