/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.location;

import java.util.Comparator;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lkr/toxicity/hud/location/PixelLocation;", "", "x", "", "y", "opacity", "", "<init>", "(IID)V", "section", "Lkr/toxicity/hud/api/yaml/YamlObject;", "(Lkr/toxicity/hud/api/yaml/YamlObject;)V", "getX", "()I", "getY", "getOpacity", "()D", "plus", "other", "compareTo", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "Companion", "dist"})
public final class PixelLocation
implements Comparable<PixelLocation> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    private final double opacity;
    private static final Comparator<PixelLocation> comparator = Comparator.comparingInt(arg_0 -> PixelLocation.comparator$lambda$1(PixelLocation::comparator$lambda$0, arg_0)).thenComparingInt(arg_0 -> PixelLocation.comparator$lambda$3(PixelLocation::comparator$lambda$2, arg_0)).thenComparingDouble(arg_0 -> PixelLocation.comparator$lambda$5(PixelLocation::comparator$lambda$4, arg_0));
    @NotNull
    private static final PixelLocation _hotBarHeight = new PixelLocation(0, -54, 1.0);
    @NotNull
    private static final PixelLocation zero = new PixelLocation(0, 0, 1.0);

    public PixelLocation(int x, int y, double opacity) {
        this.x = x;
        this.y = y;
        this.opacity = opacity;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final double getOpacity() {
        return this.opacity;
    }

    public PixelLocation(@NotNull YamlObject section) {
        Intrinsics.checkNotNullParameter(section, "section");
        this(section.getAsInt("x", 0), section.getAsInt("y", 0), PixelLocation.Companion.asColor(section.getAsDouble("opacity", 1.0)));
    }

    @NotNull
    public final PixelLocation plus(@NotNull PixelLocation other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new PixelLocation(this.x + other.x, this.y + other.y, PixelLocation.Companion.asColor(this.opacity * other.opacity));
    }

    @Override
    public int compareTo(@NotNull PixelLocation other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return comparator.compare(this, other);
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final double component3() {
        return this.opacity;
    }

    @NotNull
    public final PixelLocation copy(int x, int y, double opacity) {
        return new PixelLocation(x, y, opacity);
    }

    public static /* synthetic */ PixelLocation copy$default(PixelLocation pixelLocation, int n, int n2, double d, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = pixelLocation.x;
        }
        if ((n3 & 2) != 0) {
            n2 = pixelLocation.y;
        }
        if ((n3 & 4) != 0) {
            d = pixelLocation.opacity;
        }
        return pixelLocation.copy(n, n2, d);
    }

    @NotNull
    public String toString() {
        return "PixelLocation(x=" + this.x + ", y=" + this.y + ", opacity=" + this.opacity + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.x);
        result = result * 31 + Integer.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.opacity);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PixelLocation)) {
            return false;
        }
        PixelLocation pixelLocation = (PixelLocation)other;
        if (this.x != pixelLocation.x) {
            return false;
        }
        if (this.y != pixelLocation.y) {
            return false;
        }
        return Double.compare(this.opacity, pixelLocation.opacity) == 0;
    }

    private static final int comparator$lambda$0(PixelLocation image) {
        Intrinsics.checkNotNullParameter(image, "image");
        return image.x;
    }

    private static final int comparator$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int comparator$lambda$2(PixelLocation image) {
        Intrinsics.checkNotNullParameter(image, "image");
        return image.y;
    }

    private static final int comparator$lambda$3(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final double comparator$lambda$4(PixelLocation image) {
        Intrinsics.checkNotNullParameter(image, "image");
        return image.opacity;
    }

    private static final double comparator$lambda$5(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).doubleValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0005H\u0002R2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lkr/toxicity/hud/location/PixelLocation$Companion;", "", "<init>", "()V", "asColor", "", "comparator", "Ljava/util/Comparator;", "Lkr/toxicity/hud/location/PixelLocation;", "kr.toxicity.hud.shaded.kotlin.jvm.PlatformType", "_hotBarHeight", "hotBarHeight", "getHotBarHeight", "()Lkr/toxicity/hud/location/PixelLocation;", "zero", "getZero", "dist"})
    public static final class Companion {
        private Companion() {
        }

        private final double asColor(double $this$asColor) {
            return RangesKt.coerceAtMost(RangesKt.coerceAtLeast($this$asColor, 0.0), 1.0);
        }

        @NotNull
        public final PixelLocation getHotBarHeight() {
            return ConfigManagerImpl.INSTANCE.getDisableLegacyOffset() ? this.getZero() : _hotBarHeight;
        }

        @NotNull
        public final PixelLocation getZero() {
            return zero;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

