/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api.yaml;

import java.io.File;
import java.util.Map;
import kr.toxicity.hud.api.yaml.YamlArray;
import kr.toxicity.hud.api.yaml.YamlElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface YamlObject
extends Iterable<Map.Entry<String, YamlElement>>,
YamlElement {
    @Override
    @NotNull
    public Map<String, Object> get();

    @Nullable
    public YamlElement get(@NotNull String var1);

    public void merge(@NotNull YamlObject var1);

    public void save(@NotNull File var1);

    @Override
    @NotNull
    default public String asString() {
        throw new UnsupportedOperationException("object");
    }

    @Override
    default public int asInt() {
        throw new UnsupportedOperationException("object");
    }

    @Override
    default public float asFloat() {
        throw new UnsupportedOperationException("object");
    }

    @Override
    default public double asDouble() {
        throw new UnsupportedOperationException("object");
    }

    @Override
    default public boolean asBoolean() {
        throw new UnsupportedOperationException("object");
    }

    @Override
    default public long asLong() {
        throw new UnsupportedOperationException("object");
    }

    @Override
    @NotNull
    default public YamlArray asArray() {
        throw new UnsupportedOperationException("object");
    }

    @Override
    @NotNull
    default public YamlObject asObject() {
        return this;
    }

    default public boolean getAsBoolean(@NotNull String path, boolean defaultValue) {
        YamlElement value = this.get(path);
        return value != null ? value.asBoolean() : defaultValue;
    }

    default public float getAsFloat(@NotNull String path, float defaultValue) {
        YamlElement value = this.get(path);
        return value != null ? value.asFloat() : defaultValue;
    }

    default public int getAsInt(@NotNull String path, int defaultValue) {
        YamlElement value = this.get(path);
        return value != null ? value.asInt() : defaultValue;
    }

    default public double getAsDouble(@NotNull String path, double defaultValue) {
        YamlElement value = this.get(path);
        return value != null ? value.asDouble() : defaultValue;
    }

    default public long getAsLong(@NotNull String path, long defaultValue) {
        YamlElement value = this.get(path);
        return value != null ? value.asLong() : defaultValue;
    }

    @NotNull
    default public String getAsString(@NotNull String path, @NotNull String defaultValue) {
        YamlElement value = this.get(path);
        return value != null ? value.asString() : defaultValue;
    }
}

