/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api.configuration;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import kr.toxicity.hud.api.component.WidthComponent;
import kr.toxicity.hud.api.configuration.HudObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public interface HudComponentSupplier<T extends HudObject>
extends Supplier<List<WidthComponent>> {
    @NotNull
    public T parent();

    @ApiStatus.Internal
    @NotNull
    public static <R extends HudObject> HudComponentSupplier<R> empty(final @NotNull R parent) {
        return new HudComponentSupplier<R>(){

            @Override
            @NotNull
            public R parent() {
                return parent;
            }

            @Override
            @NotNull
            public @Unmodifiable List<WidthComponent> get() {
                return Collections.emptyList();
            }
        };
    }

    @ApiStatus.Internal
    @NotNull
    public static <R extends HudObject> HudComponentSupplier<R> of(final @NotNull R parent, final @NotNull Supplier<List<WidthComponent>> supplier) {
        return new HudComponentSupplier<R>(){

            @Override
            @NotNull
            public R parent() {
                return parent;
            }

            @Override
            @NotNull
            public @Unmodifiable List<WidthComponent> get() {
                return (List)supplier.get();
            }
        };
    }
}

