/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.shaded.kr.toxicity.command.impl;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.exception.KeyAlreadyExistException;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public record CommandMessage(@NotNull String key, @NotNull Component defaultMessage) implements Comparable<CommandMessage>
{
    private static final Set<CommandMessage> ALL_MESSAGES = new TreeSet<CommandMessage>();

    public CommandMessage(@NotNull String key, @NotNull Component defaultMessage) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(defaultMessage, "defaultMessage");
        this.key = key;
        this.defaultMessage = defaultMessage;
        if (!ALL_MESSAGES.add(this)) {
            throw new KeyAlreadyExistException("This key is already generated: " + key);
        }
    }

    @NotNull
    public static @Unmodifiable Set<CommandMessage> allMessages() {
        return Collections.unmodifiableSet(ALL_MESSAGES);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandMessage that = (CommandMessage)o;
        return Objects.equals(this.key, that.key);
    }

    @Override
    public int compareTo(@NotNull CommandMessage o) {
        return this.key.compareTo(o.key);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.key);
    }
}

