/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.shaded.me.lucko.jarrelocator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import kr.toxicity.hud.shaded.me.lucko.jarrelocator.Relocation;
import kr.toxicity.hud.shaded.me.lucko.jarrelocator.ResourceTransformer;

class ServicesResourceTransformer
implements ResourceTransformer {
    private static final String SERVICES_PATH = "META-INF/services/";
    private final Map<String, Set<String>> serviceEntries = new LinkedHashMap<String, Set<String>>();

    ServicesResourceTransformer() {
    }

    @Override
    public boolean shouldTransformResource(String resource) {
        return resource.startsWith(SERVICES_PATH);
    }

    @Override
    public void processResource(String resource, InputStream inputStream, Collection<Relocation> rules) throws IOException {
        String[] lines;
        String serviceClass = ServicesResourceTransformer.relocateIfPossible(resource.substring(SERVICES_PATH.length()), rules);
        Set serviceLines = this.serviceEntries.computeIfAbsent(SERVICES_PATH + serviceClass, k -> new LinkedHashSet());
        for (String line : lines = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")).replace('\r', '|').replace('\n', '|').split("\\|")) {
            if (line.isEmpty()) continue;
            serviceLines.add(ServicesResourceTransformer.relocateIfPossible(line, rules));
        }
    }

    private static String relocateIfPossible(String line, Collection<Relocation> rules) {
        for (Relocation rule : rules) {
            if (!rule.canRelocateClass(line)) continue;
            return rule.relocateClass(line);
        }
        return line;
    }

    @Override
    public void writeOutput(JarOutputStream jarOutputStream) throws IOException {
        this.serviceEntries.values().removeIf(Set::isEmpty);
        if (this.serviceEntries.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Set<String>> entry : this.serviceEntries.entrySet()) {
            jarOutputStream.putNextEntry(new JarEntry(entry.getKey()));
            StringBuilder builder = new StringBuilder();
            for (String line : entry.getValue()) {
                builder.append(line).append('\n');
            }
            jarOutputStream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
        }
    }
}

