/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.equation;

import kr.toxicity.hud.api.yaml.YamlElement;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.equation.TEquation;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Pair;
import kr.toxicity.hud.shaded.kotlin.TuplesKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.util.FunctionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0086\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lkr/toxicity/hud/equation/EquationPair;", "", "x", "Lkr/toxicity/hud/equation/TEquation;", "y", "<init>", "(Lkr/toxicity/hud/equation/TEquation;Lkr/toxicity/hud/equation/TEquation;)V", "section", "Lkr/toxicity/hud/api/yaml/YamlObject;", "(Lkr/toxicity/hud/api/yaml/YamlObject;)V", "getX", "()Lkr/toxicity/hud/equation/TEquation;", "getY", "evaluate", "Lkr/toxicity/hud/shaded/kotlin/Pair;", "", "d", "Companion", "dist"})
public final class EquationPair {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TEquation x;
    @NotNull
    private final TEquation y;
    @NotNull
    private static final EquationPair zero = new EquationPair(TEquation.Companion.getZero(), TEquation.Companion.getZero());

    public EquationPair(@NotNull TEquation x, @NotNull TEquation y) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        this.x = x;
        this.y = y;
    }

    @NotNull
    public final TEquation getX() {
        return this.x;
    }

    @NotNull
    public final TEquation getY() {
        return this.y;
    }

    @NotNull
    public final Pair<Double, Double> evaluate(double d) {
        return TuplesKt.to(this.x.evaluate(d), this.y.evaluate(d));
    }

    public EquationPair(@NotNull YamlObject section) {
        Intrinsics.checkNotNullParameter(section, "section");
        YamlElement yamlElement = section.get("x-equation");
        YamlElement yamlElement2 = section.get("y-equation");
        this(FunctionsKt.toEquation(FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, EquationPair::_init_$lambda$0)), FunctionsKt.toEquation(FunctionsKt.ifNull(yamlElement2 != null ? yamlElement2.asString() : null, EquationPair::_init_$lambda$1)));
    }

    private static final String _init_$lambda$0() {
        return "x-equation value not set.";
    }

    private static final String _init_$lambda$1() {
        return "y-equation value not set.";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lkr/toxicity/hud/equation/EquationPair$Companion;", "", "<init>", "()V", "zero", "Lkr/toxicity/hud/equation/EquationPair;", "getZero", "()Lkr/toxicity/hud/equation/EquationPair;", "dist"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EquationPair getZero() {
            return zero;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

