/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.background.HudBackground;
import kr.toxicity.hud.image.LoadedImage;
import kr.toxicity.hud.location.PixelLocation;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.manager.EncodeManager;
import kr.toxicity.hud.pack.PackGenerator;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.io.FilesKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.util.EncodesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.ImagesKt;
import kr.toxicity.hud.util.MapsKt;
import kr.toxicity.hud.util.YamlsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0005J\b\u0010\u0014\u001a\u00020\u0011H\u0016J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkr/toxicity/hud/manager/BackgroundManager;", "Lkr/toxicity/hud/manager/BetterHudManager;", "<init>", "()V", "managerName", "", "getManagerName", "()Ljava/lang/String;", "supportExternalPacks", "", "getSupportExternalPacks", "()Z", "backgroundMap", "Ljava/util/HashMap;", "Lkr/toxicity/hud/background/HudBackground;", "Lkr/toxicity/hud/shaded/kotlin/collections/HashMap;", "start", "", "getBackground", "name", "preReload", "reload", "workingDirectory", "Ljava/io/File;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "end", "dist"})
public final class BackgroundManager
implements BetterHudManager {
    @NotNull
    public static final BackgroundManager INSTANCE = new BackgroundManager();
    @NotNull
    private static final String managerName = "Background";
    private static final boolean supportExternalPacks = true;
    @NotNull
    private static final HashMap<String, HudBackground> backgroundMap = new HashMap();

    private BackgroundManager() {
    }

    @Override
    @NotNull
    public String getManagerName() {
        return managerName;
    }

    @Override
    public boolean getSupportExternalPacks() {
        return supportExternalPacks;
    }

    @Override
    public void start() {
    }

    @Nullable
    public final HudBackground getBackground(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return backgroundMap.get(name);
    }

    @Override
    public void preReload() {
        backgroundMap.clear();
    }

    @Override
    public void reload(@NotNull File workingDirectory, @NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        File folder = kr.toxicity.hud.util.FilesKt.subFolder(workingDirectory, "backgrounds");
        kr.toxicity.hud.util.FilesKt.forEach(folder, arg_0 -> BackgroundManager.reload$lambda$7(info, folder, resource, arg_0));
    }

    @Override
    public void end() {
    }

    @Override
    public void postReload() {
        BetterHudManager.DefaultImpls.postReload(this);
    }

    private static final String reload$lambda$7$lambda$5$getImage$lambda$0(String $imageName, String $name) {
        return "this image doesn't exist: " + $imageName + ".png in " + $name;
    }

    private static final String reload$lambda$7$lambda$5$getImage$lambda$1(String $imageName, String $name) {
        return "this image is empty: " + $imageName + ".png in " + $name;
    }

    private static final byte[] reload$lambda$7$lambda$5$getImage$lambda$3$lambda$2(LoadedImage $this_apply) {
        return ImagesKt.toByteArray($this_apply.getImage());
    }

    private static final LoadedImage reload$lambda$7$lambda$5$getImage(File backgroundFolder, String name, GlobalResource $resource, String imageName) {
        LoadedImage loadedImage;
        LoadedImage $this$reload_u24lambda_u247_u24lambda_u245_u24getImage_u24lambda_u243 = loadedImage = FunctionsKt.ifNull(ImagesKt.removeEmptyWidth$default(ImagesKt.toImage(kr.toxicity.hud.util.FilesKt.ifNotExist(new File(backgroundFolder, imageName + ".png"), () -> BackgroundManager.reload$lambda$7$lambda$5$getImage$lambda$0(imageName, name))), 0, 0, 3, null), () -> BackgroundManager.reload$lambda$7$lambda$5$getImage$lambda$1(imageName, name));
        boolean bl = false;
        PackGenerator.INSTANCE.addTask((Iterable<String>)CollectionsKt.plus((Collection)$resource.getTextures(), EncodesKt.encodeKey("background_" + name + "_" + imageName, EncodeManager.EncodeNamespace.TEXTURES) + ".png"), () -> BackgroundManager.reload$lambda$7$lambda$5$getImage$lambda$3$lambda$2($this$reload_u24lambda_u247_u24lambda_u245_u24getImage_u24lambda_u243));
        return loadedImage;
    }

    private static final HudBackground reload$lambda$7$lambda$5$lambda$4(String $name, YamlObject $yaml, File $backgroundFolder, GlobalResource $resource) {
        return new HudBackground($name, BackgroundManager.reload$lambda$7$lambda$5$getImage($backgroundFolder, $name, $resource, "left"), BackgroundManager.reload$lambda$7$lambda$5$getImage($backgroundFolder, $name, $resource, "right"), BackgroundManager.reload$lambda$7$lambda$5$getImage($backgroundFolder, $name, $resource, "body"), new PixelLocation($yaml));
    }

    private static final String reload$lambda$7$lambda$6(File $it) {
        return "Unable to load this yml: " + $it.getName();
    }

    private static final Unit reload$lambda$7(ReloadInfo $info, File $folder, GlobalResource $resource, File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (Intrinsics.areEqual(FilesKt.getExtension(it), "yml")) {
            Object object;
            BackgroundManager backgroundManager = INSTANCE;
            try {
                BackgroundManager $this$reload_u24lambda_u247_u24lambda_u245 = backgroundManager;
                boolean bl = false;
                YamlObject yaml = YamlsKt.toYaml(it);
                String name = FilesKt.getNameWithoutExtension(it);
                File backgroundFolder = kr.toxicity.hud.util.FilesKt.subFolder($folder, name);
                MapsKt.putSync((Map)backgroundMap, "background", () -> BackgroundManager.reload$lambda$7$lambda$5$lambda$4(name, yaml, backgroundFolder, $resource));
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            FunctionsKt.handleFailure(object, $info, () -> BackgroundManager.reload$lambda$7$lambda$6(it));
        }
        return Unit.INSTANCE;
    }
}

