/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.shaded.kr.toxicity.command.impl;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.command.CommandArgument;
import kr.toxicity.command.CommandListener;
import kr.toxicity.command.SenderType;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.BetterCommand;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.ClassSerializer;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.CommandMessage;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.MessageFunction;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Aliases;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.CanBeNull;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Description;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Option;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Permission;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Sender;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Source;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Vararg;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.exception.NotLastParameterException;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.exception.NotSerializerRegisteredException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodExecutor<W extends BetterCommandSource>
implements CommandArgument<W> {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_REFERENCE = Map.ofEntries(Map.entry(Integer.TYPE, Integer.class), Map.entry(Boolean.TYPE, Boolean.class), Map.entry(Double.TYPE, Double.class), Map.entry(Character.TYPE, Character.class), Map.entry(Float.TYPE, Float.class), Map.entry(Short.TYPE, Short.class), Map.entry(Byte.TYPE, Byte.class), Map.entry(Long.TYPE, Long.class));
    private static final Pattern VALUE_PATTERN = Pattern.compile("\\[value]");
    private final BetterCommand root;
    private final String name;
    private final CommandMessage description;
    private final String permission;
    private final CommandListener obj;
    private final Method method;
    private final String[] aliases;
    private List<UsageGetter<W>> usage = Collections.emptyList();

    MethodExecutor(@NotNull BetterCommand root, @NotNull CommandListener obj, @NotNull Method method) {
        try {
            method.setAccessible(true);
        }
        catch (Exception e) {
            root.handleException(e);
            throw new RuntimeException(e);
        }
        this.root = root;
        this.name = method.getName();
        Description description = Objects.requireNonNull(method.getDeclaredAnnotation(Description.class), "@Description annotation not found in method " + this.name + ".");
        this.description = new CommandMessage(description.key(), root.serializer.deserialize((Object)description.defaultValue()));
        this.permission = Optional.ofNullable(method.getDeclaredAnnotation(Permission.class)).map(Permission::value).orElse(null);
        Aliases aliasesAnnotation = method.getAnnotation(Aliases.class);
        this.aliases = aliasesAnnotation != null ? aliasesAnnotation.aliases() : new String[]{};
        this.method = method;
        this.obj = obj;
    }

    @Override
    @NotNull
    public <S> List<LiteralArgumentBuilder<S>> build(final @NotNull Function<S, W> mapper) {
        this.usage = new ArrayList<UsageGetter<W>>();
        Sender typeAnnotation = this.method.getAnnotation(Sender.class);
        EnumSet<SenderType> type = EnumSet.copyOf(Arrays.asList(typeAnnotation != null ? typeAnnotation.type() : SenderType.values()));
        ArrayList<String> lists = new ArrayList<String>(1 + this.aliases.length);
        lists.add(this.name);
        lists.addAll(Arrays.asList(this.aliases));
        ArrayList<RequiredArgumentBuilder> commandTree = new ArrayList<RequiredArgumentBuilder>();
        ArrayList valueList = new ArrayList();
        int lastParameter = this.method.getParameters().length - 1;
        int parameterIndex = 0;
        boolean option = false;
        for (Parameter parameter : this.method.getParameters()) {
            boolean canBeNull;
            Class<?> clazz = parameter.getType();
            option = parameter.getAnnotation(Option.class) != null;
            boolean vararg = parameter.getAnnotation(Vararg.class) != null;
            boolean bl = canBeNull = !option && parameter.getAnnotation(CanBeNull.class) != null;
            if ((option || vararg) && parameterIndex < lastParameter) {
                throw new NotLastParameterException("@Option or @Vararg can work only last parameter.");
            }
            ++parameterIndex;
            if (parameter.getType().isAssignableFrom(clazz) && parameter.getAnnotation(Source.class) != null) {
                valueList.add(new ContextParser<S>(){

                    @Override
                    public boolean canBeNull() {
                        return canBeNull;
                    }

                    @Override
                    @NotNull
                    public String key(@NotNull CommandContext<S> context) {
                        return "";
                    }

                    @Override
                    public void nullMessage(@NotNull CommandContext<S> context, @NotNull String value) {
                    }

                    @Override
                    @Nullable
                    public Object parse(@NotNull CommandContext<S> context) {
                        return mapper.apply(context.getSource());
                    }
                });
                continue;
            }
            Class<?> ref = PRIMITIVE_TO_REFERENCE.get(clazz);
            Class<?> finalClazz = ref != null ? ref : clazz;
            final ClassSerializer<?> serializer = this.root.find(finalClazz);
            if (serializer == null) {
                throw new NotSerializerRegisteredException("A serializer for " + finalClazz.getSimpleName() + " not found.");
            }
            final String key = parameter.getName();
            commandTree.add(RequiredArgumentBuilder.argument((String)key, (ArgumentType)(vararg ? StringArgumentType.greedyString() : StringArgumentType.string())).suggests((context, builder1) -> {
                for (String suggest : serializer.suggests((BetterCommandSource)mapper.apply(context.getSource()))) {
                    builder1.suggest(suggest);
                }
                return builder1.buildFuture();
            }));
            this.usage.add(new UsageGetter<BetterCommandSource>(option ? serializer.optional() : serializer.required(), serializer::suggests));
            valueList.add(new ContextParser<S>(){

                @Override
                public boolean canBeNull() {
                    return canBeNull;
                }

                @Override
                public void nullMessage(@NotNull CommandContext<S> context, @NotNull String value) {
                    BetterCommandSource wrapper = (BetterCommandSource)mapper.apply(context.getSource());
                    wrapper.audience().sendMessage(MethodExecutor.this.root.registry.find(wrapper, serializer.nullMessage()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(VALUE_PATTERN).replacement((r, b) -> Component.text((String)value)).build()));
                }

                @Override
                @NotNull
                public String key(@NotNull CommandContext<S> context) {
                    return (String)context.getArgument(key, String.class);
                }

                @Override
                @Nullable
                public Object parse(@NotNull CommandContext<S> context) {
                    return serializer.deserialize((BetterCommandSource)mapper.apply(context.getSource()), this.key((CommandContext<S>)context));
                }
            });
        }
        Command command = context -> {
            try {
                Object[] array = new Object[valueList.size()];
                int i = 0;
                for (ContextParser parser : valueList) {
                    Object value = parser.parse(context);
                    if (!parser.canBeNull() && value == null) {
                        parser.nullMessage(context, parser.key(context));
                        return 0;
                    }
                    array[i++] = value;
                }
                this.method.invoke((Object)this.obj, array);
            }
            catch (Exception e) {
                this.root.handleException(e);
                throw new RuntimeException(e);
            }
            return 0;
        };
        ArrayList<LiteralArgumentBuilder<S>> nodes = new ArrayList<LiteralArgumentBuilder<S>>(lists.size());
        for (String s : lists) {
            LiteralArgumentBuilder previous;
            LiteralArgumentBuilder node = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)s).requires(source -> {
                BetterCommandSource wrapper = (BetterCommandSource)mapper.apply(source);
                if (wrapper == null) {
                    return true;
                }
                if (this.permission != null && !wrapper.hasPermission(this.permission)) {
                    return false;
                }
                return type.contains((Object)wrapper.type());
            });
            int treeIndex = commandTree.size() - 1;
            if (option) {
                previous = treeIndex - 1 >= 0 ? (ArgumentBuilder)commandTree.get(treeIndex - 1) : node;
                previous.executes(context -> {
                    try {
                        Object[] array = new Object[valueList.size()];
                        int i = 0;
                        for (ContextParser parser : valueList.subList(0, valueList.size() - 1)) {
                            Object value = parser.parse(context);
                            if (!parser.canBeNull() && value == null) {
                                parser.nullMessage(context, parser.key(context));
                                return 0;
                            }
                            array[i++] = value;
                        }
                        array[i] = null;
                        this.method.invoke((Object)this.obj, array);
                    }
                    catch (Exception e) {
                        this.root.handleException(e);
                        throw new RuntimeException(e);
                    }
                    return 0;
                });
            }
            if (commandTree.isEmpty()) {
                nodes.add((LiteralArgumentBuilder)node.executes(command));
                continue;
            }
            ((RequiredArgumentBuilder)commandTree.get(treeIndex)).executes(command);
            while (treeIndex >= 0) {
                previous = treeIndex - 1 >= 0 ? (ArgumentBuilder)commandTree.get(treeIndex - 1) : node;
                previous.then((ArgumentBuilder)commandTree.get(treeIndex));
                --treeIndex;
            }
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public String[] aliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public String permission() {
        return this.permission;
    }

    @Override
    @NotNull
    public MessageFunction<W> description() {
        return new MessageFunction(this.description);
    }

    @Override
    @Nullable
    public Component usage(@NotNull W w) {
        if (this.usage.isEmpty()) {
            return null;
        }
        TextComponent.Builder builder = Component.text();
        int index2 = 0;
        int last = this.usage.size() - 1;
        for (UsageGetter<W> commandMessage : this.usage) {
            List<String> suggests = commandMessage.suggests.apply(w);
            int size = suggests.size();
            Object args = size <= 6 ? String.join((CharSequence)"\n", suggests) : String.join((CharSequence)"\n", suggests.subList(0, 6)) + "\n+" + (size - 6);
            builder.append(this.root.registry.find((BetterCommandSource)w, commandMessage.message).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)args))));
            if (index2++ >= last) continue;
            builder.append((Component)Component.space());
        }
        return builder.build();
    }

    private record UsageGetter<T>(@NotNull CommandMessage message, @NotNull Function<T, List<String>> suggests) {
    }

    private static interface ContextParser<T> {
        public boolean canBeNull();

        public void nullMessage(@NotNull CommandContext<T> var1, @NotNull String var2);

        @NotNull
        public String key(@NotNull CommandContext<T> var1);

        @Nullable
        public Object parse(@NotNull CommandContext<T> var1);
    }
}

