/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.imageio.ImageIO;
import kr.toxicity.hud.image.LoadedImage;
import kr.toxicity.hud.image.NamedLoadedImage;
import kr.toxicity.hud.image.enums.FlipType;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0004\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\n\u001a\n\u0010\r\u001a\u00020\f*\u00020\u0006\u001a\n\u0010\r\u001a\u00020\f*\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a \u0010\u0014\u001a\u0004\u0018\u00010\u0011*\u00020\f2\b\b\u0002\u0010\u0015\u001a\u00020\u00012\b\b\u0002\u0010\u0016\u001a\u00020\u0001\u001a\f\u0010\u0017\u001a\u0004\u0018\u00010\u0011*\u00020\f\u001a\u0012\u0010\u0018\u001a\u00020\f*\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u0011*\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001a2\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\u0018\u0010\u001f\u001a\u00020\f*\u00020\f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"WHITE", "", "save", "", "Ljava/awt/image/RenderedImage;", "file", "Ljava/io/File;", "outputStream", "Ljava/io/OutputStream;", "toByteArray", "", "hexToImage", "Ljava/awt/image/BufferedImage;", "toImage", "Ljava/io/InputStream;", "toNamed", "Lkr/toxicity/hud/image/NamedLoadedImage;", "Lkr/toxicity/hud/image/LoadedImage;", "name", "", "removeEmptyWidth", "x", "y", "removeEmptySide", "withOpacity", "opacity", "", "circleCut", "degree", "reversed", "", "flip", "fileTypes", "", "Lkr/toxicity/hud/image/enums/FlipType;", "dist"})
public final class ImagesKt {
    private static final int WHITE = -1;

    public static final void save(@NotNull RenderedImage $this$save, @NotNull File file) {
        Intrinsics.checkNotNullParameter($this$save, "<this>");
        Intrinsics.checkNotNullParameter(file, "file");
        ImageIO.write($this$save, "png", file);
    }

    public static final void save(@NotNull RenderedImage $this$save, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter($this$save, "<this>");
        Intrinsics.checkNotNullParameter(outputStream, "outputStream");
        ImageIO.write($this$save, "png", outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] toByteArray(@NotNull RenderedImage $this$toByteArray) {
        Intrinsics.checkNotNullParameter($this$toByteArray, "<this>");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Closeable closeable = byteArrayOutputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream buffer = (BufferedOutputStream)closeable;
            boolean bl = false;
            boolean bl2 = ImageIO.write($this$toByteArray, "png", buffer);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    @NotNull
    public static final BufferedImage hexToImage(@NotNull byte[] $this$hexToImage) {
        Intrinsics.checkNotNullParameter($this$hexToImage, "<this>");
        int width = $this$hexToImage.length / 16;
        BufferedImage image = new BufferedImage(width, 16, 2);
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int i1 = 0; i1 < width; ++i1) {
                if ($this$hexToImage[i1 + i2 * width] != 1) continue;
                image.setRGB(i1, i2, -1);
            }
        }
        return image;
    }

    @NotNull
    public static final BufferedImage toImage(@NotNull File $this$toImage) {
        Intrinsics.checkNotNullParameter($this$toImage, "<this>");
        BufferedImage bufferedImage = ImageIO.read($this$toImage);
        Intrinsics.checkNotNullExpressionValue(bufferedImage, "read(...)");
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage toImage(@NotNull InputStream $this$toImage) {
        Intrinsics.checkNotNullParameter($this$toImage, "<this>");
        BufferedImage bufferedImage = ImageIO.read($this$toImage);
        Intrinsics.checkNotNullExpressionValue(bufferedImage, "read(...)");
        return bufferedImage;
    }

    @NotNull
    public static final NamedLoadedImage toNamed(@NotNull LoadedImage $this$toNamed, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$toNamed, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        return new NamedLoadedImage(name, $this$toNamed);
    }

    @Nullable
    public static final LoadedImage removeEmptyWidth(@NotNull BufferedImage $this$removeEmptyWidth, int x, int y) {
        Intrinsics.checkNotNullParameter($this$removeEmptyWidth, "<this>");
        int widthA = 0;
        int widthB = $this$removeEmptyWidth.getWidth();
        int n = $this$removeEmptyWidth.getWidth();
        for (int i1 = 0; i1 < n; ++i1) {
            int n2 = $this$removeEmptyWidth.getHeight();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (($this$removeEmptyWidth.getRGB(i1, i2) & 0xFF000000) >>> 24 <= 0) continue;
                if (widthA < i1) {
                    widthA = i1;
                }
                if (widthB <= i1) continue;
                widthB = i1;
            }
        }
        int finalWidth = widthA - widthB + 1;
        if (finalWidth <= 0) {
            return null;
        }
        BufferedImage bufferedImage = $this$removeEmptyWidth.getSubimage(widthB, 0, finalWidth, $this$removeEmptyWidth.getHeight());
        Intrinsics.checkNotNullExpressionValue(bufferedImage, "getSubimage(...)");
        return new LoadedImage(bufferedImage, widthB + x, y);
    }

    public static /* synthetic */ LoadedImage removeEmptyWidth$default(BufferedImage bufferedImage, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return ImagesKt.removeEmptyWidth(bufferedImage, n, n2);
    }

    @Nullable
    public static final LoadedImage removeEmptySide(@NotNull BufferedImage $this$removeEmptySide) {
        Intrinsics.checkNotNullParameter($this$removeEmptySide, "<this>");
        int heightA = 0;
        int heightB = $this$removeEmptySide.getHeight();
        int widthA = 0;
        int widthB = $this$removeEmptySide.getWidth();
        int n = $this$removeEmptySide.getWidth();
        for (int i1 = 0; i1 < n; ++i1) {
            int n2 = $this$removeEmptySide.getHeight();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (($this$removeEmptySide.getRGB(i1, i2) & 0xFF000000) >>> 24 <= 0) continue;
                if (widthA < i1) {
                    widthA = i1;
                }
                if (widthB > i1) {
                    widthB = i1;
                }
                if (heightA < i2) {
                    heightA = i2;
                }
                if (heightB <= i2) continue;
                heightB = i2;
            }
        }
        int finalWidth = widthA - widthB + 1;
        int finalHeight = heightA - heightB + 1;
        if (finalWidth <= 0 || finalHeight <= 0) {
            return null;
        }
        BufferedImage bufferedImage = $this$removeEmptySide.getSubimage(widthB, heightB, finalWidth, finalHeight);
        Intrinsics.checkNotNullExpressionValue(bufferedImage, "getSubimage(...)");
        return new LoadedImage(bufferedImage, widthB, heightB);
    }

    @NotNull
    public static final BufferedImage withOpacity(@NotNull BufferedImage $this$withOpacity, double opacity) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter($this$withOpacity, "<this>");
        BufferedImage it = bufferedImage = new BufferedImage($this$withOpacity.getWidth(), $this$withOpacity.getHeight(), 2);
        boolean bl = false;
        int n = $this$withOpacity.getWidth();
        for (int i1 = 0; i1 < n; ++i1) {
            int n2 = $this$withOpacity.getHeight();
            for (int i2 = 0; i2 < n2; ++i2) {
                int rgba = $this$withOpacity.getRGB(i1, i2);
                it.setRGB(i1, i2, MathKt.roundToInt(opacity * (double)(rgba >> 24 & 0xFF)) << 24 | rgba & 0xFFFFFF);
            }
        }
        return bufferedImage;
    }

    @Nullable
    public static final LoadedImage circleCut(@NotNull LoadedImage $this$circleCut, double degree, boolean reversed) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter($this$circleCut, "<this>");
        BufferedImage it = bufferedImage = new BufferedImage($this$circleCut.getImage().getWidth(), $this$circleCut.getImage().getHeight(), 2);
        boolean bl = false;
        double hw = (double)$this$circleCut.getImage().getWidth() / (double)2;
        double hh = (double)$this$circleCut.getImage().getHeight() / (double)2;
        int n = $this$circleCut.getImage().getWidth();
        for (int w = 0; w < n; ++w) {
            int n2 = $this$circleCut.getImage().getHeight();
            for (int h = 0; h < n2; ++h) {
                double d = -(Math.atan2((double)h - hh, (double)w - hw) + 1.5707963267948966);
                if (reversed) {
                    d *= (double)-1;
                }
                if (d < 0.0) {
                    d += Math.PI * 2;
                }
                if (d > Math.PI * 2) {
                    d -= Math.PI * 2;
                }
                if (!(d <= degree)) continue;
                it.setRGB(w, h, $this$circleCut.getImage().getRGB(w, h));
            }
        }
        return ImagesKt.removeEmptyWidth(bufferedImage, $this$circleCut.getXOffset(), $this$circleCut.getYOffset());
    }

    public static /* synthetic */ LoadedImage circleCut$default(LoadedImage loadedImage, double d, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ImagesKt.circleCut(loadedImage, d, bl);
    }

    @NotNull
    public static final BufferedImage flip(@NotNull BufferedImage $this$flip, @NotNull Set<? extends FlipType> fileTypes) {
        Intrinsics.checkNotNullParameter($this$flip, "<this>");
        Intrinsics.checkNotNullParameter(fileTypes, "fileTypes");
        return FlipType.Companion.flip($this$flip, fileTypes);
    }
}

