/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kr.toxicity.hud.api.BetterHudBootstrap;
import kr.toxicity.hud.api.version.MinecraftVersion;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.sequences.SequencesKt;
import kr.toxicity.hud.util.ArtifactVersion;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.GsonsKt;
import kr.toxicity.hud.util.LatestVersion;
import kr.toxicity.hud.util.PluginsKt;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.semver4j.Semver;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"VERSION_GSON", "Lcom/google/gson/Gson;", "kr.toxicity.hud.shaded.kotlin.jvm.PlatformType", "VERSION_CHECK_PERMISSION", "", "handleLatestVersion", "", "Lnet/kyori/adventure/text/Component;", "latestVersion", "Lkr/toxicity/hud/util/LatestVersion;", "minecraftVersion", "Lkr/toxicity/hud/api/version/MinecraftVersion;", "loader", "artifactVersions", "Lkr/toxicity/hud/util/ArtifactVersion;", "dist"})
public final class VersionsKt {
    private static final Gson VERSION_GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)MinecraftVersion.class), (Object)new JsonDeserializer<MinecraftVersion>(){

        public MinecraftVersion deserialize(JsonElement p0, Type p1, JsonDeserializationContext p2) {
            Intrinsics.checkNotNullParameter(p0, "p0");
            Intrinsics.checkNotNullParameter(p1, "p1");
            Intrinsics.checkNotNullParameter(p2, "p2");
            return new MinecraftVersion(p0.getAsString());
        }
    }).registerTypeAdapter((Type)((Object)Semver.class), (Object)new JsonDeserializer<Semver>(){

        public Semver deserialize(JsonElement p0, Type p1, JsonDeserializationContext p2) {
            Intrinsics.checkNotNullParameter(p0, "p0");
            Intrinsics.checkNotNullParameter(p1, "p1");
            Intrinsics.checkNotNullParameter(p2, "p2");
            String string = p0.getAsString();
            Intrinsics.checkNotNullExpressionValue(string, "getAsString(...)");
            return FunctionsKt.toSemver(string);
        }
    }).create();
    @NotNull
    public static final String VERSION_CHECK_PERMISSION = "betterhud.info";

    @NotNull
    public static final List<Component> handleLatestVersion() {
        List list;
        block4: {
            ArtifactVersion it;
            String string = PluginsKt.getBOOTSTRAP().version();
            Intrinsics.checkNotNullExpressionValue(string, "version(...)");
            Semver bootstrap = FunctionsKt.toSemver(string);
            list = new ArrayList();
            LatestVersion latest = VersionsKt.latestVersion();
            if (PluginsKt.getPLUGIN().isDevVersion()) {
                String[] stringArray = new String[]{"This build is dev version - be careful to use it!"};
                PluginsKt.warn(stringArray);
            }
            ArtifactVersion artifactVersion = latest.getRelease();
            if (artifactVersion != null) {
                it = artifactVersion;
                boolean bl = false;
                if (bootstrap.compareTo(it.getVersionNumber()) < 0) {
                    ((Collection)list).add(Component.text((String)"Found a new release of BetterHud: ").append(it.toURLComponent()));
                }
            }
            ArtifactVersion artifactVersion2 = latest.getSnapshot();
            if (artifactVersion2 == null) break block4;
            it = artifactVersion2;
            boolean bl = false;
            if (bootstrap.compareTo(it.getVersionNumber()) < 0) {
                ((Collection)list).add(Component.text((String)"Found a new snapshot of BetterHud: ").append(it.toURLComponent()));
            }
        }
        return list;
    }

    @NotNull
    public static final LatestVersion latestVersion() {
        BetterHudBootstrap bootstrap = PluginsKt.getBOOTSTRAP();
        MinecraftVersion minecraftVersion = bootstrap.minecraftVersion();
        Intrinsics.checkNotNullExpressionValue(minecraftVersion, "minecraftVersion(...)");
        String string = bootstrap.loaderName();
        Intrinsics.checkNotNullExpressionValue(string, "loaderName(...)");
        return VersionsKt.latestVersion(minecraftVersion, string);
    }

    @NotNull
    public static final LatestVersion latestVersion(@NotNull MinecraftVersion minecraftVersion, @NotNull String loader) {
        Intrinsics.checkNotNullParameter(minecraftVersion, "minecraftVersion");
        Intrinsics.checkNotNullParameter(loader, "loader");
        return new LatestVersion(VersionsKt.artifactVersions(minecraftVersion, loader));
    }

    @NotNull
    public static final List<ArtifactVersion> artifactVersions(@NotNull MinecraftVersion minecraftVersion, @NotNull String loader) {
        List list;
        Intrinsics.checkNotNullParameter(minecraftVersion, "minecraftVersion");
        Intrinsics.checkNotNullParameter(loader, "loader");
        List list2 = FunctionsKt.httpClient(arg_0 -> VersionsKt.artifactVersions$lambda$7(minecraftVersion, loader, arg_0));
        Throwable throwable = Result.exceptionOrNull-impl(list2);
        if (throwable == null) {
            list = list2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            FunctionsKt.handle(it, "Unable to BetterHud's latest version.");
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final ArtifactVersion artifactVersions$lambda$7$lambda$6$lambda$4(HttpClient $this_httpClient, JsonElement json) {
        Object object;
        Object object2 = $this_httpClient;
        try {
            HttpClient $this$artifactVersions_u24lambda_u247_u24lambda_u246_u24lambda_u244_u24lambda_u243 = object2;
            boolean bl = false;
            object = Result.constructor-impl((ArtifactVersion)VERSION_GSON.fromJson(json, ArtifactVersion.class));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        return (ArtifactVersion)(Result.isFailure-impl(object2) ? null : object2);
    }

    private static final boolean artifactVersions$lambda$7$lambda$6$lambda$5(MinecraftVersion $minecraftVersion, String $loader, ArtifactVersion version) {
        Intrinsics.checkNotNullParameter(version, "version");
        return version.getGameVersions().contains($minecraftVersion) && version.getLoaders().contains($loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List artifactVersions$lambda$7(MinecraftVersion $minecraftVersion, String $loader, HttpClient $this$httpClient) {
        List<ArtifactVersion> list;
        Intrinsics.checkNotNullParameter($this$httpClient, "$this$httpClient");
        Closeable closeable = $this$httpClient.send(HttpRequest.newBuilder().GET().uri(URI.create("https://api.modrinth.com/v2/project/betterhud2/version")).build(), HttpResponse.BodyHandlers.ofInputStream()).body();
        Throwable throwable = null;
        try {
            JsonElement jsonElement;
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new InputStreamReader(it);
            Throwable throwable2 = null;
            try {
                InputStreamReader reader = (InputStreamReader)closeable2;
                boolean bl2 = false;
                jsonElement = GsonsKt.parseJson(reader);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue(jsonArray, "getAsJsonArray(...)");
            list = SequencesKt.toList(SequencesKt.sortedDescending(SequencesKt.filter(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)jsonArray), arg_0 -> VersionsKt.artifactVersions$lambda$7$lambda$6$lambda$4($this$httpClient, arg_0)), arg_0 -> VersionsKt.artifactVersions$lambda$7$lambda$6$lambda$5($minecraftVersion, $loader, arg_0))));
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return list;
    }
}

