/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.version.MinecraftVersion;
import kr.toxicity.hud.element.TextElement;
import kr.toxicity.hud.image.LoadedImage;
import kr.toxicity.hud.layout.TextLayout;
import kr.toxicity.hud.location.PixelLocation;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.text.StringsKt;
import kr.toxicity.hud.text.ImageTextScale;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.GsonsKt;
import kr.toxicity.hud.util.ImagesKt;
import kr.toxicity.hud.util.ListsKt;
import kr.toxicity.hud.util.MapsKt;
import kr.toxicity.hud.util.PluginsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\b\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR2\u0010\r\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lkr/toxicity/hud/manager/MinecraftManager;", "Lkr/toxicity/hud/manager/BetterHudManager;", "<init>", "()V", "ASSETS_LOCATION", "", "managerName", "getManagerName", "()Ljava/lang/String;", "supportExternalPacks", "", "getSupportExternalPacks", "()Z", "assetsMap", "", "Lkr/toxicity/hud/manager/MinecraftManager$MinecraftAsset;", "kr.toxicity.hud.shaded.kotlin.jvm.PlatformType", "", "applyAll", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lkr/toxicity/hud/text/ImageTextScale;", "Lkr/toxicity/hud/util/IntKeyMap;", "layout", "Lkr/toxicity/hud/layout/TextLayout;", "intGetter", "Lkr/toxicity/hud/shaded/kotlin/Function0;", "", "start", "", "previous", "Lkr/toxicity/hud/api/version/MinecraftVersion;", "reload", "workingDirectory", "Ljava/io/File;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "end", "MinecraftAsset", "dist"})
@SourceDebugExtension(value={"SMAP\nMinecraftManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftManager.kt\nkr/toxicity/hud/manager/MinecraftManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1869#2,2:141\n1563#2:143\n1634#2,3:144\n230#2,2:147\n1761#2,3:149\n*S KotlinDebug\n*F\n+ 1 MinecraftManager.kt\nkr/toxicity/hud/manager/MinecraftManager\n*L\n31#1:141,2\n78#1:143\n78#1:144,3\n80#1:147,2\n112#1:149,3\n*E\n"})
public final class MinecraftManager
implements BetterHudManager {
    @NotNull
    public static final MinecraftManager INSTANCE = new MinecraftManager();
    @NotNull
    private static final String ASSETS_LOCATION = "assets/minecraft/textures/";
    @NotNull
    private static final String managerName = "Minecraft";
    private static final boolean supportExternalPacks;
    private static final Set<MinecraftAsset> assetsMap;
    @Nullable
    private static MinecraftVersion previous;

    private MinecraftManager() {
    }

    @Override
    @NotNull
    public String getManagerName() {
        return managerName;
    }

    @Override
    public boolean getSupportExternalPacks() {
        return supportExternalPacks;
    }

    @NotNull
    public final Int2ObjectMap<ImageTextScale> applyAll(@NotNull TextLayout layout, @NotNull Function0<Integer> intGetter) {
        Intrinsics.checkNotNullParameter(layout, "layout");
        Intrinsics.checkNotNullParameter(intGetter, "intGetter");
        Int2ObjectOpenHashMap map = MapsKt.intKeyMapOf();
        Set<MinecraftAsset> set = assetsMap;
        Intrinsics.checkNotNullExpressionValue(set, "assetsMap");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MinecraftAsset it = (MinecraftAsset)element$iv;
            boolean bl = false;
            ((Map)map).put(intGetter.invoke(), it.toCharWidth(layout));
        }
        return (Int2ObjectMap)map;
    }

    @Override
    public void start() {
    }

    @Override
    public void reload(@NotNull File workingDirectory, @NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        if (ConfigManagerImpl.INSTANCE.getLoadMinecraftDefaultTextures()) {
            MinecraftVersion minecraftVersion = ConfigManagerImpl.INSTANCE.getMinecraftJarVersion();
            if (minecraftVersion == null) {
                MinecraftVersion minecraftVersion2 = PluginsKt.getBOOTSTRAP().minecraftVersion();
                minecraftVersion = minecraftVersion2;
                Intrinsics.checkNotNullExpressionValue(minecraftVersion2, "minecraftVersion(...)");
            }
            MinecraftVersion current = minecraftVersion;
            if (!assetsMap.isEmpty() && Intrinsics.areEqual(previous, current)) {
                return;
            }
            previous = current;
            assetsMap.clear();
            File cache = FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), ".cache");
            Result.box-impl(FunctionsKt.handleFailure(FunctionsKt.httpClient(arg_0 -> MinecraftManager.reload$lambda$0(current, cache, arg_0)), info, MinecraftManager::reload$lambda$1));
        } else {
            assetsMap.clear();
        }
    }

    @Override
    public void end() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit reload$lambda$0(MinecraftVersion $current, File $cache, HttpClient $this$httpClient) {
        Object object;
        Intrinsics.checkNotNullParameter($this$httpClient, "$this$httpClient");
        String[] stringArray = new String[]{"Getting minecraft default version..."};
        PluginsKt.info(stringArray);
        String[] stringArray2 = new InputStreamReader($this$httpClient.send(HttpRequest.newBuilder().uri(URI.create("https://piston-meta.mojang.com/mc/game/version_manifest_v2.json")).GET().build(), HttpResponse.BodyHandlers.ofInputStream()).body());
        int n = 8192;
        stringArray2 = stringArray2 instanceof BufferedReader ? (BufferedReader)stringArray2 : new BufferedReader((Reader)stringArray2, n);
        Object object2 = null;
        try {
            BufferedReader it = (BufferedReader)stringArray2;
            boolean bl = false;
            object = GsonsKt.parseJson(it);
        }
        catch (Throwable bl) {
            object2 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)stringArray2, (Throwable)object2);
        }
        JsonObject json = object.getAsJsonObject();
        stringArray2 = new String[]{"Current minecraft version: " + $current};
        PluginsKt.info(stringArray2);
        File file = new File($cache, $current + ".jar");
        if (!file.exists() || file.length() == 0L) {
            object2 = new String[]{$current + ".jar doesn't exist. so download it..."};
            PluginsKt.info(object2);
            object2 = new FileOutputStream(file);
            int n2 = 8192;
            object2 = new ZipOutputStream(object2 instanceof BufferedOutputStream ? (BufferedOutputStream)object2 : new BufferedOutputStream((OutputStream)object2, n2));
            object = null;
            try {
                BufferedReader it;
                Object element$iv2;
                int $i$f$first22;
                Collection<Object> collection;
                HttpClient httpClient;
                HttpRequest.Builder builder;
                HttpClient httpClient2;
                HttpRequest.Builder builder2;
                Object object3;
                Object outputStream;
                block31: {
                    void $this$first$iv;
                    Iterator $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    outputStream = (ZipOutputStream)object2;
                    boolean bl = false;
                    HttpRequest.Builder builder3 = HttpRequest.newBuilder();
                    HttpRequest.Builder builder4 = HttpRequest.newBuilder();
                    JsonArray jsonArray = json.getAsJsonArray("versions");
                    Intrinsics.checkNotNullExpressionValue(jsonArray, "getAsJsonArray(...)");
                    object3 = (Iterable)jsonArray;
                    builder2 = builder4;
                    httpClient2 = $this$httpClient;
                    builder = builder3;
                    httpClient = $this$httpClient;
                    boolean $i$f$map = false;
                    void var16_28 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        void it2;
                        Object item$iv$iv = iterator2.next();
                        JsonElement jsonElement = (JsonElement)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(it2.getAsJsonObject());
                    }
                    collection = (List)destination$iv$iv;
                    $this$map$iv = collection;
                    $i$f$first22 = 0;
                    for (Object element$iv2 : $this$first$iv) {
                        JsonObject it3 = (JsonObject)element$iv2;
                        boolean bl3 = false;
                        String string = it3.getAsJsonPrimitive("id").getAsString();
                        Intrinsics.checkNotNullExpressionValue(string, "getAsString(...)");
                        if (!Intrinsics.areEqual(FunctionsKt.toMinecraftVersion(string), $current)) continue;
                        break block31;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                collection = element$iv2;
                InputStream inputStream = httpClient2.send(builder2.uri(URI.create(((JsonObject)collection).getAsJsonPrimitive("url").getAsString())).GET().build(), HttpResponse.BodyHandlers.ofInputStream()).body();
                object3 = new InputStreamReader(inputStream);
                $i$f$first22 = 8192;
                object3 = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, $i$f$first22);
                Throwable $i$f$first22 = null;
                try {
                    it = (BufferedReader)object3;
                    boolean bl = false;
                    it = GsonsKt.parseJson(it);
                }
                catch (Throwable bl) {
                    $i$f$first22 = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, $i$f$first22);
                }
                BufferedReader bufferedReader = it;
                Closeable closeable = httpClient.send(builder.uri(URI.create(bufferedReader.getAsJsonObject().getAsJsonObject("downloads").getAsJsonObject("client").getAsJsonPrimitive("url").getAsString())).GET().build(), HttpResponse.BodyHandlers.ofInputStream()).body();
                Intrinsics.checkNotNullExpressionValue(closeable, "body(...)");
                int n3 = 8192;
                InputStream inputStream2 = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n3);
                closeable = new ZipInputStream(inputStream2);
                Throwable throwable = null;
                try {
                    ZipInputStream inputStream3 = (ZipInputStream)closeable;
                    boolean bl = false;
                    ZipEntry entry = inputStream3.getNextEntry();
                    while (entry != null) {
                        String string = entry.getName();
                        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                        if (StringsKt.startsWith$default(string, ASSETS_LOCATION, false, 2, null)) {
                            ((ZipOutputStream)outputStream).putNextEntry(entry);
                            ((FilterOutputStream)outputStream).write(inputStream3.readAllBytes());
                            ((ZipOutputStream)outputStream).closeEntry();
                        }
                        inputStream3.closeEntry();
                        entry = inputStream3.getNextEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                outputStream = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                object = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
        }
        object2 = new String[]{"Unzip textures..."};
        PluginsKt.info(object2);
        object2 = new JarFile(file);
        object = null;
        try {
            JarFile it = (JarFile)object2;
            boolean bl = false;
            Enumeration<JarEntry> enumeration = it.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, "entries(...)");
            ArrayList<JarEntry> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, "list(...)");
            ListsKt.forEachAsync((List)arrayList, arg_0 -> MinecraftManager.reload$lambda$0$2$0(it, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
        }
        return Unit.INSTANCE;
    }

    private static final Unit reload$lambda$0$2$0(JarFile $it, JarEntry s) {
        char[] $i$f$any2;
        List split;
        boolean bl;
        String sub;
        block8: {
            String string = s.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (!StringsKt.startsWith$default(string, ASSETS_LOCATION, false, 2, null)) {
                return Unit.INSTANCE;
            }
            String string2 = s.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            String string3 = string2;
            int n = 26;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            sub = string4;
            Iterable $this$any$iv = ConfigManagerImpl.INSTANCE.getIncludedMinecraftTextures();
            boolean $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String t = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default(sub, t, false, 2, null)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl && (split = StringsKt.split$default((CharSequence)sub, $i$f$any2 = new char[]{'.'}, false, 0, 6, null)).size() == 2 && Intrinsics.areEqual(split.get(1), "png")) {
            String n = StringsKt.substringAfterLast$default((String)split.get(0), '_', null, 2, null);
            Integer n2 = StringsKt.toIntOrNull(n);
            if (n2 != null) {
                int i = ((Number)n2).intValue();
                boolean bl3 = false;
                if (i == 0) {
                    MinecraftManager.reload$lambda$0$2$0$add($it, s, (String)split.get(0));
                }
            } else {
                MinecraftManager.reload$lambda$0$2$0$add($it, s, (String)split.get(0));
            }
        }
        return Unit.INSTANCE;
    }

    private static final void reload$lambda$0$2$0$add(JarFile $it, JarEntry $s, String name) {
        block0: {
            InputStream inputStream = $it.getInputStream($s);
            Intrinsics.checkNotNullExpressionValue(inputStream, "getInputStream(...)");
            InputStream inputStream2 = inputStream;
            int n = 8192;
            LoadedImage loadedImage = ImagesKt.removeEmptySide(ImagesKt.toImage(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n)));
            if (loadedImage == null) break block0;
            LoadedImage image = loadedImage;
            boolean bl = false;
            assetsMap.add(new MinecraftAsset(name, image.getImage().getWidth(), image.getImage().getHeight()));
        }
    }

    private static final String reload$lambda$1() {
        return "Unable to load minecraft default textures.";
    }

    static {
        assetsMap = Collections.synchronizedSet(new HashSet());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001b"}, d2={"Lkr/toxicity/hud/manager/MinecraftManager$MinecraftAsset;", "", "namespace", "", "width", "", "height", "<init>", "(Ljava/lang/String;II)V", "getNamespace", "()Ljava/lang/String;", "getWidth", "()I", "getHeight", "toCharWidth", "Lkr/toxicity/hud/text/ImageTextScale;", "layout", "Lkr/toxicity/hud/layout/TextLayout;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "dist"})
    @SourceDebugExtension(value={"SMAP\nMinecraftManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftManager.kt\nkr/toxicity/hud/manager/MinecraftManager$MinecraftAsset\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
    private static final class MinecraftAsset {
        @NotNull
        private final String namespace;
        private final int width;
        private final int height;

        public MinecraftAsset(@NotNull String namespace, int width, int height) {
            Intrinsics.checkNotNullParameter(namespace, "namespace");
            this.namespace = namespace;
            this.width = width;
            this.height = height;
        }

        @NotNull
        public final String getNamespace() {
            return this.namespace;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ImageTextScale toCharWidth(@NotNull TextLayout layout) {
            int n;
            Intrinsics.checkNotNullParameter(layout, "layout");
            String string = StringsKt.replace$default(this.namespace, '/', '_', false, 4, null);
            String string2 = "minecraft:" + this.namespace + ".png";
            PixelLocation pixelLocation = layout.getEmoji().getLocation();
            Integer n2 = ((TextElement)layout.getSource()).getTextScale();
            if (n2 != null) {
                void it;
                int n3 = ((Number)n2).intValue();
                PixelLocation pixelLocation2 = pixelLocation;
                String string3 = string2;
                String string4 = string;
                boolean bl = false;
                void var7_7 = it - this.height;
                string = string4;
                string2 = string3;
                pixelLocation = pixelLocation2;
                n = var7_7;
            } else {
                n = 0;
            }
            double d = this.height;
            double d2 = this.width;
            int n4 = n;
            PixelLocation pixelLocation3 = pixelLocation;
            String string5 = string2;
            String string6 = string;
            return new ImageTextScale(string6, string5, pixelLocation3, n4, d2, d);
        }

        @NotNull
        public final String component1() {
            return this.namespace;
        }

        public final int component2() {
            return this.width;
        }

        public final int component3() {
            return this.height;
        }

        @NotNull
        public final MinecraftAsset copy(@NotNull String namespace, int width, int height) {
            Intrinsics.checkNotNullParameter(namespace, "namespace");
            return new MinecraftAsset(namespace, width, height);
        }

        public static /* synthetic */ MinecraftAsset copy$default(MinecraftAsset minecraftAsset, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = minecraftAsset.namespace;
            }
            if ((n3 & 2) != 0) {
                n = minecraftAsset.width;
            }
            if ((n3 & 4) != 0) {
                n2 = minecraftAsset.height;
            }
            return minecraftAsset.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "MinecraftAsset(namespace=" + this.namespace + ", width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            int result = this.namespace.hashCode();
            result = result * 31 + Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MinecraftAsset)) {
                return false;
            }
            MinecraftAsset minecraftAsset = (MinecraftAsset)other;
            if (!Intrinsics.areEqual(this.namespace, minecraftAsset.namespace)) {
                return false;
            }
            if (this.width != minecraftAsset.width) {
                return false;
            }
            return this.height == minecraftAsset.height;
        }
    }
}

